import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { OutOfSystemPaymentComponent } from './out-of-system-payment.component';
import { MenuComponent } from '../../shared/menu/menu.component';
import { RouterTestingModule } from '@angular/router/testing';
import { FormsModule } from '@angular/forms';
import { HttpModule } from '@angular/http';
import { RestService } from '../../shared/service/rest.service';
import { WindowRefService } from '../../window-ref.service';

describe('OutOfSystemPaymentComponent', () => {
	let component: OutOfSystemPaymentComponent;
	let fixture: ComponentFixture<OutOfSystemPaymentComponent>;

	beforeEach(async(() => {
		TestBed.configureTestingModule({
			imports: [FormsModule, HttpModule, RouterTestingModule],
			declarations: [OutOfSystemPaymentComponent, MenuComponent],
			providers: [WindowRefService]
		})
			.compileComponents();
	}));

	beforeEach(() => {
		fixture = TestBed.createComponent(OutOfSystemPaymentComponent);
		component = fixture.componentInstance;
		fixture.detectChanges();
	});

	it('should be created', () => {
		expect(component).toBeTruthy();
	});
	it('should grab available CARCs', () => {
		component.paymentInfo.adjustments[1].groupCode = component.groupCodes[0];
		component.setAvailableCARCs(1);
		expect(component.availableCARCs[1].length > 1).toBeTruthy();
	});
});
