import { Claims } from '../../shared/models/Claims';
import { Injectable } from '@angular/core';
import {
    Http,
    Response,
    Headers,
    Jsonp,
    RequestOptions,
    URLSearchParams
} from '@angular/http';

import { Observable } from 'rxjs/Observable';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/do';
import 'rxjs/add/operator/catch';
import { environment } from '../../../environments/environment';

@Injectable()
export class InProcessClaimsService {
    constructor(private http: Http) { }

    public getClaims(requestBody) {
        console.log('sending request to the node');
        return this.http.post(environment.nodeserver + '/claims/inProcess/', requestBody)
            .map((res: Response) => res.json())
            .catch((error: Response) => Observable.throw(error.json));
    }

}
