import { Component, Input, OnInit, OnChanges } from '@angular/core';
import { Claims } from '../../shared/models/Claims';
import { Router } from '@angular/router';
import { SharedDataService } from '../../shared/service/shared-data.service';
import { TableComponent } from '../../shared/table/table.component';
import { AwaitingProcessingRequest } from '../../shared/models/AwaitingProcessingRequest';
import { InProcessClaimsService } from './in-process.service';
import { Headers, RequestOptions, URLSearchParams } from '@angular/http';
import { TableService } from '../../shared/table/table.service';
import { ReconcileService } from '../../claims/claim-detail/reconcile/reconcile.service';
import { RestService } from '../../shared/service/rest.service';
import { ColumnMetadata } from 'app/shared/table/cols.model';
import { RerouteService } from '../../shared/reroute/reroute.service';

@Component({
  selector: 'app-in-process',
  templateUrl: './in-process.component.html'
})
export class InProcessClaimsComponent implements OnInit, OnChanges {
  // @Input() btnClassPrimary = "button primary"; // Added these back in
  // @Input() btnClassSecondary = "button secondary"; // Added these back in
  listFilter = '';
  allClaimsSelectedCheckMarked = false;
  printButtonLabel: String = 'Print';
  rerouteButtonLabel: String = 'Reroute';
  disapproveButtonLabel: String = 'Disapprove';
  reconcileButtonLabel: String = 'Reconcile';
  fetchingData = true;
  public ids: number[];
  public activeStations: string[];
  public visns: string[];
  public privacyRestrictions: string[];
  public userName: string;
  public headers = new Headers();
  public counter: number;
  public awaitingProcessingRequest: AwaitingProcessingRequest;
  claims: any[];
  cols: ColumnMetadata[] = [
    new ColumnMetadata('select', 'Select?').setSelectBox(true),
    new ColumnMetadata('claimId', 'Claim ID').setAlign('right'),
    new ColumnMetadata('claimType', 'Claim Type'),
    new ColumnMetadata('hero', 'HERO'),
    new ColumnMetadata('veteranName', 'Name'),
    new ColumnMetadata('claimDate', 'Claim Date').setAlign('right'),
    new ColumnMetadata('dateInProcess', 'Date In Proc').setAlign('right'),
    new ColumnMetadata('providerName', 'Provider'),
    new ColumnMetadata('lines', 'Total Lines').setAlign('right'),
    new ColumnMetadata('linesClosed', 'Lines Closed').setAlign('right'),
    new ColumnMetadata('facility', 'Facility').setAlign('right')
  ];
  constructor(
    private router: Router,
    private sharedData: SharedDataService,
    private inProcessClaimsService: InProcessClaimsService,
    private rerouteService: RerouteService
  ) {}

  ngOnInit() {
    if (
      !!sessionStorage.getItem('activeStations') &&
      !!sessionStorage.getItem('visns') &&
      !!sessionStorage.getItem('privacyRestrictions')
    ) {
      this.activeStations = sessionStorage.getItem('activeStations').split(',');
      this.visns = sessionStorage.getItem('visns').split(',');
      this.privacyRestrictions = sessionStorage
        .getItem('privacyRestrictions')
        .split(',');
      this.claims = this.sharedData.inprocessStorage;
    }
    // console.log(this.claims);
    if (this.claims) {
      this.claims.forEach(claim => (claim.selected = false));
    }
    this.allClaimsSelectedCheckMarked = false;
    this.awaitingProcessingRequest = new AwaitingProcessingRequest(
      this.userName,
      this.ids,
      this.activeStations,
      this.visns,
      this.privacyRestrictions
    );
    this.headers.append('Content-Type', 'application/json');
    // console.log(
    //     'inprocessing request is : ' +
    //     JSON.stringify(this.awaitingProcessingRequest)
    // );
    const options = new RequestOptions({
      headers: this.headers,
      body: this.awaitingProcessingRequest
    });
    this.inProcessClaimsService.getClaims(options).subscribe(
      data => (this.claims = data),
      error => alert(error),
      () =>
        this.claims.forEach(claim => {
          claim.selected = false;
          claim.claimIdLink = '/claimDetail/' + claim.claimId;
          this.fetchingData = false;
        })
    );
  }
  onClickRowCheckMark() {
    this.allClaimsSelectedCheckMarked = this.isAllChecked();
  }

  ngOnChanges() {
    this.allClaimsSelectedCheckMarked = this.isAllChecked();
  }

  onClickSelectAll(event) {
    this.claims.forEach(claim => (claim.selected = event.target.checked));
    this.allClaimsSelectedCheckMarked = event.target.checked;
  }

  isAllChecked(): boolean {
    if (this.claims) {
      return this.claims.every(claim => claim.selected);
    }
    return false;
  }
  isNoneChecked(): boolean {
    if (this.claims) {
      return this.claims.every(claim => !claim.selected);
    }
  }
  // method to reroute claims
  onReroute() {
    const selectedClaims = this.claims.filter(claim => claim.selected);
    this.rerouteService.setClaims(selectedClaims);
    this.router.navigate(['reroute']);
  }
}
