import {
  async,
  getTestBed,
  ComponentFixture,
  TestBed
} from '@angular/core/testing';
import { InProcessClaimsComponent } from './in-process.component';
import { MenuComponent } from '../../shared/menu/menu.component';
import { By } from '@angular/platform-browser';
import { NavButtonComponent } from '../../shared/nav-button/nav-button.component';
import { TableComponent } from '../../shared/table/table.component';
import { RouterTestingModule } from '@angular/router/testing';
import { FormsModule } from '@angular/forms';
import { Headers, BaseRequestOptions, Http, HttpModule } from '@angular/http';
import { SharedDataService } from '../../shared/service/shared-data.service';
import { DebugElement, SimpleChanges } from '@angular/core';
import { PrintComponent } from '../../shared/print/print.component';
import { InProcessClaimsService } from './in-process.service';
import { PrintService } from '../../shared/print/service/print.component.service';
import { PaginationComponent } from '../../shared/table/pagination/pagination.component';
import { NumPerPageComponent } from '../../shared/table/numPerPage/numPerPage.component';

import { SpinnerComponent } from '../../shared/spinner/spinner.component';
import { NumResultsComponent } from '../../shared/table/numResults/numResults.component';
import { WindowRefService } from '../../window-ref.service';

describe('InProcessClaimsComponent', () => {
  let component: InProcessClaimsComponent;
  let fixture: ComponentFixture<InProcessClaimsComponent>;

  beforeEach(
    async(() => {
      TestBed.configureTestingModule({
        imports: [HttpModule, RouterTestingModule, FormsModule],
        declarations: [
          InProcessClaimsComponent,
          MenuComponent,
          NavButtonComponent,
          PrintComponent,
          TableComponent,
          PaginationComponent,
          NumPerPageComponent,
          SpinnerComponent,
          NumResultsComponent
        ],
        providers: [
          SharedDataService,
          InProcessClaimsService,
          PrintService,
          WindowRefService
        ]
      }).compileComponents();
    })
  );

  beforeEach(() => {
    fixture = TestBed.createComponent(InProcessClaimsComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should be created', () => {
    expect(component).toBeTruthy();
  });

  it('should have upper "print" button Visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperPrint')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have upper "print" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperPrint')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have lower "print" button Visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerPrint')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have lower "print" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerPrint')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have upper "Reroute" button Visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperRerouteButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have upper "Reroute" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperRerouteButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have lower "Reroute" button Visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerRerouteButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have lower "Reroute" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerRerouteButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have upper "Disapprove" button Visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperDisapproveButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have upper  "Disapprove " button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperDisapproveButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have lower "Disapprove" button Visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerDisapproveButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have lower "Disapprove" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerDisapproveButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have "table" displayed', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#table')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
  });
});
