import { Injectable } from '@angular/core';
import 'rxjs/add/operator/map';
import { Observable } from 'rxjs/Observable';
import {
    RequestOptions,
    URLSearchParams,
    Headers,
    Response,
    Http
} from '@angular/http';
import { environment } from '../../../../environments/environment';

@Injectable()
export class DisapproveService {
    toBeDisapproved: any[] = [];
    constructor(private http: Http) { }

    public getReasonCodesAndDescriptions(
        requestOptions: RequestOptions
    ): Observable<any> {
        return this.executeRestForUrl(
            environment.nodeserver + '/claims/reasons/',
            requestOptions
        );
    }

    public getClaims(requestBody) {
        console.log('sending request to the node for claims');
        return this.http
            .post(environment.nodeserver + '/claimsToDispprove', requestBody)
            .map((res: Response) => res.json());
        // .catch((error: Response) => Observable.throw(error.json));
    }

    public disapproveClaims(requestBody) {
        console.log('sending request to the node for claims');
        return this.http
            .post(environment.nodeserver + '/disapprove', requestBody)
            .map((res: Response) => res.json());
        // .catch((error: Response) => Observable.throw(error.json));
    }

    public executeRestForUrl(
        url: string,
        requestOptions: RequestOptions
    ): Observable<any[]> {
        const responseData = this.http
            .get(url, requestOptions)
            .map((res: Response) => <any[]>res.json());
        return responseData;
    }
}
