import { Component, Input, OnInit, ViewChild } from '@angular/core';
import { Router } from '@angular/router';
import { SharedDataService } from '../../shared/service/shared-data.service';
// import { NgForm } from '@angular/forms';
import { DisapproveClaim } from './disapprove.component.model';
import { DisapproveService } from './service/disapprove.service';
import { Headers, RequestOptions, URLSearchParams } from '@angular/http';

interface ReasonCodeDescription {
  code: string;
  claimReasons: string;
}

// 'userName' : 'dummy',   -> the username of the current user
// 'reason' : '123',   -> Reason code
// 'comments' : 'Processed based on multiple or concurrent procedure rules.',    comments that are typed in the comment section
// 'claimId' : [129, 102]   -> Claim Id’s from the table.

@Component({
  selector: 'app-disapprove',
  templateUrl: './disapprove.component.html',
  styleUrls: ['./disapprove.component.scss']
})
export class DisapproveComponent implements OnInit {
  @Input() claims: any[];
  disapproveClaimParam: DisapproveClaim;
  validReasons: any[] = [];
  claimIds: string[] = [];
  claimIds2: string[] = [];
  claimsToDisplay: any = [];
  userName: String;
  reasons: any[];
  input = {};
  errorMessage: String;
  public btnClicked: boolean;
  disapprovedClaims: number[] = [];
  failedClaims: number[] = [];

  cols: any[] = [
    { name: 'Claim ID', id: 'claimId', number: true },
    { name: 'Veteran Name', id: 'veteranName' },
    { name: 'Service Provider', id: 'serviceProvider' },
    { name: 'Billing Provider', id: 'billingProvider' }
  ];

  headers = new Headers();
  karmaUnitTesingBeingDone = false;

  constructor(
    private sharedData: SharedDataService,
    public router: Router,
    private disapproveService: DisapproveService
  ) {}

  ngOnInit() {
    let i = 0;
    this.btnClicked = false;
    this.userName = sessionStorage.getItem('userName');
    this.claims = this.sharedData.storage;
    for (const claim of this.claims) {
      this.claimIds[i] = claim['claimId'].toString();
      i++;
    }

    // Executed when no Karma Unit Testing is being done.
    if (!this.karmaUnitTesingBeingDone) {
      const options = new RequestOptions({ headers: this.headers });
      this.disapproveService.getReasonCodesAndDescriptions(options).subscribe(
        // data => this.validReasons = data,
        data => {
          this.reasons = data.disapproveClaimsReasons;
          this.reasons.forEach(reasonCodeDescription => {
            const aReasonCodeDescription: ReasonCodeDescription = reasonCodeDescription;
            const code = aReasonCodeDescription.code;
            const description =
              code + ' : ' + aReasonCodeDescription.claimReasons;
            this.validReasons.push({ code: code, description: description });
          });
        },
        error => alert(error)
      );
      const options2 = new RequestOptions({
        headers: this.headers,
        body: this.claimIds
      });

      this.disapproveService.getClaims(options2).subscribe(
        data => {
          this.claimsToDisplay = data.claimsToDisapprove;
          for (const claim of this.claimsToDisplay) {
            if (claim.claimId !== undefined) {
              this.claimIds2.push(claim.claimId);
            } else if (claim.message !== undefined) {
              this.errorMessage = claim.message;
            }
          }

          console.log('claimIds2' + this.claimIds2);
        },
        error => alert(error)
      );
    }

    this.disapproveClaimParam = new DisapproveClaim('', '');

    // Debugging Code: Norammly comment out.
    /*
		this.btnClicked = true;
		let messages = [
			{ 'status': 300, 'message': 123 },
			{ 'status': 200, 'message': 124 },
			{ 'status': 200, 'message': 125 },
			{ 'status': 300, 'message': 126 }
		];
		this.displayConfirmation(messages);
		*/
  }

  onClickDisapproveClaims() {
    console.log('Inside of DisapproveComponent.onClickDisapproveClaims()!');
    this.input = {
      userName: this.userName,
      reason: this.disapproveClaimParam.reason,
      comments: this.disapproveClaimParam.comment,
      claimId: this.claimIds2
    };

    const options3 = new RequestOptions({
      headers: this.headers,
      body: this.input
    });

    this.disapproveService.disapproveClaims(options3).subscribe(
      data => {
        this.displayConfirmation(data.disapproveClaims);
      },
      error => alert(error),
      () => console.log()
    );
  }

  displayConfirmation(message: any) {
    this.btnClicked = true;
    if (message != null || message !== undefined) {
      for (const msg of message) {
        if (msg.status === '200') {
          this.disapprovedClaims.push(msg.message);
        } else {
          this.failedClaims.push(msg.message);
        }
      }
    } else {
      console.log('Total this.message is null');
    }
  }

  isDisapproveButtonDisabled() {
    if (this.disapproveClaimParam.reason === null) {
      return true;
    }

    if (this.disapproveClaimParam.reason.length === 0) {
      return true;
    }

    if (this.claimsToDisplay === null) {
      return true;
    }

    if (this.claimsToDisplay.length === 0) {
      return true;
    }

    return false;
  }

  onClickCancel() {
    console.log('Inside of DisapproveComponent.onClickCancel()!');
    this.router.navigate(['claimsHomePage']);
  }
}
