import { async, ComponentFixture, TestBed } from "@angular/core/testing";
import { RouterTestingModule } from "@angular/router/testing";
import { ClaimsHomePageComponent } from "./claims-home-page.component";
import { MenuComponent } from "../../shared/menu/menu.component";
import { DebugElement, SimpleChanges } from "@angular/core";
import { By } from "@angular/platform-browser";
import { WindowRefService } from "../../window-ref.service";

describe("ClaimsHomePageComponent", () => {
  let component: ClaimsHomePageComponent;
  let fixture: ComponentFixture<ClaimsHomePageComponent>;

  beforeEach(
    async(() => {
      TestBed.configureTestingModule({
        imports: [RouterTestingModule],
        declarations: [ClaimsHomePageComponent, MenuComponent],
        providers: [WindowRefService]
      }).compileComponents();
    })
  );

  beforeEach(() => {
    fixture = TestBed.createComponent(ClaimsHomePageComponent);
    component = fixture.componentInstance;

    const userInfo = {
      permissions: {
        claimsMenu: {
          paymentError: "true",
          unmatchedPayments: "true",
          inprocess: "true",
          aged: "true",
          searchClaim: "true",
          rejectClaims: "true",
          awaitingProcessing: "true"
        },
        reportsMenu: {
          claimsAwaitingProcessing: "true",
          reroutedClaims: "true",
          claimsInprocessSummary: "true",
          vistAError: "true",
          claimsCompleted: "true",
          CPEReport: "true",
          claimsCompletedSummary: "true",
          claimsInprocess: "true",
          outOfSystemPaymentsSummary: "true",
          BPPR16: "true",
          outOfSystemPayments: "true",
          claimsAwaitingProcessingSummary: "true",
          feeReport: "true"
        }
      }
    };

    sessionStorage.setItem("userInfo", JSON.stringify(userInfo));
    fixture.detectChanges();
  });

  it("should be created", () => {
    expect(component).toBeTruthy();
  });

  it('should have a link to navigate to "search claim" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#search")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have a link to navigate to "Awaiting claim" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#awaiting")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have a link to navigate to "Inprocess claim" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#inprocess")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have a link to navigate to "Aged claim" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#aged")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have a link to navigate to "Payment Error" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#payment")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have a link to navigate to "Reject claim" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#reject")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have a link to navigate to "Unmatched payments" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#unmatched")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });
});
