import {
  Component,
  Input,
  OnInit,
  ViewChild,
  OnChanges,
  ElementRef
} from '@angular/core';
import { NgForm } from '@angular/forms';
import { RequestOptions } from '@angular/http';
import { Router } from '@angular/router';

import { environment } from '../../../environments/environment';
import { ClaimLookUpComponentService } from './claim-look-up.component.service';
import { RerouteService } from '../../shared/reroute/reroute.service';
import { TableComponent } from '../../shared/table/table.component';
import { SearchClaim } from './claim-look-up.component.model';
import { SharedDataService } from '../../shared/service/shared-data.service';
import { ScriptService } from '../../shared/scriptLoader/script.service';
import { ColumnMetadata } from '../../shared/table/cols.model';
import { TableOptions } from '../../shared/table/table-options.model';
import { TableService } from '../../shared/table/table.service';
import { ReconcileService } from '../../claims/claim-detail/reconcile/reconcile.service';

@Component({
  selector: 'app-claim-look-up',
  templateUrl: './claim-look-up.component.html',
  providers: [ScriptService, TableService, ReconcileService]
})
export class ClaimLookUpComponent implements OnInit, OnChanges {
  // Declare variables for searching
  searchParam: SearchClaim = new SearchClaim();
  modalClosed = true; // For modal function...
  @Input() btnClassPrimary = 'button primary';
  @Input() btnClassSecondary = 'button secondary';
  f: NgForm;
  @ViewChild('f') currentForm: NgForm;
  public ssnShowError = false;
  public showError = new Array(10).fill(false);

  listFilter = '';
  public title = 'Claim Search';
  public user: string;
  public searched = false;
  public claims: any[] = [];
  selectedClaims: any[] = [];
  public reRouted: any[] = [];
  allClaimsSelectedCheckMarked = false;
  public tempDate;
  fetchingData = false;
  public claimSearchPermissions;
  @ViewChild(TableComponent) tableComponent: TableComponent;
  @ViewChild('startingDate') startingDate: ElementRef;
  @ViewChild('endingDate') endingDate: ElementRef;
  public cols: any[] = [
    new ColumnMetadata('select', 'Select?').setSelectBox(true),
    new ColumnMetadata('claimId', 'Claim ID').setAlign('right'),
    new ColumnMetadata('claimType', 'Type'),
    new ColumnMetadata('claimStatus', 'Status'),
    new ColumnMetadata('hero', 'HERO'),
    new ColumnMetadata('veteranName', 'Name'),
    new ColumnMetadata('ssn', 'SSN').setAlign('right'),
    new ColumnMetadata('patientControlNumber', 'Patient Control#').setAlign(
      'right'
    ),
    new ColumnMetadata('serviceDate', 'Service Date').setAlign('right'),
    new ColumnMetadata('providerName', 'Provider'),
    new ColumnMetadata('providerTin', 'Pr TIN').setAlign('right'),
    new ColumnMetadata('providerNpi', 'Pr NPI').setAlign('right'),
    new ColumnMetadata('facility', 'Facility').setAlign('right')
  ];
  tableOptions = new TableOptions().setAfterLoad(function (items) {
    items.forEach(claim => {
      claim.selected = false;
      claim.claimIdLink = '/claimDetail/' + claim.claimId;
    });
  });
  constructor(
    private searchComponentService: ClaimLookUpComponentService,
    private sharedData: SharedDataService,
    private script: ScriptService,
    private rerouteService: RerouteService,
    private router: Router
  ) {
    this.script
      .load('datepicker')
      .then(data => { })
      .catch(error => console.log(error));
  }

  ngOnInit() {
    this.onClickClear();
    this.searchComponentService.setRerouted(this.sharedData.storage);
    this.getUserPermissions();
  }


  // Gets the permission from the session, It is used in the html to show and hide things
  getUserPermissions() {
    if (sessionStorage.getItem('userInfo')) {
      this.claimSearchPermissions = JSON.parse(
        sessionStorage.getItem('userInfo')
      )['permissions']['searchClaim'];
    }
  }

  saveBeginDate() {
    this.searchParam.beginServiceDate = this.startingDate.nativeElement.value;
  }
  saveEndDate() {
    this.searchParam.endServiceDate = this.endingDate.nativeElement.value;
  }

  // Search Function
  searchClaim(valid: boolean) {
    this.fetchingData = true;
    this.searched = true;
    if (!valid) {
      this.ssnShowError = true;
      this.showError = Array(10).fill(true);
      return;
    }
    // tell the tableComponent to update, then add computed values to claims
    this.tableComponent.restUpdate().subscribe(data => {
      data.forEach(claim => {
        claim.selected = false;
        claim.claimIdLink = '/claimDetail/' + claim.claimId;
        console.log('response', claim)
      });
      this.fetchingData = false;
    });
  }

  ngOnChanges() {
    this.allClaimsSelectedCheckMarked = this.isAllChecked();
  }

  onClickClear() {
    this.searchParam = new SearchClaim();
    this.searchParam.claimStatus = 'ESTABLISH';
    this.searchParam.claimType = 'INST';
  }

  isAllChecked(): boolean {
    return this.claims.every(claim => claim.selected);
  }

  isNoneChecked(): boolean {
    return this.claims.every(claim => !claim.selected);
  }

  onReroute() {
    const selectedClaims = this.claims.filter(claim => claim.selected);
    this.rerouteService.setClaims(selectedClaims);
    this.router.navigate(['reroute']);
  }

  // Modal Function

  onModalOpen() {
    this.modalClosed = false;
  }
  onModalClose(bool) {
    this.modalClosed = bool;
  }
}
