import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { ClaimLookUpComponent } from './claim-look-up.component';
import { MenuComponent } from '../../shared/menu/menu.component';
import { Headers, BaseRequestOptions, Http, HttpModule } from '@angular/http';
import { FormsModule } from '@angular/forms';
import { NavButtonComponent } from '../../shared/nav-button/nav-button.component';
import { TableComponent } from '../../shared/table/table.component';
import { RouterTestingModule } from '@angular/router/testing';
import { DebugElement, SimpleChanges } from '@angular/core';
import { By } from '@angular/platform-browser';
import { SharedDataService } from '../../shared/service/shared-data.service';
import { ClaimLookUpComponentService } from './claim-look-up.component.service';
import { PrintComponent } from '../../shared/print/print.component';
import { PrintService } from '../../shared/print/service/print.component.service';
import { RestService } from '../../shared/service/rest.service';
import { PaginationComponent } from '../../shared/table/pagination/pagination.component';
import { NumPerPageComponent } from '../../shared/table/numPerPage/numPerPage.component';
import { RerouteService } from '../../shared/reroute/reroute.service';
import { WindowRefService } from './../../../app/window-ref.service';
import { SpinnerComponent } from '../../shared/spinner/spinner.component';
import { NumResultsComponent } from '../../shared/table/numResults/numResults.component';

describe('ClaimLookUpComponent', () => {
  let component: ClaimLookUpComponent;
  let fixture: ComponentFixture<ClaimLookUpComponent>;

  beforeEach(
    async(() => {
      TestBed.configureTestingModule({
        imports: [HttpModule, FormsModule, RouterTestingModule],
        declarations: [
          ClaimLookUpComponent,
          MenuComponent,
          NavButtonComponent,
          PrintComponent,
          TableComponent,
          PaginationComponent,
          NumPerPageComponent,
          NumResultsComponent,
          SpinnerComponent
        ],
        providers: [
          WindowRefService,
          SharedDataService,
          ClaimLookUpComponentService,
          PrintService,
          RestService,
          RerouteService,
          SpinnerComponent
        ]
      }).compileComponents();
    })
  );

  beforeEach(() => {
    fixture = TestBed.createComponent(ClaimLookUpComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should be created', () => {
    expect(component).toBeTruthy();
  });

  it('should have "Claim Type" element', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css('#claimType')
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.textContent).toBeTruthy();
  });

  it('should have "4" options in Claim Type element', () => {
    const debugElement: DebugElement[] = fixture.debugElement.queryAll(
      By.css('#claimType option')
    );
    expect(debugElement.length).toBe(4);
  });

  it('should have the correct options in Claim Type element', () => {
    let debugElement: DebugElement[] = fixture.debugElement.queryAll(
      By.css('#claimType option')
    );
    let htmlInputElement1: HTMLInputElement = debugElement[0].nativeElement;
    let htmlInputElement2: HTMLInputElement = debugElement[1].nativeElement;
    let htmlInputElement3: HTMLInputElement = debugElement[2].nativeElement;
    let htmlInputElement4: HTMLInputElement = debugElement[3].nativeElement;

    expect(htmlInputElement1.value).toBe('INST');
    expect(htmlInputElement2.value).toBe('PROF');
    expect(htmlInputElement3.value).toBe('DENT');
    expect(htmlInputElement4.value).toBe('');
  });

  it('should have "Claim Status" element', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#claimStatus')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.textContent).toBeTruthy();
  });

  it('should have "7" options in Claim Status element', () => {
    let debugElement: DebugElement[] = fixture.debugElement.queryAll(
      By.css('#claimStatus option')
    );
    expect(debugElement.length).toBe(7);
  });

  it('should have the correct options in Claim Status element', () => {
    let debugElement: DebugElement[] = fixture.debugElement.queryAll(
      By.css('#claimStatus option')
    );
    let htmlInputElement1: HTMLInputElement = debugElement[0].nativeElement;
    let htmlInputElement2: HTMLInputElement = debugElement[1].nativeElement;
    let htmlInputElement3: HTMLInputElement = debugElement[2].nativeElement;
    let htmlInputElement4: HTMLInputElement = debugElement[3].nativeElement;
    let htmlInputElement5: HTMLInputElement = debugElement[4].nativeElement;
    let htmlInputElement6: HTMLInputElement = debugElement[5].nativeElement;
    let htmlInputElement7: HTMLInputElement = debugElement[5].nativeElement;
    expect(htmlInputElement1.value).toBe('ESTABLISH');
    expect(htmlInputElement2.value).toBe('INPROCESS');
    expect(htmlInputElement3.value).toBe('AGED');
    expect(htmlInputElement4.value).toBe('PAYERROR');
    expect(htmlInputElement5.value).toBe('REJECTED');
    expect(htmlInputElement6.value).toBe('COMPLETE');
    expect(htmlInputElement7.value).toBe('COMPLETE');
  });

  it('should have "last name" element', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lastName')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have "provider name" element', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#providerName')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have "check/eft/trn" element', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#check')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have "ssn" element', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#ssn'));
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have "provider tin" element', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#providerTin')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have "begin Date" element', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#beginDate')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have "end Date" element', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#endDate')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have "claim Id" element', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#claimId')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have "hero" element', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#hero')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have "visn" element', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#visn')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have "patient Number" element', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#patientNumber')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have upper "search" button Visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#search')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have upper "search" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#search')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have lower "clear" button Visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#clear')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have lower "clear" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#clear')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });
});
