import { Claims } from '../../shared/models/Claims';
import { Injectable } from '@angular/core';
import { Http, Response, Headers, Jsonp, RequestOptions, URLSearchParams } from '@angular/http';
import { Observable } from 'rxjs/Observable';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/do';
import 'rxjs/add/operator/catch';

@Injectable()
export class ClaimLookUpComponentService {

	public rerouted: any[] = [];

	public setRerouted(selected: any[]) {
		this.rerouted = this.rerouted.concat(selected);
	}

	public getRerouted() {
		return this.rerouted;
	}
	constructor(private http: Http) { }


	public getSearchResult(searchoptions): Observable<Claims[]> {
		console.log('http://localhost:4000/api/fpps/claims/', searchoptions);
		return this.executeRestForUrl('http://localhost:4000/api/fpps/claims/', searchoptions);
	}

	public executeRestForUrl(url: string, searchoptions: RequestOptions): Observable<Claims[]> {
		const responseData = this.http.get(url, searchoptions)
			.map((res: Response) => <Claims[]>res.json());
		return responseData;
	}
}
