import { Injectable } from '@angular/core';
import { Http, Response } from '@angular/http';
import { Observable } from 'rxjs/Observable';

import { environment } from '../../../../environments/environment';

import 'rxjs/add/operator/map';

@Injectable()
export class ReconcileService {
  claimId;
  currentClaim: any;
  constructor(private http: Http) {
    // this.setClaimId = this.setClaimId.bind(this);
  }
  // method to set selected claimId from claim-details
  setClaimId(id) {
    this.claimId = id;
  }
  getClaimId(): Observable<string> {
    return new Observable(observer => observer.next(this.claimId));
  }

  getClaim() {
    return this.http
      .get(`${environment.nodeserver}/reconciliation/${this.claimId}`)
      .map((response: Response) => (this.currentClaim = response.json()));
  }

  onReconciliationSearch(term) {
    return this.http
      .post(`${environment.nodeserver}/reconciliation/`, term)
      .map((response: Response) => response.json());
  }
  getPaymentLineItems(id) {
    return this.http
      .get(`${environment.nodeserver}/reconciliation/paymentLines/${id}`)
      .map((response: Response) => response.json());
  }
  getLineItems() {
    return this.http
      .get(`${environment.nodeserver}/reconciliation/lineItems/${this.claimId}`)
      .map((response: Response) => response.json());
  }
  getAdjustmentGroups() {
    return this.http
      .get(`${environment.nodeserver}/reconciliation/groups/`)
      .map((response: Response) => response.json());
  }
  getAdjustmentReasons() {
    return this.http
      .get(`${environment.nodeserver}/reconciliation/reasons/`)
      .map((response: Response) => response.json());
  }

  editPaymentInformation(body) {
    return this.http
      .post(
      `${environment.nodeserver}/reconciliation/editPaymentInformation`,
      body
      )
      .map((response: Response) => response.json());
  }
  getClaimPaymentInformation(id) {
    return this.http
      .get(
      `${environment.nodeserver}/reconciliation/editPaymentInformation/${id}`
      )
      .map((response: Response) => response.json());
  }
}
