import { Component, OnInit } from "@angular/core";
import { Router } from "@angular/router";
import { NgForm } from "@angular/forms";

import { ReconcileService } from "./reconcile.service";
import { ScriptService } from "../../../shared/scriptLoader/script.service";

@Component({
  selector: "app-reconcile",
  templateUrl: "./reconcile.component.html",
  styleUrls: ["./reconcile.component.scss"],
  providers: [ScriptService]
})
export class ReconcileComponent implements OnInit {
  claimId;
  currentClaim;
  selectedClaim;
  selectedClaims = [];
  currentLineItem;
  searchResults;
  feeClaimPaymentLineId;
  selectedPaymentLineItem;
  noData = false;
  successfullMessage = false;
  paymentEdit = false;
  editPaymentInformation;
  validFields = [false, false, false, false];
  defaultSelectValue = ["-- Select Group --", "-- Select Reason --"];
  // claim payment information adjustment group input
  groups;
  // claim payment information adjustment reasons input
  reasons;

  constructor(
    private script: ScriptService,
    private router: Router,
    private reconcileService: ReconcileService
  ) {
    this.script
      .load("datepicker")
      .then(data => {})
      .catch(error => console.log(error));
  }

  ngOnInit() {
    // getting claim that was passed from claim-detail through reconcileService.
    this.reconcileService.getClaimId().subscribe(id => (this.claimId = id));
    this.reconcileService
      .getClaim()
      .subscribe(response => (this.currentClaim = response));
    this.reconcileService
      .getLineItems()
      .subscribe(response => (this.currentLineItem = response.claimLineItems));
    this.reconcileService.getAdjustmentGroups().subscribe(response => {
      this.groups = response.adjustmentGroups;
    });
    this.reconcileService.getAdjustmentReasons().subscribe(response => {
      this.reasons = response.adjustmentReasons;
    });
  }
  // search claims
  onSubmit(f: NgForm) {
    const reconciliationType = f.value.reconciliationType;
    const drgCode = f.value.drgCode;
    const billedAmount = f.value.billedAmount;
    const resolutionStatus = f.value.resolutionStatus;
    const feeInvoiceNumber = f.value.feeInvoiceNumber;
    const drgWeight = f.value.drgWeight;
    const paidAmount = f.value.paidAmount;
    const invoiceDate = f.value.invoiceDate;
    const searchTerm = {
      reconciliationType: reconciliationType,
      drgCode: drgCode,
      billedAmount: billedAmount,
      resolutionStatus: resolutionStatus,
      feeInvoicenumber: feeInvoiceNumber,
      drgWeight: drgWeight,
      paidAmount: paidAmount,
      invoiceDate: invoiceDate
    };

    this.validFields = this.validation(f);
    if (this.validFields.every(val => val === false)) {
      this.reconcileService.onReconciliationSearch(searchTerm).subscribe(
        response => {
          // console.log('in node response', response)
          this.searchResults = response;
        },
        error => console.log("error ", error)
      );
    }
  }
  // submits adjustments
  onClaimPaymentSubmit(f: NgForm) {
    const lineNumber = this.selectedPaymentLineItem.lineNumber;
    const adjustment1 = f.value.adjustment1;
    const adjustment2 = f.value.adjustment2;
    const group1 = f.value.group1;
    const group2 = f.value.group2;
    const reason1 = f.value.reason1;
    const reason2 = f.value.reason2;
    const claimPaymentEdit = {
      feeClaimPaymentLineId: this.feeClaimPaymentLineId,
      claimId: this.claimId,
      lineNumber: lineNumber,
      adjustment1: adjustment1,
      adjustment2: adjustment2,
      group1: group1,
      group2: group2,
      reason1: reason1,
      reason2: reason2
    };
    for (const prop in claimPaymentEdit) {
      if (
        claimPaymentEdit[prop] === "-- Select Group --" ||
        claimPaymentEdit[prop] === "-- Select Reason --"
      ) {
        claimPaymentEdit[prop] = null;
      }
    }

    this.reconcileService
      .editPaymentInformation(claimPaymentEdit)
      .subscribe(response => {
        // if (response.response === 'Claim Reconciled successfully ') {
        if (response.response) {
          this.onSuccessfull();
        }
      });
    this.paymentEdit = false;
  }
  onSelect(id) {
    // rest call
    if (this.feeClaimPaymentLineId !== id) {
      this.feeClaimPaymentLineId = id;
      this.reconcileService.getPaymentLineItems(id).subscribe(item => {
        if (item.paymentLineItemsResponse.length === 0) {
          this.noData = true;
        } else {
          this.noData = false;
        }
        this.selectedClaim = item.paymentLineItemsResponse;
        this.selectedClaims = [];
        this.selectedClaim.forEach(
          obj => (obj !== null ? this.selectedClaims.push(obj) : "")
        );
      });
    }
  }
  onPaymentLineSelected(paymentLineItem) {
    this.feeClaimPaymentLineId = paymentLineItem.feeClaimPaymentLineId;
    // get previous claimPaymentInformation to pre-populate input fields.
    this.reconcileService
      .getClaimPaymentInformation(this.feeClaimPaymentLineId)
      .subscribe(response => {
        this.editPaymentInformation = response;
      });

    const claimPaymentInformation = {
      amountPaid: paymentLineItem.amountPaid,
      paidUnits: paymentLineItem.paidUnits,
      lineNumber: paymentLineItem.lineNumber
    };
    this.selectedPaymentLineItem = claimPaymentInformation;
    this.paymentEdit = true;
  }
  validation(f: NgForm) {
    const drgWeight = f.value.drgWeight;
    const paidAmount = f.value.paidAmount;
    const billedAmount = f.value.billedAmount;
    const invoiceDate = f.value.invoiceDate;
    const reg = /[^0-9\/%_.]/;
    const values = [drgWeight, paidAmount, billedAmount, invoiceDate].map(val =>
      reg.test(val)
    );
    return values;
  }
  onSuccessfull() {
    this.successfullMessage = true;
    setTimeout(() => {
      this.successfullMessage = false;
    }, 5000);
  }
}
