import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { RouterTestingModule } from '@angular/router/testing';
import { ReconcileComponent } from './reconcile.component';
import { MenuComponent } from '../../../shared/menu/menu.component';
import { SharedDataService } from '../../../shared/service/shared-data.service';
import { DebugElement, SimpleChanges, NgModule } from '@angular/core';
import { By } from '@angular/platform-browser';
import { HttpModule } from '@angular/http';
import { FormsModule } from '@angular/forms';
import { ReconcileService } from './reconcile.service';
import { WindowRefService } from '../../../window-ref.service';

describe('ReconcileComponent', () => {
  let component: ReconcileComponent;
  let fixture: ComponentFixture<ReconcileComponent>;

  beforeEach(
    async(() => {
      TestBed.configureTestingModule({
        imports: [RouterTestingModule, FormsModule, HttpModule],
        declarations: [ReconcileComponent, MenuComponent],
        providers: [SharedDataService, ReconcileService, WindowRefService]
      }).compileComponents();
    })
  );

  beforeEach(() => {
    fixture = TestBed.createComponent(ReconcileComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should be created', () => {
    expect(component).toBeTruthy();
  });

  it('should have "Unmatched Claim Reconciliation" page title', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('.page-title')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.textContent).toBeTruthy();
  });

  it('should have "Claim Id"', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#claimId')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.textContent).toBeTruthy();
  });

  it('should have "Claim Type"', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#claimType')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.textContent).toBeTruthy();
  });

  it('should have "Claim Date"', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#claimDate')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.textContent).toBeTruthy();
  });

  it('should have "Claim Amount"', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#claimAmount')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.textContent).toBeTruthy();
  });

  it('should have "DRG Code" element', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#drg'));
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
  });

  it('should have "Billed Amount" element', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#billedAmount')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
  });

  it('should have "Fee Invoice Number" element', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#feeInvoiceNumber')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
  });

  it('should have "DRG Weight" element', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#drgWeight')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
  });

  it('should have "Paid Amount" element', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#paidAmount')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
  });

  //
  it('should have the correct options in Reconcilation Status element', () => {
    let debugElement: DebugElement[] = fixture.debugElement.queryAll(
      By.css('#resolutionStatus option')
    );
    let htmlInputElement1: HTMLInputElement = debugElement[0].nativeElement;
    let htmlInputElement2: HTMLInputElement = debugElement[1].nativeElement;
    let htmlInputElement3: HTMLInputElement = debugElement[2].nativeElement;
    let htmlInputElement4: HTMLInputElement = debugElement[3].nativeElement;

    expect(htmlInputElement1.value).toBe('ERROR');
    expect(htmlInputElement2.value).toBe('NEW');
    expect(htmlInputElement3.value).toBe('RESOLVE');
    expect(htmlInputElement4.value).toBe('ALL');
  });

  it('should have the correct options in Reconcilation Type element', () => {
    let debugElement: DebugElement[] = fixture.debugElement.queryAll(
      By.css('#reconcilationType option')
    );
    let htmlInputElement1: HTMLInputElement = debugElement[0].nativeElement;
    let htmlInputElement2: HTMLInputElement = debugElement[1].nativeElement;
    let htmlInputElement3: HTMLInputElement = debugElement[2].nativeElement;

    expect(htmlInputElement1.value).toBe('LINE');
    expect(htmlInputElement2.value).toBe('CLAIM');
    expect(htmlInputElement3.value).toBe('ALL');
  });
});
