import { Component, OnInit } from '@angular/core';
import { SharedDataService } from '../../../shared/service/shared-data.service';
import { environment } from '../../../../environments/environment';
import { Router, ActivatedRoute, Params } from '@angular/router';
import { Headers, RequestOptions, URLSearchParams } from '@angular/http';
import { LineItem } from '../model/lineItem';
import { RestService } from '../../../shared/service/rest.service';
@Component({
    selector: 'app-manual-reconcilation',
    templateUrl: './manual-reconcilation.component.html',
    styleUrls: ['./manual-reconcilation.component.scss']
})

export class ManualReconcilationComponent implements OnInit {
    claim: any;
    public headers = new Headers();
    completed = false;
    lineItems: LineItem[];
    constructor(
        private claimDetailService: RestService,
        private router: Router,
        private activatedRoute: ActivatedRoute) { }

    ngOnInit() {
        this.getData();
    }

    getData() {
        const id = this.activatedRoute.snapshot.params.id;
        const options = new RequestOptions({ headers: this.headers, body: id });
        this.claimDetailService.postObjectFromUrl<any>(environment.nodeserver + '/claims/claimDetail/', options).subscribe(
            data => {
                this.claim = data;
                sessionStorage.setItem('claim', JSON.stringify(this.claim));
                this.lineItems = this.claim.lineItemsInfo;
                console.log('from manual' + this.claim.claimId);
            },
            error => alert(error),
            () => (console.log()));
    }


    back() {
        this.router.navigate(['claimDetail' + '/' + this.claim.claimId]);
    }

    edit(i) {
        this.lineItems[i].line_number = i + 1;
        sessionStorage.setItem('lineItem', JSON.stringify(this.lineItems[i]));
        this.router.navigate(['outOfSystemPayment']);
    }

}
