import { async, ComponentFixture, TestBed } from "@angular/core/testing";
import { RouterTestingModule } from "@angular/router/testing";
import { ManualReconcilationComponent } from "./manual-reconcilation.component";
import { MenuComponent } from "../../../shared/menu/menu.component";
import { SharedDataService } from "../../../shared/service/shared-data.service";
import { RestService } from "../../../shared/service/rest.service";
import { HttpModule } from "@angular/http";
import { DebugElement, SimpleChanges } from "@angular/core";
import { By } from "@angular/platform-browser";
import { WindowRefService } from "../../../window-ref.service";

describe("ManualReconcilationComponent", () => {
  let component: ManualReconcilationComponent;
  let fixture: ComponentFixture<ManualReconcilationComponent>;

  beforeEach(
    async(() => {
      TestBed.configureTestingModule({
        imports: [RouterTestingModule, HttpModule],
        declarations: [ManualReconcilationComponent, MenuComponent],
        providers: [SharedDataService, RestService, WindowRefService]
      }).compileComponents();
    })
  );

  beforeEach(() => {
    fixture = TestBed.createComponent(ManualReconcilationComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();

    component.claim = {
      claimId: "111",
      claimType: "57010884",
      claimStatus: "ESTABLISH",
      veteranInfo: {
        lastName: "Rodgers-Cromart",
        firstName: "Dominique"
      },
      billingProviderInfo: {
        lastName: "abc"
      },

      serviceProviderInfo: {
        lastName: "abc"
      }
    };
  });

  it("should be created", () => {
    expect(component).toBeTruthy();
  });

  it('should have a "Manual Reconciliation" title', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css(".page-title")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have a claim summary table", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#summary")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have a Line Item table", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#lineItem")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it('Back button must be displayed and call the "back" function', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#back")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });
});
