import { Component, OnInit, Input } from '@angular/core';
import { RestService } from '../../shared/service/rest.service';
import { Router, ActivatedRoute, Params } from '@angular/router';
import { CardComponent } from '../../shared/card/card.component';
import { ClaimDetail } from './model/ClaimDetail';
import { Headers, RequestOptions, URLSearchParams } from '@angular/http';
import { SharedDataService } from '../../shared/service/shared-data.service';
import { AwaitingProcessingRequest } from '../../shared/models/AwaitingProcessingRequest';
import { AwaitingClaimsService } from '../awaiting-processing/claims-awaiting-service';
import { environment } from '../../../environments/environment';
import { ReconcileService } from './reconcile/reconcile.service';
import { RerouteService } from './../../shared/reroute/reroute.service';
import { ClaimDetailService } from './claim-detail.service';

@Component({
  selector: 'app-claim-detail',
  templateUrl: './claim-detail.component.html',
  styleUrls: ['./claim-detail.component.scss']
})
export class ClaimDetailComponent implements OnInit {
  public claim: any;
  public cardOptions: any = {
    personInfoId: {
      hide: true
    },
    firstName: {
      name: 'First Name'
    },
    lastName: {
      name: 'Last Name'
    },
    middleName: {
      name: 'Middle Name'
    },
    addressLine1: {
      name: 'Address 1'
    },
    addressLine2: {
      name: 'Address 2'
    },
    TaxID: {
      name: 'Tax ID',
      number: true
    },
    ContactName: {
      name: 'Contact Name'
    },
    city: {
      name: 'City'
    },
    state: {
      name: 'State'
    },
    zipCode: {
      name: 'Zip',
      number: true
    },
    gender: {
      name: 'Gender',
      hide: true
    },
    birthDate: {
      name: 'Birth Date',
      hide: true
    },
    phone: {
      name: 'Phone'
    },
    email: {
      name: 'Email'
    },
    phoneNumber: {
      name: 'Phone',
      number: true
    },
    taxId: {
      name: 'Tax ID'
    },
    contactName: {
      name: 'Contact Name'
    },
    faxNumber: {
      name: 'Fax',
      number: true
    },
    providerNpi: {
      name: 'NPI'
    }
  };
  claims = [];
  public hideId: any = {
    ...this.cardOptions,
    personInfoId: { hide: false, name: 'ID' }
  };
  // Permission
  public claimDetailPermissions;

  // Button Visibility
  public title = 'Institutional Claim';
  public hideProcessButton = false;
  public hideDisapproveButton = false;
  public hideRerouteButton = false;
  public hideReconcileButton = false;
  public hideManualReconcileButton = false;

  // Property Visibility
  public institutional: boolean;
  public professional: boolean;
  public dental: boolean;

  @Input() Id: string;
  // To Process a Claim
  public awaitingProcessingRequest: AwaitingProcessingRequest;
  public visns: string[];
  public privacyRestrictions: string[] = ['ADMIN'];
  public userName = 'VHAIS001';
  public activeStations: string[] = ['402', '405', '123', '523', '509'];

  karmaUnitTesingBeingDone = false;

  constructor(
    private restService: RestService,
    public sharedData: SharedDataService,
    private router: Router,
    private activeRoute: ActivatedRoute,
    private awaitingClaimsService: AwaitingClaimsService,
    private reconcileService: ReconcileService,
    private rerouteService: RerouteService,
    private claimDetailService: ClaimDetailService
  ) {}

  ngOnInit() {
    this.getData();
    this.getUserPermissions();
  }

  onClick() {
    this.router.navigate(['error']);
  }

  getData() {
    let id;
    this.activeRoute.params.subscribe((params: Params) => {
      id = params['id'];
    });
    const options = new RequestOptions({ body: id });
    if (!this.karmaUnitTesingBeingDone) {
      this.restService
        .postObjectFromUrl<any>(
          environment.nodeserver + '/claims/claimDetail/',
          options
        )
        .subscribe(
          data => {
            this.claim = data;
            // this.claims.push(this.claim);

            if (this.claim.claimType === 'INST') {
              this.institutionalClaim();
            }
            if (this.claim.claimType === 'PROF') {
              this.professionalClaim();
            }
            if (this.claim.claimType === 'DENT') {
              this.dentalClaim();
            }
          },
          error => alert(error),
          () => console.log()
        );
    }
  }

  // Institutional Claim-Detail Conditions
  institutionalClaim() {
    this.title = 'Institutional Claim';
    this.institutional = true;

    if (this.claim.claimStatus === 'INPROCESS') {
      this.hideProcessButton = true;
      this.hideDisapproveButton = true;
      this.hideRerouteButton = true;
    }
    if (
      this.claim.claimStatus === 'COMPLETE' ||
      this.claim.claimStatus === 'REJECTED'
    ) {
      this.hideProcessButton = true;
      this.hideDisapproveButton = true;
      this.hideRerouteButton = true;
      this.hideReconcileButton = true;
      this.hideManualReconcileButton = true;
    }
  }

  // Professional Claim-Detail Conditions
  professionalClaim() {
    this.title = 'Professional Claim';
    this.professional = true;

    if (this.claim.claimStatus === 'INPROCESS') {
      this.hideProcessButton = true;
      this.hideDisapproveButton = true;
      this.hideRerouteButton = true;
    }
    if (
      this.claim.claimStatus === 'COMPLETE' ||
      this.claim.claimStatus === 'REJECTED'
    ) {
      this.hideProcessButton = true;
      this.hideDisapproveButton = true;
      this.hideRerouteButton = true;
      this.hideReconcileButton = true;
      this.hideManualReconcileButton = true;
    }
  }

  // Dental Claim-Detail Conditions
  dentalClaim() {
    this.title = 'Dental Claim';
    this.dental = true;

    if (this.claim.claimStatus === 'INPROCESS') {
      this.hideProcessButton = true;
      this.hideDisapproveButton = true;
    }

    if (
      this.claim.claimStatus === 'COMPLETE' ||
      this.claim.claimStatus === 'REJECTED'
    ) {
      this.hideProcessButton = true;
      this.hideDisapproveButton = true;
      this.hideRerouteButton = true;
      this.hideReconcileButton = true;
      this.hideManualReconcileButton = true;
    }
  }

  // Gets the permission from the session, It is used in the html to show and hide things
  getUserPermissions() {
    this.claimDetailPermissions = JSON.parse(
      sessionStorage.getItem('userInfo')
    )['permissions']['claimDetail'];
  }

  // method to pass selected claimId to reconciliation page.
  onReconcile(id: string) {
    this.reconcileService.setClaimId(id);
    // console.log('onReconcile Function ', id);
    this.router.navigate(['reconcile']);
  }

  // passes the claim id from claim-detail page to manual-reconcilation page
  onManualReconcile() {
    this.router.navigate(['manualReconcilation/' + this.claim.claimId]);
  }

  process() {
    this.awaitingProcessingRequest = new AwaitingProcessingRequest(
      this.userName,
      [this.claim.claimId],
      this.activeStations,
      this.visns,
      this.privacyRestrictions
    );
    const options = new RequestOptions({
      body: this.awaitingProcessingRequest
    });
    this.awaitingClaimsService
      .processClaim(options)
      .subscribe(data => (this.claim = data), error => alert(error));
    this.hideProcessButton = true;
    this.hideDisapproveButton = true;
    this.hideRerouteButton = true;
  }

  onReroute() {
    this.rerouteService.setClaims([this.claim]);
    this.router.navigate(['reroute']);
  }
}
