import { async, ComponentFixture, TestBed } from "@angular/core/testing";
import { RouterTestingModule } from "@angular/router/testing";
import { HttpModule } from "@angular/http";
import { DebugElement, SimpleChanges } from "@angular/core";
import { By } from "@angular/platform-browser";
import { FormsModule } from "@angular/forms";

import { ClaimDetailComponent } from "./claim-detail.component";
import { AdditionalComponent } from "./additional/additional.component";
import { DiagnosisComponent } from "./diagnosis/diagnosis.component";
import { LineComponent } from "./line-items/line.component";
import { ReroutingHistoryComponent } from "./rerouting/rerouting.component";
import { RejectionHistoryComponent } from "./rejection/rejection.component";
import { PrintComponent } from "../../shared/print/print.component";
import { NavButtonComponent } from "../../shared/nav-button/nav-button.component";
import { MenuComponent } from "../../shared/menu/menu.component";
import { RestService } from "../../shared/service/rest.service";
import { SharedDataService } from "../../shared/service/shared-data.service";
import { PrintService } from "../../shared/print/service/print.component.service";
import { AwaitingClaimsService } from "../awaiting-processing/claims-awaiting-service";
import { OhiInfoComponent } from "./ohi-info/ohi-info.component";
import { RerouteService } from "../../shared/reroute/reroute.service";
import { ClaimDetailService } from "./claim-detail.service";
import { WindowRefService } from "../../window-ref.service";
import { ReconcileService } from "./reconcile/reconcile.service";

// Institutional Claim Detail Page Test
describe("InstitutionalClaimDetailComponent", () => {
  let component: ClaimDetailComponent;
  let fixture: ComponentFixture<ClaimDetailComponent>;

  beforeEach(
    async(() => {
      TestBed.configureTestingModule({
        imports: [RouterTestingModule, HttpModule, FormsModule],
        declarations: [
          ClaimDetailComponent,
          MenuComponent,
          AdditionalComponent,
          DiagnosisComponent,
          LineComponent,
          ReroutingHistoryComponent,
          RejectionHistoryComponent,
          PrintComponent,
          NavButtonComponent,
          OhiInfoComponent
        ],
        providers: [
          RestService,
          SharedDataService,
          PrintService,
          ClaimDetailService,
          AwaitingClaimsService,
          RerouteService,
          WindowRefService,
          ReconcileService
        ]
      }).compileComponents();
    })
  );

  beforeEach(() => {
    fixture = TestBed.createComponent(ClaimDetailComponent);
    component = fixture.componentInstance;

    component.karmaUnitTesingBeingDone = true;

    const userInfo = {
      userName: "VHAISMBAIAHBBB",
      lastLogin: "10/06/2017 11:33:16",
      userRoles: ["ADMIN"],
      permissions: {
        claimDetail: {
          manualReconcilation: "true",
          reconcile: "true",
          process: "true",
          print: "true",
          reroute: "true",
          disapprove: "true"
        },
        toolsMenu: {
          diagnosisCodeLookUp: true,
          searchModifyUser: true,
          privacyRestrictions: true,
          createUserRequest: true,
          stationMaintenance: true,
          searchStation: true,
          createUser: true,
          viewUserAccountRequests: true,
          addStation: true,
          modifyUserRequest: true,
          medicalCodeLookUp: true
        },
        searchClaim: {
          search: "true",
          print: "true",
          clear: "true",
          visn: "true",
          hero: "true",
          disapprove: "true",
          reroute: "true"
        },
        claimsMenu: {
          paymentError: "true",
          unmatchedPayments: "true",
          inprocess: "true",
          aged: "true",
          searchClaim: "true",
          rejectClaims: "true",
          awaitingProcessing: "true"
        },
        reportsMenu: {
          claimsAwaitingProcessing: "true",
          reroutedClaims: "true",
          claimsInprocessSummary: "true",
          vistAError: "true",
          claimsCompleted: "true",
          CPEReport: "true",
          claimsCompletedSummary: "true",
          claimsInprocess: "true",
          outOfSystemPaymentsSummary: "true",
          BPPR16: "true",
          outOfSystemPayments: "true",
          claimsAwaitingProcessingSummary: "true",
          feeReport: "true"
        },
        home: {
          refreshStats: "true",
          setActive: "true"
        }
      },
      userFacilityData: {
        claimCountDetails: [
          {
            stationNumber: "VISN",
            numberOfClaimsAwaiting: "0",
            numberOfClaimsInProcess: "0",
            numberOfClaimsRejected: "2"
          },
          {
            stationNumber: "123",
            numberOfClaimsAwaiting: "1",
            numberOfClaimsInProcess: "0",
            numberOfClaimsRejected: "0"
          },
          {
            stationNumber: "402",
            numberOfClaimsAwaiting: "6",
            numberOfClaimsInProcess: "0",
            numberOfClaimsRejected: "0"
          },
          {
            stationNumber: "405",
            numberOfClaimsAwaiting: "0",
            numberOfClaimsInProcess: "0",
            numberOfClaimsRejected: "1"
          },
          {
            stationNumber: "509",
            numberOfClaimsAwaiting: "4",
            numberOfClaimsInProcess: "0",
            numberOfClaimsRejected: "0"
          }
        ],
        totalNumberOfClaimsAwaiting: "11",
        totalNumberOfClaimsInProcess: "0",
        totalNumberOfClaimsRejected: "3",
        visns: "23,8",
        privacyRestrictions: "999444555"
      }
    };

    const activeStation = ["400", "401"];
    sessionStorage.setItem("userInfo", JSON.stringify(userInfo));
    sessionStorage.setItem("activeStations", JSON.stringify(activeStation));

    component.claim = {
      claimId: "111",
      patientControlNumber: "57010884",
      claimStatus: "ESTABLISH",
      preAuthorization: "1234567890",
      claimType: "INST",
      veteranInfo: {
        personInfoId: "1",
        lastName: "Rodgers-Cromart",
        firstName: "Dominique",
        middleName: "James",
        addressLine1: "112 Maple Street",
        addressLine2: "Apt B",
        city: "New York",
        zipCode: "12345",
        gender: "M",
        birthDate: "01/01/2000",
        phone: "(321) 678-2367"
      },
      serviceProviderInfo: {
        lastName: "Smith",
        addressLine1: "1122 Central Ave",
        addressLine2: "--",
        city: "New York",
        state: "NY",
        zipCode: "12345",
        phoneNumber: "(412) 867-5309",
        taxId: "NY",
        contactName: "A. Smith",
        faxNumber: "(123) 456-7890",
        email: "angel.kelly@google.com",
        providerNpi: "123456"
      },
      billingProviderInfo: {
        lastName: "Memorial General",
        addressLine1: "1122 Central Ave",
        addressLine2: "--",
        city: "New York",
        state: "NY",
        zipCode: "90210",
        phoneNumber: "(321) 666-9065",
        taxId: "NY",
        contactName: "A. Smith",
        faxNumber: "(718) 698-7169",
        email: "william.moss@gmail.com",
        providerNpi: "123456"
      },
      payToProviderInfo: {
        lastName: "Memorial General",
        addressLine1: "1122 Central Ave",
        addressLine2: "--",
        city: "New York",
        state: "NY",
        zipCode: "80601",
        phoneNumber: "(888) 111-2222",
        taxId: "NY",
        contactName: "Jose Casanova",
        faxNumber: "(777) 333-0000",
        email: "donald.trump@whitehouse.gov",
        providerNpi: "666666"
      },
      diagnosisCodes: [
        {
          sequenceNumber: 7890,
          diagnosisCode: "DC 345",
          diagnosisCodeQualifier: "DCQ 434",
          poaIndicator: "POA I 509",
          diagnosisDescription: "The cat is in the hat!"
        }
      ],
      additionalInfoResponse: {
        otherInsuranceNumber_SecondaryPayer: "987654321",
        otherInsurancePlan_SecondaryPayer: "6754321",
        otherInsuranceNumber_TertiaryPayer: "3527890",
        otherInsurancePlan_TertiaryPayer: "Aetna",
        treasuryPaymentDate_Pd: "01/01/2017",
        totalPaidAmtPerPD: "$9,999.00",
        check_EFT_TRN: "123456",
        admissionDate: "01/01/2017",
        dischargeDate: "01/01/2017",
        coveredDays: "01/01/2017 to 01/01/2018",
        attendingPhysician: "A. Gonzalez"
      },
      reRoutingHistory: [
        {
          date: "01/01/2017",
          reason: "ervice Authorized by another VA facility in another state",
          transferredTo: "VISN:2/ABC",
          transferredFrom: "VISN:2/ABC",
          explanation: "The cat is in the hat! So is the mouse! Poor mouse!",
          transferredBy: "VHAMCADPQSDFDP"
        }
      ],
      lineItemsInfo: [
        {
          line_id: 1,
          medical_code: "ABC123",
          revenue_code: "12345",
          service_from_date: "01/01/2017",
          service_to_date: "01/01/2017",
          billed_amount: "$999,999.00",
          line_status: "UNK",
          treasury_payment_date: "01/01/2017",
          paid_amount: "$999,999.00",
          check_eft_trn: "123456",
          adjustment_amount: "$999,999.00",
          group_code: "GROUP 56",
          reason_code: "ABC123",
          remittance_remark_code: "RRC 908"
        }
      ],
      rejectionHistory: [
        {
          id: 1,
          Date: "01/01/2017",
          RejectedBy: "President Trump",
          Reason: "Service Authorized by another VA facility in another state",
          Explanation: "Unknown",
          ReviewedBy: "President Trump",
          OutCome: "UNKNOWN",
          ReviewrComments: "Claim Rejected"
        }
      ],
      additionalInfo: {
        otherInsuranceNumber_SecondaryPayer: "987654321",
        otherInsurancePlan_SecondaryPayer: "6754321",
        otherInsuranceNumber_TertiaryPayer: "3527890",
        otherInsurancePlan_TertiaryPayer: "Aetna",
        treasuryPaymentDate_Pd: "01/01/2017",
        totalPaidAmtPerPD: "$9,999.00",
        check_EFT_TRN: "123456",
        admissionDate: "01/01/2017",
        dischargeDate: "01/01/2017",
        coveredDays: "01/01/2017 to 01/01/2018",
        attendingPhysician: "A. Gonzalez"
      },
      ohiInfo: [
        {
          ohiPayerId: "115.1",
          payerName: "Payer1.115",
          paymentSeqInd: "P",
          groupName: null,
          fillingIndicator: null,
          insuranceType: null,
          claimAdjDate: null,
          otherSubInfo: null,
          idCode: null,
          secondaryId: null,
          remittDate: null,
          payerPriorAuthNum: null,
          payerPriorRefNum: null,
          rarcCodes: null,
          ohiPaidAmt: null,
          totalNonCovered: null,
          quantity: ["20115", "10115"],
          adjCode: ["CR115", "PR115"],
          adjAmt: ["115.2", "115.1"]
        },
        {
          ohiPayerId: "115.2",
          payerName: "Payer2.115",
          paymentSeqInd: "S",
          groupName: null,
          fillingIndicator: null,
          insuranceType: null,
          claimAdjDate: null,
          otherSubInfo: null,
          idCode: null,
          secondaryId: null,
          remittDate: null,
          payerPriorAuthNum: null,
          payerPriorRefNum: null,
          rarcCodes: null,
          ohiPaidAmt: null,
          totalNonCovered: null,
          quantity: [],
          adjCode: [],
          adjAmt: []
        },
        {
          ohiPayerId: "115.3",
          payerName: "Payer3.115",
          paymentSeqInd: "T",
          groupName: null,
          fillingIndicator: null,
          insuranceType: null,
          claimAdjDate: null,
          otherSubInfo: null,
          idCode: null,
          secondaryId: null,
          remittDate: null,
          payerPriorAuthNum: null,
          payerPriorRefNum: null,
          rarcCodes: null,
          ohiPaidAmt: null,
          totalNonCovered: null,
          quantity: [],
          adjCode: [],
          adjAmt: []
        }
      ]
    };

    fixture.detectChanges();
  });

  it("should be created", () => {
    expect(component).toBeTruthy();
  });

  it("should have a proper page title", () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css("#pageTitle")
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();

    expect(htmlElement.innerText).toEqual(component.title);
  });

  it("should have Veteran Info Card", () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css("#veteranCard")
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Service Provider Info Card", () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css("#serviceCard")
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Billing Provider Info Card", () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css("#billingCard")
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Pay-To Provider Info Card", () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css("#payCard")
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Additional Info Tab", () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab1-content")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Diagnosis Code Tab", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab2-content")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Line Items Tab", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab3-content")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Rerouting Tab", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab4-content")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Rejection Tab", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab5-content")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it('Process Button should only be displayed on "ESTABLISH" status', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#process")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    if (component.claim.claimStatus === "ESTABLISH") {
      expect(htmlElement).toBeTruthy();
      expect(htmlElement.getAttribute("disabled")).toBeNull();
      expect(htmlElement.hidden).toBe(false);
    } else {
      expect(htmlElement.hidden).toBe(true);
    }
  });

  it("Print Button should be displayed on All the statuses", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#print")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute("disabled")).toBeNull();
    expect(htmlElement.hidden).toBe(false);
  });

  it('Reroute Button should be displayed on all the statuses except "COMPLETE" ', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#reroute")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    if (component.claim.claimStatus === "COMPLETE") {
      expect(htmlElement.hidden).toBe(true);
    } else {
      expect(htmlElement).toBeTruthy();
      expect(htmlElement.getAttribute("disabled")).toBeNull();
      expect(htmlElement.hidden).toBe(false);
    }
  });

  it('Disapprove Button should be displayed on all the statuses except "COMPLETE" ', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#disapprove")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    if (component.claim.claimStatus === "COMPLETE") {
      expect(htmlElement.hidden).toBe(true);
    } else {
      expect(htmlElement).toBeTruthy();
      expect(htmlElement.getAttribute("disabled")).toBeNull();
      expect(htmlElement.hidden).toBe(false);
    }
  });

  it('Reconcile Button should be displayed on all the statuses except "COMPLETE" ', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#reconcile")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    if (component.claim.claimStatus === "COMPLETE") {
      expect(htmlElement.hidden).toBe(true);
    } else {
      expect(htmlElement).toBeTruthy();
      expect(htmlElement.getAttribute("disabled")).toBeNull();
      expect(htmlElement.hidden).toBe(false);
    }
  });

  it('Manual Reconcile Button should be displayed on all the statuses except "COMPLETE" ', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#manualReconcile")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    if (component.claim.claimStatus === "COMPLETE") {
      expect(htmlElement.hidden).toBe(true);
    } else {
      expect(htmlElement).toBeTruthy();
      expect(htmlElement.getAttribute("disabled")).toBeNull();
      expect(htmlElement.hidden).toBe(false);
    }
  });

  it("Verify that OHI Tab exists when OHI Data does exist", () => {
    let ohiTabDebugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab6")
    );
    expect(ohiTabDebugElement).toBeTruthy();
    let ohiTabHtmlElement: HTMLElement = ohiTabDebugElement.nativeElement;
    expect(ohiTabHtmlElement).toBeTruthy();

    let ohiTabLabelDebugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab6label")
    );
    expect(ohiTabLabelDebugElement).toBeTruthy();
    let ohiTabLabelHtmlElement: HTMLElement =
      ohiTabLabelDebugElement.nativeElement;
    expect(ohiTabLabelHtmlElement).toBeTruthy();

    let ohiTabContentDebugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab6-content")
    );
    expect(ohiTabContentDebugElement).toBeTruthy();
    let ohiTabContentHtmlElement: HTMLElement =
      ohiTabContentDebugElement.nativeElement;
    expect(ohiTabContentHtmlElement).toBeTruthy();
  });

  it("Verify OHI Claim Information tab includes a block for the primary payer and includes the payer identification number", () => {
    let appOhiInfoDebugElement: DebugElement = fixture.debugElement.query(
      By.css("app-ohi-info")
    );
    // console.log("appOhiInfoDebugElement = " + appOhiInfoDebugElement);
    expect(appOhiInfoDebugElement).toBeTruthy();

    // This is the table for the Primary OHI Payer.
    let ohiPayerTableDebugElement: DebugElement = appOhiInfoDebugElement.query(
      By.css("#ohiPayerTable115\\.1")
    );
    expect(ohiPayerTableDebugElement).toBeTruthy();
    // console.log("ohiPayerTableDebugElement = " + ohiPayerTableDebugElement);
    let ohiPayerTableHtmlElement: HTMLElement =
      ohiPayerTableDebugElement.nativeElement;
    // console.log("ohiPayerTableHtmlElement = " + ohiPayerTableHtmlElement);
    expect(ohiPayerTableHtmlElement).toBeTruthy();
    // console.log("ohiPayerTableHtmlElement id = " + ohiPayerTableHtmlElement.getAttribute("id"));

    let ohiPayerIdLabelDebugElement: DebugElement = ohiPayerTableDebugElement.query(
      By.css("#ohiPayerIdLabel115\\.1")
    );
    expect(ohiPayerIdLabelDebugElement).toBeTruthy();
    let ohiPayerIdLabelHtmlElement: HTMLElement =
      ohiPayerIdLabelDebugElement.nativeElement;
    expect(ohiPayerIdLabelHtmlElement).toBeTruthy();
    console.log(
      "ohiPayerIdLabelHtmlElement.innerText = " +
        ohiPayerIdLabelHtmlElement.innerText
    );
    // expect(ohiPayerIdLabelHtmlElement.innerText).toEqual("Primary OHI Payer ID: 115.1");
    expect(ohiPayerIdLabelHtmlElement.innerText).toContain("Primary ");
    expect(ohiPayerIdLabelHtmlElement.innerText).toContain(
      " OHI Payer ID: 115.1"
    );
  });

  it("Verify that the OHI Claim Information tab includes a block for the secondary payer and includes the payer identification number", () => {
    let appOhiInfoDebugElement: DebugElement = fixture.debugElement.query(
      By.css("app-ohi-info")
    );
    // console.log("appOhiInfoDebugElement = " + appOhiInfoDebugElement);
    expect(appOhiInfoDebugElement).toBeTruthy();

    // This is the table for the Primary OHI Payer.
    let ohiPayerTableDebugElement: DebugElement = appOhiInfoDebugElement.query(
      By.css("#ohiPayerTable115\\.2")
    );
    expect(ohiPayerTableDebugElement).toBeTruthy();
    // console.log("ohiPayerTableDebugElement = " + ohiPayerTableDebugElement);
    let ohiPayerTableHtmlElement: HTMLElement =
      ohiPayerTableDebugElement.nativeElement;
    // console.log("ohiPayerTableHtmlElement = " + ohiPayerTableHtmlElement);
    expect(ohiPayerTableHtmlElement).toBeTruthy();
    // console.log("ohiPayerTableHtmlElement id = " + ohiPayerTableHtmlElement.getAttribute("id"));

    let ohiPayerIdLabelDebugElement: DebugElement = ohiPayerTableDebugElement.query(
      By.css("#ohiPayerIdLabel115\\.2")
    );
    expect(ohiPayerIdLabelDebugElement).toBeTruthy();
    let ohiPayerIdLabelHtmlElement: HTMLElement =
      ohiPayerIdLabelDebugElement.nativeElement;
    expect(ohiPayerIdLabelHtmlElement).toBeTruthy();
    console.log(
      "ohiPayerIdLabelHtmlElement.innerText = " +
        ohiPayerIdLabelHtmlElement.innerText
    );
    // expect(ohiPayerIdLabelHtmlElement.innerText).toEqual("Secondary OHI Payer ID: 115.2");
    expect(ohiPayerIdLabelHtmlElement.innerText).toContain("Secondary ");
    expect(ohiPayerIdLabelHtmlElement.innerText).toContain(
      " OHI Payer ID: 115.2"
    );
  });

  it("Verify that the OHI Claim Information tab includes a block for the tertiary payer and includes the payer identification number", () => {
    let appOhiInfoDebugElement: DebugElement = fixture.debugElement.query(
      By.css("app-ohi-info")
    );
    // console.log("appOhiInfoDebugElement = " + appOhiInfoDebugElement);
    expect(appOhiInfoDebugElement).toBeTruthy();

    // This is the table for the Primary OHI Payer.
    let ohiPayerTableDebugElement: DebugElement = appOhiInfoDebugElement.query(
      By.css("#ohiPayerTable115\\.3")
    );
    expect(ohiPayerTableDebugElement).toBeTruthy();
    // console.log("ohiPayerTableDebugElement = " + ohiPayerTableDebugElement);
    let ohiPayerTableHtmlElement: HTMLElement =
      ohiPayerTableDebugElement.nativeElement;
    // console.log("ohiPayerTableHtmlElement = " + ohiPayerTableHtmlElement);
    expect(ohiPayerTableHtmlElement).toBeTruthy();
    // console.log("ohiPayerTableHtmlElement id = " + ohiPayerTableHtmlElement.getAttribute("id"));

    let ohiPayerIdLabelDebugElement: DebugElement = ohiPayerTableDebugElement.query(
      By.css("#ohiPayerIdLabel115\\.3")
    );
    expect(ohiPayerIdLabelDebugElement).toBeTruthy();
    let ohiPayerIdLabelHtmlElement: HTMLElement =
      ohiPayerIdLabelDebugElement.nativeElement;
    expect(ohiPayerIdLabelHtmlElement).toBeTruthy();
    console.log(
      "ohiPayerIdLabelHtmlElement.innerText = " +
        ohiPayerIdLabelHtmlElement.innerText
    );
    // expect(ohiPayerIdLabelHtmlElement.innerText).toEqual("Tertiary OHI Payer ID: 115.3");
    expect(ohiPayerIdLabelHtmlElement.innerText).toContain("Tertiary ");
    expect(ohiPayerIdLabelHtmlElement.innerText).toContain(
      " OHI Payer ID: 115.3"
    );
  });
});

// Professional Claim Detail Page Test
describe("ProfessionalClaimDetailComponent", () => {
  let component: ClaimDetailComponent;
  let fixture: ComponentFixture<ClaimDetailComponent>;

  beforeEach(
    async(() => {
      TestBed.configureTestingModule({
        imports: [RouterTestingModule, HttpModule],
        declarations: [
          ClaimDetailComponent,
          MenuComponent,
          AdditionalComponent,
          DiagnosisComponent,
          LineComponent,
          ReroutingHistoryComponent,
          OhiInfoComponent,
          RejectionHistoryComponent,
          PrintComponent,
          NavButtonComponent
        ],
        providers: [
          RestService,
          SharedDataService,
          PrintService,
          ClaimDetailService,
          AwaitingClaimsService,
          RerouteService,
          ReconcileService,
          WindowRefService
        ]
      }).compileComponents();
    })
  );

  beforeEach(() => {
    fixture = TestBed.createComponent(ClaimDetailComponent);
    component = fixture.componentInstance;

    component.claim = {
      claimId: "111",
      patientControlNumber: "57010884",
      claimStatus: "ESTABLISH",
      preAuthorization: "1234567890",
      claimType: "PROF",
      veteranInfo: {
        personInfoId: "1",
        lastName: "Rodgers-Cromart",
        firstName: "Dominique",
        middleName: "James",
        addressLine1: "112 Maple Street",
        addressLine2: "Apt B",
        city: "New York",
        zipCode: "12345",
        gender: "M",
        birthDate: "01/01/2000",
        phone: "(321) 678-2367"
      },
      serviceProviderInfo: {
        lastName: "Smith",
        addressLine1: "1122 Central Ave",
        addressLine2: "--",
        city: "New York",
        state: "NY",
        zipCode: "12345",
        phoneNumber: "(412) 867-5309",
        taxId: "NY",
        contactName: "A. Smith",
        faxNumber: "(123) 456-7890",
        email: "angel.kelly@google.com",
        providerNpi: "123456"
      },
      billingProviderInfo: {
        lastName: "Memorial General",
        addressLine1: "1122 Central Ave",
        addressLine2: "--",
        city: "New York",
        state: "NY",
        zipCode: "90210",
        phoneNumber: "(321) 666-9065",
        taxId: "NY",
        contactName: "A. Smith",
        faxNumber: "(718) 698-7169",
        email: "william.moss@gmail.com",
        providerNpi: "123456"
      },
      payToProviderInfo: {
        lastName: "Memorial General",
        addressLine1: "1122 Central Ave",
        addressLine2: "--",
        city: "New York",
        state: "NY",
        zipCode: "80601",
        phoneNumber: "(888) 111-2222",
        taxId: "NY",
        contactName: "Jose Casanova",
        faxNumber: "(777) 333-0000",
        email: "donald.trump@whitehouse.gov",
        providerNpi: "666666"
      },
      diagnosisCodes: [
        {
          sequenceNumber: 7890,
          diagnosisCode: "DC 345",
          diagnosisCodeQualifier: "DCQ 434",
          poaIndicator: "POA I 509",
          diagnosisDescription: "The cat is in the hat!"
        }
      ],
      additionalInfoResponse: {
        otherInsuranceNumber_SecondaryPayer: "987654321",
        otherInsurancePlan_SecondaryPayer: "6754321",
        otherInsuranceNumber_TertiaryPayer: "3527890",
        otherInsurancePlan_TertiaryPayer: "Aetna",
        treasuryPaymentDate_Pd: "01/01/2017",
        totalPaidAmtPerPD: "$9,999.00",
        check_EFT_TRN: "123456",
        admissionDate: "01/01/2017",
        dischargeDate: "01/01/2017",
        coveredDays: "01/01/2017 to 01/01/2018",
        attendingPhysician: "A. Gonzalez"
      },
      reRoutingHistory: [
        {
          date: "01/01/2017",
          reason: "ervice Authorized by another VA facility in another state",
          transferredTo: "VISN:2/ABC",
          transferredFrom: "VISN:2/ABC",
          explanation: "The cat is in the hat! So is the mouse! Poor mouse!",
          transferredBy: "VHAMCADPQSDFDP"
        }
      ],
      lineItemsInfo: [
        {
          line_id: 1,
          medical_code: "ABC123",
          revenue_code: "12345",
          service_from_date: "01/01/2017",
          service_to_date: "01/01/2017",
          billed_amount: "$999,999.00",
          line_status: "UNK",
          treasury_payment_date: "01/01/2017",
          paid_amount: "$999,999.00",
          check_eft_trn: "123456",
          adjustment_amount: "$999,999.00",
          group_code: "GROUP 56",
          reason_code: "ABC123",
          remittance_remark_code: "RRC 908"
        }
      ],
      rejectionHistory: [
        {
          id: 1,
          Date: "01/01/2017",
          RejectedBy: "President Trump",
          Reason: "Service Authorized by another VA facility in another state",
          Explanation: "Unknown",
          ReviewedBy: "President Trump",
          OutCome: "UNKNOWN",
          ReviewrComments: "Claim Rejected"
        }
      ],
      additionalInfo: {
        otherInsuranceNumber_SecondaryPayer: "987654321",
        otherInsurancePlan_SecondaryPayer: "6754321",
        otherInsuranceNumber_TertiaryPayer: "3527890",
        otherInsurancePlan_TertiaryPayer: "Aetna",
        treasuryPaymentDate_Pd: "01/01/2017",
        totalPaidAmtPerPD: "$9,999.00",
        check_EFT_TRN: "123456",
        admissionDate: "01/01/2017",
        dischargeDate: "01/01/2017",
        coveredDays: "01/01/2017 to 01/01/2018",
        attendingPhysician: "A. Gonzalez"
      }
    };

    fixture.detectChanges();
  });

  it("should be created", () => {
    expect(component).toBeTruthy();
  });

  it('should have a "Professional Claim" title', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#pageTitle")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Veteran Info Card", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#veteranCard")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Service Provider Info Card", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#serviceCard")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Billing Provider Info Card", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#billingCard")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Pay-To Provider Info Card", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#payCard")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Additional Info Tab", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab1-content")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Diagnosis Code Tab", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab2-content")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Line Items Tab", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab3-content")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Rerouting Tab", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab4-content")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Rejection Tab", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab5-content")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it('Process Button should only be displayed on "ESTABLISH" status', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#process")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    if (component.claim.claimStatus === "ESTABLISH") {
      expect(htmlElement).toBeTruthy();
      expect(htmlElement.getAttribute("disabled")).toBeNull();
      expect(htmlElement.hidden).toBe(false);
    } else {
      expect(htmlElement.hidden).toBe(true);
    }
  });

  it("Print Button should be displayed on All the statuses", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#print")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute("disabled")).toBeNull();
    expect(htmlElement.hidden).toBe(false);
  });

  it('Reroute Button should be displayed on all the statuses except "COMPLETE" ', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#reroute")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    if (component.claim.claimStatus === "COMPLETE") {
      expect(htmlElement.hidden).toBe(true);
    } else {
      expect(htmlElement).toBeTruthy();
      expect(htmlElement.getAttribute("disabled")).toBeNull();
      expect(htmlElement.hidden).toBe(false);
    }
  });

  it('Disapprove Button should be displayed on all the statuses except "COMPLETE" ', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#disapprove")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    if (component.claim.claimStatus === "COMPLETE") {
      expect(htmlElement.hidden).toBe(true);
    } else {
      expect(htmlElement).toBeTruthy();
      expect(htmlElement.getAttribute("disabled")).toBeNull();
      expect(htmlElement.hidden).toBe(false);
    }
  });

  it('Reconcile Button should be displayed on all the statuses except "COMPLETE" ', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#reconcile")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    if (component.claim.claimStatus === "COMPLETE") {
      expect(htmlElement.hidden).toBe(true);
    } else {
      expect(htmlElement).toBeTruthy();
      expect(htmlElement.getAttribute("disabled")).toBeNull();
      expect(htmlElement.hidden).toBe(false);
    }
  });

  it('Manual Reconcile Button should be displayed on all the statuses except "COMPLETE" ', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#manualReconcile")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    if (component.claim.claimStatus === "COMPLETE") {
      expect(htmlElement.hidden).toBe(true);
    } else {
      expect(htmlElement).toBeTruthy();
      expect(htmlElement.getAttribute("disabled")).toBeNull();
      expect(htmlElement.hidden).toBe(false);
    }
  });

  it("Verify that OHI Tab does not exist when OHI Data does not exist", () => {
    let ohiTabDebugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab6")
    );
    expect(ohiTabDebugElement).toBeNull();

    let ohiTabLabelDebugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab6label")
    );
    expect(ohiTabLabelDebugElement).toBeNull();

    let ohiTabContentDebugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab6-content")
    );
    expect(ohiTabContentDebugElement).toBeNull();
  });
});

// Dental Claim Detail Page Test
describe("DentalClaimDetailComponent", () => {
  let component: ClaimDetailComponent;
  let fixture: ComponentFixture<ClaimDetailComponent>;

  beforeEach(
    async(() => {
      TestBed.configureTestingModule({
        imports: [RouterTestingModule, HttpModule],
        declarations: [
          ClaimDetailComponent,
          MenuComponent,
          AdditionalComponent,
          DiagnosisComponent,
          LineComponent,
          ReroutingHistoryComponent,
          OhiInfoComponent,
          RejectionHistoryComponent,
          PrintComponent,
          NavButtonComponent
        ],
        providers: [
          RestService,
          SharedDataService,
          PrintService,
          ClaimDetailService,
          AwaitingClaimsService,
          RerouteService,
          ReconcileService,
          WindowRefService
        ]
      }).compileComponents();
    })
  );

  beforeEach(() => {
    fixture = TestBed.createComponent(ClaimDetailComponent);
    component = fixture.componentInstance;

    component.claim = {
      claimId: "111",
      patientControlNumber: "57010884",
      claimStatus: "ESTABLISH",
      preAuthorization: "1234567890",
      claimType: "DENT",
      veteranInfo: {
        personInfoId: "1",
        lastName: "Rodgers-Cromart",
        firstName: "Dominique",
        middleName: "James",
        addressLine1: "112 Maple Street",
        addressLine2: "Apt B",
        city: "New York",
        zipCode: "12345",
        gender: "M",
        birthDate: "01/01/2000",
        phone: "(321) 678-2367"
      },
      serviceProviderInfo: {
        lastName: "Smith",
        addressLine1: "1122 Central Ave",
        addressLine2: "--",
        city: "New York",
        state: "NY",
        zipCode: "12345",
        phoneNumber: "(412) 867-5309",
        taxId: "NY",
        contactName: "A. Smith",
        faxNumber: "(123) 456-7890",
        email: "angel.kelly@google.com",
        providerNpi: "123456"
      },
      billingProviderInfo: {
        lastName: "Memorial General",
        addressLine1: "1122 Central Ave",
        addressLine2: "--",
        city: "New York",
        state: "NY",
        zipCode: "90210",
        phoneNumber: "(321) 666-9065",
        taxId: "NY",
        contactName: "A. Smith",
        faxNumber: "(718) 698-7169",
        email: "william.moss@gmail.com",
        providerNpi: "123456"
      },
      payToProviderInfo: {
        lastName: "Memorial General",
        addressLine1: "1122 Central Ave",
        addressLine2: "--",
        city: "New York",
        state: "NY",
        zipCode: "80601",
        phoneNumber: "(888) 111-2222",
        taxId: "NY",
        contactName: "Jose Casanova",
        faxNumber: "(777) 333-0000",
        email: "donald.trump@whitehouse.gov",
        providerNpi: "666666"
      },
      diagnosisCodes: [
        {
          sequenceNumber: 7890,
          diagnosisCode: "DC 345",
          diagnosisCodeQualifier: "DCQ 434",
          poaIndicator: "POA I 509",
          diagnosisDescription: "The cat is in the hat!"
        }
      ],
      additionalInfoResponse: {
        otherInsuranceNumber_SecondaryPayer: "987654321",
        otherInsurancePlan_SecondaryPayer: "6754321",
        otherInsuranceNumber_TertiaryPayer: "3527890",
        otherInsurancePlan_TertiaryPayer: "Aetna",
        treasuryPaymentDate_Pd: "01/01/2017",
        totalPaidAmtPerPD: "$9,999.00",
        check_EFT_TRN: "123456",
        admissionDate: "01/01/2017",
        dischargeDate: "01/01/2017",
        coveredDays: "01/01/2017 to 01/01/2018",
        attendingPhysician: "A. Gonzalez"
      },
      reRoutingHistory: [
        {
          date: "01/01/2017",
          reason: "ervice Authorized by another VA facility in another state",
          transferredTo: "VISN:2/ABC",
          transferredFrom: "VISN:2/ABC",
          explanation: "The cat is in the hat! So is the mouse! Poor mouse!",
          transferredBy: "VHAMCADPQSDFDP"
        }
      ],
      lineItemsInfo: [
        {
          line_id: 1,
          medical_code: "ABC123",
          revenue_code: "12345",
          service_from_date: "01/01/2017",
          service_to_date: "01/01/2017",
          billed_amount: "$999,999.00",
          line_status: "UNK",
          treasury_payment_date: "01/01/2017",
          paid_amount: "$999,999.00",
          check_eft_trn: "123456",
          adjustment_amount: "$999,999.00",
          group_code: "GROUP 56",
          reason_code: "ABC123",
          remittance_remark_code: "RRC 908"
        }
      ],
      rejectionHistory: [
        {
          id: 1,
          Date: "01/01/2017",
          RejectedBy: "President Trump",
          Reason: "Service Authorized by another VA facility in another state",
          Explanation: "Unknown",
          ReviewedBy: "President Trump",
          OutCome: "UNKNOWN",
          ReviewrComments: "Claim Rejected"
        }
      ],
      additionalInfo: {
        otherInsuranceNumber_SecondaryPayer: "987654321",
        otherInsurancePlan_SecondaryPayer: "6754321",
        otherInsuranceNumber_TertiaryPayer: "3527890",
        otherInsurancePlan_TertiaryPayer: "Aetna",
        treasuryPaymentDate_Pd: "01/01/2017",
        totalPaidAmtPerPD: "$9,999.00",
        check_EFT_TRN: "123456",
        admissionDate: "01/01/2017",
        dischargeDate: "01/01/2017",
        coveredDays: "01/01/2017 to 01/01/2018",
        attendingPhysician: "A. Gonzalez"
      }
    };

    fixture.detectChanges();
  });

  it("should be created", () => {
    expect(component).toBeTruthy();
  });

  it('should have a "Dental Claim" title', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#pageTitle")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Veteran Info Card", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#veteranCard")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Service Provider Info Card", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#serviceCard")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Billing Provider Info Card", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#billingCard")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Pay-To Provider Info Card", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#payCard")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Additional Info Tab", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab1-content")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Line Items Tab", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab3-content")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Rerouting Tab", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab4-content")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it("should have Rejection Tab", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab5-content")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it('Process Button should only be displayed on "ESTABLISH" status', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#process")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    if (component.claim.claimStatus === "ESTABLISH") {
      expect(htmlElement).toBeTruthy();
      expect(htmlElement.getAttribute("disabled")).toBeNull();
      expect(htmlElement.hidden).toBe(false);
    } else {
      expect(htmlElement.hidden).toBe(true);
    }
  });

  it("Print Button should be displayed on All the statuses", () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#print")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute("disabled")).toBeNull();
    expect(htmlElement.hidden).toBe(false);
  });

  it('Reroute Button should be displayed on all the statuses except "COMPLETE" ', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#reroute")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    if (component.claim.claimStatus === "COMPLETE") {
      expect(htmlElement.hidden).toBe(true);
    } else {
      expect(htmlElement).toBeTruthy();
      expect(htmlElement.getAttribute("disabled")).toBeNull();
      expect(htmlElement.hidden).toBe(false);
    }
  });

  it('Disapprove Button should be displayed on all the statuses except "COMPLETE" ', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#disapprove")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    if (component.claim.claimStatus === "COMPLETE") {
      expect(htmlElement.hidden).toBe(true);
    } else {
      expect(htmlElement).toBeTruthy();
      expect(htmlElement.getAttribute("disabled")).toBeNull();
      expect(htmlElement.hidden).toBe(false);
    }
  });

  it('Reconcile Button should be displayed on all the statuses except "COMPLETE" ', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#reconcile")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    if (component.claim.claimStatus === "COMPLETE") {
      expect(htmlElement.hidden).toBe(true);
    } else {
      expect(htmlElement).toBeTruthy();
      expect(htmlElement.getAttribute("disabled")).toBeNull();
      expect(htmlElement.hidden).toBe(false);
    }
  });

  it('Manual Reconcile Button should be displayed on all the statuses except "COMPLETE" ', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css("#manualReconcile")
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;
    if (component.claim.claimStatus === "COMPLETE") {
      expect(htmlElement.hidden).toBe(true);
    } else {
      expect(htmlElement).toBeTruthy();
      expect(htmlElement.getAttribute("disabled")).toBeNull();
      expect(htmlElement.hidden).toBe(false);
    }
  });

  it("Verify that OHI Tab does not exist when OHI Data does not exist", () => {
    let ohiTabDebugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab6")
    );
    expect(ohiTabDebugElement).toBeNull();

    let ohiTabLabelDebugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab6label")
    );
    expect(ohiTabLabelDebugElement).toBeNull();

    let ohiTabContentDebugElement: DebugElement = fixture.debugElement.query(
      By.css("#tab6-content")
    );
    expect(ohiTabContentDebugElement).toBeNull();
  });
});
