import { Claims } from '../../shared/models/Claims';
import { Injectable } from '@angular/core';
import {
    Http,
    Response,
    Headers,
    Jsonp,
    RequestOptions,
    URLSearchParams
} from '@angular/http';

import { Observable } from 'rxjs/Observable';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/do';
import 'rxjs/add/operator/catch';
import { environment } from '../../../environments/environment';

@Injectable()
export class AwaitingClaimsService {
    constructor(private http: Http) { }

    public getClaims(requestBody) {
        console.log('sending request to the node');
        return this.http.post(environment.nodeserver + '/claims/awaitingProcessing/getClaims', requestBody)
            .map((res: Response) => res.json())
            .catch((error: Response) => Observable.throw(error.json));
    }
    public process(requestBody) {
        return this.http.post(environment.nodeserver + '/claims/awaitingProcessing/process', requestBody)
            .map((res: Response) => res.json())
            .catch((error: Response) => Observable.throw(error.json));
    }
    public processClaim(requestBody) {
        return this.http.post(environment.nodeserver + '/claims/awaitingProcessing/processClaim', requestBody)
            .map((res: Response) => res.json())
            .catch((error: Response) => Observable.throw(error.json));
    }
    public print(url: string, searchoptions: RequestOptions) {
        return this.http.post(url, searchoptions).map((res: Response) => res.json());
    }

}
