import { AwaitingClaimsService } from './claims-awaiting-service';
import { Component, OnInit, Input } from '@angular/core';
import { Claims } from '../../shared/models/Claims';
import { AwaitingProcessingRequest } from '../../shared/models/AwaitingProcessingRequest';
import { Router } from '@angular/router';
import { SharedDataService } from '../../shared/service/shared-data.service';
import { TableComponent } from '../../shared/table/table.component';
import {
  RequestOptions,
  URLSearchParams,
  Headers,
  Response,
  Http,
  ResponseContentType
} from '@angular/http';
import { environment } from '../../../environments/environment';
import { RerouteService } from '../../shared/reroute/reroute.service';
import { ColumnMetadata } from 'app/shared/table/cols.model';

@Component({
  selector: 'app-claims-awaiting',
  templateUrl: 'awaiting-processing.component.html',
  styleUrls: ['awaiting-processing.component.scss']
})
export class AwaitingProcessingComponent implements OnInit {
  fetchingData = true;
  public claims: any[] = [];
  cols: ColumnMetadata[] = [
    new ColumnMetadata('select', 'Select?').setSelectBox(true),
    new ColumnMetadata('claimId', 'Claim ID').setAlign('right'),
    new ColumnMetadata('claimType', 'Claim Type'),
    new ColumnMetadata('hero', 'HERO'),
    new ColumnMetadata('veteranName', 'Name'),
    new ColumnMetadata('ssn', 'SSN').setAlign('right'),
    new ColumnMetadata('claimDate', 'Claim Date').setAlign('right'),
    new ColumnMetadata('claimAmount', 'Claim Amount')
      .setAlign('right')
      .setCurrency(true),
    new ColumnMetadata('providerName', 'Provider'),
    new ColumnMetadata('lines', 'Total Lines').setAlign('right'),
    new ColumnMetadata('facility', 'Facility').setAlign('right')
  ];

  public ids: number[];
  public activeStations: string[];
  public visns: string[];
  public privacyRestrictions: string[];
  public userName: string;
  public headers = new Headers();
  getParam = new URLSearchParams();
  searchheaders = new Headers();
  public counter: number;
  public awaitingProcessingRequest: AwaitingProcessingRequest;
  allClaimsSelectedCheckMarked = false;
  constructor(
    private router: Router,
    public sharedData: SharedDataService,
    private awaitingClaimsService: AwaitingClaimsService,
    private rerouteService: RerouteService
  ) { }

  ngOnInit() {
    if (
      !!sessionStorage.getItem('activeStations') &&
      !!sessionStorage.getItem('visns') &&
      !!sessionStorage.getItem('privacyRestrictions') &&
      !!sessionStorage.getItem('privacyRestrictions')
    ) {
      this.userName = sessionStorage.getItem('userName');
      this.activeStations = sessionStorage.getItem('activeStations').split(',');
      this.visns = sessionStorage.getItem('visns').split(',');
      this.privacyRestrictions = sessionStorage
        .getItem('privacyRestrictions')
        .split(',');
    }
    // Retrieving all the claims in the ESTABLISH status
    this.awaitingProcessingRequest = new AwaitingProcessingRequest(
      this.userName,
      this.ids,
      this.activeStations,
      this.visns,
      this.privacyRestrictions
    );
    // console.log('awaiting processing request is :' + JSON.stringify(this.awaitingProcessingRequest));
    this.headers.append('Content-Type', 'application/json');
    // console.log(
    //   'awaitingProcessing request is : ' +
    //   JSON.stringify(this.awaitingProcessingRequest)
    // );
    const options = new RequestOptions({
      headers: this.headers,
      body: this.awaitingProcessingRequest
    });
    console.log('Before rest');

    this.awaitingClaimsService.getClaims(options).subscribe(
      data => {
        if (data[0].claimId) {
          this.claims = data;
          console.log(data);
        } else {
          this.claims = [];
          this.fetchingData = false;
          console.log('nodata ', data);
        }
      },
      error => alert(error),
      // Adds link to these fields for each row
      () => {
        if (this.claims.length > 0) {
          this.claims.forEach(claim => {
            claim.selected = false;
            claim.claimIdLink = '/claimDetail/' + claim.claimId;
            this.fetchingData = false;
          });
        }
      }
    );
  }

  // Updating the claim status to INPROCESS
  process() {
    if (this.isNoneChecked()) {
      return;
    }

    const temp = this.claims.filter(claim => claim.selected);

    if (this.claims && temp.length === this.claims.length) {
      this.claims = [];
    }
    this.sharedData.inprocessStorage = temp;
    this.ids = [109];
    this.counter = 0;
    for (const clm of temp) {
      this.ids[this.counter] = clm.claimId;
      this.counter++;
    }

    this.awaitingProcessingRequest = new AwaitingProcessingRequest(
      this.userName,
      this.ids,
      this.activeStations,
      this.visns,
      this.privacyRestrictions
    );
    this.headers.append('Content-Type', 'application/json');
    const options = new RequestOptions({
      headers: this.headers,
      body: this.awaitingProcessingRequest
    });
    this.awaitingClaimsService.process(options).subscribe(
      data => (this.claims = data),
      error => alert(error),
      // Adds link to these fields for each row
      () =>
        this.claims.forEach(claim => {
          claim.selected = false;
          claim.claimIdLink = '/claimDetail' + claim.claimId;
        })
    );
  }
  isNoneChecked(): boolean {
    if (this.claims.length > 0) {
      return this.claims.every(_ => !_.selected);
    }
  }

  // Updating the claim status to INPROCESS and print
  processAndPrint() {
    if (this.isNoneChecked()) {
      return;
    }

    const temp = this.claims.filter(claim => claim.selected);
    this.sharedData.inprocessStorage = temp;
    this.ids = [109];
    this.counter = 0;
    for (const clm of temp) {
      this.ids[this.counter] = clm.claimId;
      this.counter++;
    }

    this.awaitingProcessingRequest = new AwaitingProcessingRequest(
      this.userName,
      this.ids,
      this.activeStations,
      this.visns,
      this.privacyRestrictions
    );
    this.headers.append('Content-Type', 'application/json');
    const options = new RequestOptions({
      headers: this.headers,
      body: this.awaitingProcessingRequest
    });
    this.awaitingClaimsService.process(options).subscribe(
      data => (this.claims = data),
      () =>
        this.claims.forEach(claim => {
          claim.selected = false;
          claim.claimIdLink = '/claimDetail' + claim.claimId;
        })
    );
    this.searchheaders.append('Content-Type', 'application/json');
    const options2 = new RequestOptions({
      headers: this.searchheaders,
      body: this.ids,
      responseType: ResponseContentType.Text
    });
    console.log(this.ids);
    this.awaitingClaimsService
      .print(environment.nodeserver + '/claims/print/', options2)
      .subscribe(
      data => {
        const file = new Blob([String.fromCharCode.apply(null, data.data)], {
          type: 'application/pdf'
        });
        const fileUrl = URL.createObjectURL(file);
        console.log(
          JSON.stringify(String.fromCharCode.apply(null, data.data))
        );
        window.open(
          'http://SERVER.DOAMIN' +
          data.pathName.replace(
            '/usr/share/tomcat/latest/webapps/generatedReports',
            ''
          )
        );
      },
      () => console.log('back in console')
      );
  }
  canReroute(): boolean {
    return this.claims.every(claim => !claim.selected);
  }

  onReroute() {
    const selectedClaims = this.claims.filter(claim => claim.selected);
    this.rerouteService.setClaims(selectedClaims);
    this.router.navigate(['reroute']);
  }
}
