import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { DebugElement, SimpleChanges } from '@angular/core';

import { AwaitingProcessingComponent } from './awaiting-processing.component';
import { MenuComponent } from '../../shared/menu/menu.component';
import { By } from '@angular/platform-browser';
import { NavButtonComponent } from '../../shared/nav-button/nav-button.component';
import { TableComponent } from '../../shared/table/table.component';
import { RouterTestingModule } from '@angular/router/testing';
import { FormsModule } from '@angular/forms';
import { SpinnerComponent } from '../../shared/spinner/spinner.component';
import { NumResultsComponent } from '../../shared/table/numResults/numResults.component';
import { WindowRefService } from '../../window-ref.service';
import { RerouteService } from '../../shared/reroute/reroute.service';

import {
  Headers,
  BaseRequestOptions,
  Http,
  HttpModule,
  Response,
  ResponseOptions,
  RequestMethod,
  XHRBackend
} from '@angular/http';

import { TableService } from '../../shared/table/table.service';
import { RestService } from '../../shared/service/rest.service';
import { ReconcileService } from '../../claims/claim-detail/reconcile/reconcile.service';
import { SharedDataService } from '../../shared/service/shared-data.service';
import { AwaitingClaimsService } from './claims-awaiting-service';
import { PrintService } from '../../shared/print/service/print.component.service';

import { PaginationComponent } from '../../shared/table/pagination/pagination.component';
import { NumPerPageComponent } from '../../shared/table/numPerPage/numPerPage.component';
import { PrintComponent } from '../../shared/print/print.component';

describe('AwaitingProcessingComponent', () => {
  let component: AwaitingProcessingComponent;
  let fixture: ComponentFixture<AwaitingProcessingComponent>;

  beforeEach(
    async(() => {
      TestBed.configureTestingModule({
        imports: [HttpModule, RouterTestingModule, FormsModule],
        declarations: [
          AwaitingProcessingComponent,
          MenuComponent,
          NavButtonComponent,
          PrintComponent,
          TableComponent,
          PaginationComponent,
          NumPerPageComponent,
          SpinnerComponent,
          NumPerPageComponent,
          NumResultsComponent
        ],
        providers: [
          SharedDataService,
          AwaitingClaimsService,
          PrintService,
          TableService,
          RestService,
          ReconcileService,
          WindowRefService,
          RerouteService
        ]
      }).compileComponents();
    })
  );

  beforeEach(() => {
    fixture = TestBed.createComponent(AwaitingProcessingComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should be created', () => {
    expect(component).toBeTruthy();
  });

  it('should have upper "process and print" button Visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperProcessAndPrintButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have upper "process and print" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperProcessAndPrintButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have lower "process and print" button Visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerProcessAndPrintButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have lower "process and print" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerProcessAndPrintButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have upper "process Without print" button Visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperPrintWithoutProcessing')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have upper  "print Without processing" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperPrintWithoutProcessing')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have lower "print Without processing" button Visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerPrintWithoutProcessing')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have lower  "print Without processing" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerPrintWithoutProcessing')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have upper "process without print" button Visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperProcessWithoutPrinting')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have upper "process without printing" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperProcessWithoutPrinting')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have lower "process without printing" button Visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerProcessWithoutPrinting')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have lower "process without printing" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerProcessWithoutPrinting')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have upper "reroute" button Visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperReroute')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  // TODO: do testing once the reroute button is implememted

  //   it('should have upper  "reroute " button enabled', () => {
  //     let debugElement: DebugElement = fixture.debugElement.query(
  //       By.css("#upperReroute")
  //     );
  //     let htmlElement: HTMLElement = debugElement.nativeElement;

  //     expect(htmlElement).toBeTruthy();
  //     expect(htmlElement.getAttribute("disabled")).toBeNull();
  //   });

  //   it('should have lower "reroute" button Visible', () => {
  //     let debugElement: DebugElement = fixture.debugElement.query(
  //       By.css("#lowerReroute")
  //     );
  //     let htmlElement: HTMLElement = debugElement.nativeElement;

  //     expect(htmlElement).toBeTruthy();
  //     expect(htmlElement.hidden).toEqual(false);
  //     expect(htmlElement.hidden).toBe(false);
  //   });

  //   it('should have lower  "reroute" button enabled', () => {
  //     let debugElement: DebugElement = fixture.debugElement.query(
  //       By.css("#lowerReroute")
  //     );
  //     let htmlElement: HTMLElement = debugElement.nativeElement;

  //     expect(htmlElement).toBeTruthy();
  //     expect(htmlElement.getAttribute("disabled")).toBeNull();
  //   });

  it('should have upper "disapprove" button Visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperDisapprove')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have upper  "disapprove " button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperDisapprove')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have lower "disapprove" button Visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerDisapprove')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have lower "disapprove" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerDisapprove')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have "table" displayed', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#table')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
  });
});
