import { Component, Input, OnInit } from '@angular/core';
import { Headers, RequestOptions, URLSearchParams } from '@angular/http';
import { Router } from '@angular/router';

import { Claims } from '../../shared/models/Claims';
import { SharedDataService } from '../../shared/service/shared-data.service';
import { TableComponent } from '../../shared/table/table.component';
import { AwaitingProcessingRequest } from '../../shared/models/AwaitingProcessingRequest';
import { AgedClaimsService } from './aged.service';
import { ReconcileService } from '../claim-detail/reconcile/reconcile.service';
import { RerouteService } from './../../shared/reroute/reroute.service';
import { ColumnMetadata } from '../../shared/table/cols.model';

@Component({
  selector: 'app-aged',
  templateUrl: './aged.component.html',
  styleUrls: ['./aged.component.css']
})
export class AgedClaimsComponent implements OnInit {
  claims: any[] = [];
  ids: number[];
  activeStations: string[];
  visns: string[];
  privacyRestrictions: string[];
  userName: string;
  headers = new Headers();
  counter: number;
  fetchingData = true;
  awaitingProcessingRequest: AwaitingProcessingRequest;

  cols: ColumnMetadata[] = [
    new ColumnMetadata('select', 'Select?').setSelectBox(true),
    new ColumnMetadata('claimId', 'Claim ID').setAlign('right'),
    new ColumnMetadata('claimStatus', 'Claim Status'),
    new ColumnMetadata('claimType', 'Claim Type'),
    new ColumnMetadata('hero', 'HERO'),
    new ColumnMetadata('veteranName', 'Name'),
    new ColumnMetadata('claimDate', 'Claim Date').setAlign('right'),
    new ColumnMetadata('claimDate', 'Date in Proc').setAlign('right'),
    new ColumnMetadata('providerName', 'Provider'),
    new ColumnMetadata('lines', 'Total Lines').setAlign('right'),
    new ColumnMetadata('linesClosed', 'Lines Closed').setAlign('right'),
    new ColumnMetadata('facility', 'Facility').setAlign('right'),
    new ColumnMetadata('reconcileButton', 'Reconcile')
      .setAlign('center')
      .setButton(true)
      .setSort(false)
  ];
  @Input() btnClassPrimary = 'button primary';
  @Input() btnClassSecondary = 'button secondary';
  constructor(
    private router: Router,
    private sharedData: SharedDataService,
    private agedClaimsService: AgedClaimsService,
    private reconcileService: ReconcileService,
    private rerouteService: RerouteService
  ) {}

  ngOnInit() {
    if (
      !!sessionStorage.getItem('activeStations') &&
      !!sessionStorage.getItem('visns') &&
      !!sessionStorage.getItem('privacyRestrictions')
    ) {
      this.activeStations = sessionStorage.getItem('activeStations').split(',');
      this.visns = sessionStorage.getItem('visns').split(',');
      this.privacyRestrictions = sessionStorage
        .getItem('privacyRestrictions')
        .split(',');
    }
    this.awaitingProcessingRequest = new AwaitingProcessingRequest(
      this.userName,
      this.ids,
      this.activeStations,
      this.visns,
      this.privacyRestrictions
    );
    this.headers.append('Content-Type', 'application/json');
    console.log(
      'awaitingProcessing request is : ' +
        JSON.stringify(this.awaitingProcessingRequest)
    );
    const options = new RequestOptions({
      headers: this.headers,
      body: this.awaitingProcessingRequest
    });
    this.agedClaimsService.getAllAgedClaims(options).subscribe(
      data => {
        this.claims = data;
        this.claims.forEach(claim => {
          claim.selected = false;
          claim.claimIdLink = '/claimDetail/' + claim.claimId;
          this.fetchingData = false;
        });
      },
      error => alert(error)
    );
  }

  buttonClick($event) {
    const target =
      <HTMLButtonElement>event.target ||
      event.srcElement ||
      event.currentTarget;
    console.log('Pressed button #' + event.srcElement.id);
  }

  isAllChecked(): boolean {
    return this.claims.every(claim => claim.selected);
  }
  isNoneChecked(): boolean {
    return this.claims.every(claim => !claim.selected);
  }
  setClaimId(event) {
    console.log('aged component setClaimid func ', event.item.claimId);
    this.reconcileService.setClaimId(event.item.claimId);
    this.router.navigate(['/reconcile']);
  }
  onReroute() {
    const selectedClaims = this.claims.filter(claim => claim.selected);
    this.rerouteService.setClaims(selectedClaims);
    this.router.navigate(['reroute']);
  }
}
