import {
  async,
  fakeAsync,
  getTestBed,
  inject,
  tick,
  ComponentFixture,
  TestBed
} from '@angular/core/testing';
import { RouterTestingModule } from '@angular/router/testing';
import { Observable } from 'rxjs/Observable';
import { DebugElement, SimpleChanges } from '@angular/core';
import { By } from '@angular/platform-browser';
import { FormsModule } from '@angular/forms';
import {
  Headers,
  BaseRequestOptions,
  Http,
  HttpModule,
  Response,
  ResponseOptions,
  RequestMethod,
  XHRBackend
} from '@angular/http';
import { MockBackend, MockConnection } from '@angular/http/testing';

import { SharedDataService } from '../../shared/service/shared-data.service';
import { AgedClaimsService } from './aged.service';
import { ReconcileService } from '../../claims/claim-detail/reconcile/reconcile.service';
import { AgedClaimsComponent } from './aged.component';
import { MenuComponent } from '../../shared/menu/menu.component';
import { NavButtonComponent } from '../../shared/nav-button/nav-button.component';
import { TableComponent } from '../../shared/table/table.component';
import { PaginationComponent } from '../../shared/table/pagination/pagination.component';
import { NumPerPageComponent } from '../../shared/table/numPerPage/numPerPage.component';
import { PrintComponent } from '../../shared/print/print.component';
import { PrintService } from '../../shared/print/service/print.component.service';
import { TableService } from '../../shared/table/table.service';
import { RestService } from '../../shared/service/rest.service';
import { SpinnerComponent } from '../../shared/spinner/spinner.component';
import { NumResultsComponent } from '../../shared/table/numResults/numResults.component';
import { WindowRefService } from '../../window-ref.service';
import { RerouteService } from './../../shared/reroute/reroute.service';

describe('AgedClaimsComponent', () => {
  let component: AgedClaimsComponent;
  let fixture: ComponentFixture<AgedClaimsComponent>;

  beforeEach(
    async(() => {
      TestBed.configureTestingModule({
        imports: [HttpModule, RouterTestingModule, FormsModule],
        declarations: [
          AgedClaimsComponent,
          MenuComponent,
          NavButtonComponent,
          PrintComponent,
          TableComponent,
          PaginationComponent,
          NumPerPageComponent,
          SpinnerComponent,
          NumResultsComponent
        ],
        providers: [
          AgedClaimsService,
          PrintService,
          SharedDataService,
          ReconcileService,
          TableService,
          RestService,
          WindowRefService,
          RerouteService
        ]
      }).compileComponents();
    })
  );

  beforeEach(() => {
    fixture = TestBed.createComponent(AgedClaimsComponent);
    component = fixture.componentInstance;

    sessionStorage.setItem('activeStations', '123,124,125');

    fixture.detectChanges();
  });

  it('should be created', () => {
    expect(component).toBeTruthy();
  });

  it('should have upper "print" button be visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperPrint')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have upper "print" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperPrint')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have lower print button be visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerPrint')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have lower "print" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerPrint')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have upper "reroute" button be visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperRerouteButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have upper "reroute" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperRerouteButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
  });

  it('should have lower "reroute" button be visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerRerouteButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have lower "reroute" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerRerouteButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
  });

  it('should have upper "disapprove" button be visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperDisapproveButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have upper "disapprove" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#upperDisapproveButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have lower "disapprove" button be visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerDisapproveButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have lower "disapprove" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#lowerDisapproveButton')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have table displayed', () => {
    let debugElement: DebugElement = fixture.debugElement.query(
      By.css('#table')
    );
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
  });
});
