import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';
import { AppRoutingModule } from './app-routing.module';
import { HttpModule } from '@angular/http';
import { AppComponent } from './app.component';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { RouterModule } from '@angular/router';
import {
  ToolsComponent,
  CreateUserRequestComponent,
  DiagnosisCodeLookupComponent,
  MedicalCodeLookupComponent,
  ModifyUserRequestComponent,
  SearchUserRequestComponent,
  PrivacyRestrictionsComponent,
  AddStationComponent,
  StationMaintenanceEditComponent,
  EditStationService,
  SearchStationComponent,
  AddStationReroute,
  ViewStationComponent,
  ViewVisnComponent,
  ViewTypeComponent
} from './tools/index';
import { StationMaintenanceAddZipCodeComponent } from './tools/station-maintenance/addZipCode/station-maintenance-add-zip-code.component';
import { StationMaintenanceAddZipCodeService } from './tools/station-maintenance/addZipCode/station-maintenance-add-zip-code.service';
import { StationMaintenanceAddContactInfoComponent } from './tools/station-maintenance/add-contact-info/station-maintenance-add-contact-info.component';
import { StationMaintenanceAddContactInfoService } from './tools/station-maintenance/add-contact-info/station-maintenance-add-contact-info.service';
import { ReportsComponent } from './reports/index';
import { HelpComponent } from './help/help.component';
import { HomeComponent } from './home/home.component';
import { LoginComponent } from './login/login.component';
import {
  AgedClaimsComponent,
  AwaitingProcessingComponent,
  ClaimLookUpComponent,
  InProcessClaimsComponent,
  OutOfSystemPaymentComponent,
  DisapproveComponent,
  RejectClaimComponent,
  RejectClaimsService
} from './claims/index';
import { ClaimDetailComponent } from './claims/claim-detail/claim-detail.component';
import { PagetestComponent } from './test/pagetest/pagetest.component';
import { Pagetest1Component } from './test/pagetest1/pagetest1.component';
import { SharedDataService } from './shared/service/shared-data.service';
import { NavButtonComponent } from './shared/nav-button/nav-button.component';
import { TableComponent } from './shared/table/table.component';
import { PaginationComponent } from './shared/table/pagination/pagination.component';
import { NumPerPageComponent } from './shared/table/numPerPage/numPerPage.component';
import { NumResultsComponent } from './shared/table/numResults/numResults.component';
import { AwaitingClaimsService } from './claims/awaiting-processing/claims-awaiting-service';
import { DisapproveService } from './claims/disapprove/service/disapprove.service';
import { AgedClaimsService } from './claims/aged/aged.service';
import { ClaimLookUpComponentService } from './claims/claim-look-up/claim-look-up.component.service';
import { ProcessAndPrintService } from './shared/process-and-print/service/process.component.service';
import { PrintService } from './shared/print/service/print.component.service';
import { AuthenticationService } from './login/service/login.service';
import { ErrorPageComponent } from './login/error-page/error-page.component';
import { InProcessClaimsService } from './claims/in-process/in-process.service';
import { RestService } from './shared/service/rest.service';
import { AssignComponent } from './shared/assign/assign.component';
import { ScriptService } from './shared/scriptLoader/script.service';
import { TableService } from './shared/table/table.service';
import { ReconcileService } from './claims/claim-detail/reconcile/reconcile.service';
import { ClaimDetailService } from './claims/claim-detail/claim-detail.service';

import {
  CardComponent,
  FooterComponent,
  MenuComponent,
  PrintComponent,
  RerouteComponent,
  ProcessAndPrintComponent,
  RerouteService
} from './shared/index';
import {
  AdditionalComponent,
  DiagnosisComponent,
  LineComponent,
  RejectionHistoryComponent,
  ReroutingHistoryComponent
} from './claims/claim-detail/index';
import { ReconcileComponent } from './claims/claim-detail/reconcile/reconcile.component';
import { ManualReconcilationComponent } from './claims/claim-detail/manual-reconcilation/manual-reconcilation.component';
import { ClaimsHomePageComponent } from './claims/claims-home-page/claims-home-page.component';
import { ModalComponent } from './shared/modal/modal.component';
import { OkDisapprovalService } from './claims/reject-claim/service/ok-disapproval.sevice';
import { AddStationService } from './tools/station-maintenance/addStation/service/add-station.service';
import { PaymentErrorsComponent } from './claims/payment-errors/payment-errors.component';
import { UnmatchedPaymentsComponent } from './claims/unmatched-payments/unmatched-payments.component';
import { OhiInfoComponent } from './claims/claim-detail/ohi-info/ohi-info.component';
import { WindowRefService } from './window-ref.service';
import { SpinnerComponent } from './shared/spinner/spinner.component';
import { FppsLoginComponent } from './test/fpps-login/fpps-login.component';
import { FormTestComponent } from './test/form-test/form-test.component';
import { ViewStationService } from 'app/tools/station-maintenance/view-station/view-station.service';
import { VisnService } from 'app/tools/station-maintenance/view-visn/view-visn.service';
import { TypeService } from 'app/tools/station-maintenance/view-type/view-type.service';
import { ClaimsCompletedComponent } from './reports/claims-completed/claims-completed.component';
import { WarningModalComponent } from './shared/modal/warning-modal/warning-modal.component';
import { ModalTestComponent } from './test/modal-test/modal-test.component';
import { EditZipCodeComponent } from './tools/station-maintenance/edit-zip-code/edit-zip-code.component';
import { EditContactInfoComponent } from './tools/station-maintenance/edit-contact-info/edit-contact-info.component';

@NgModule({
  declarations: [
    AppComponent,
    ToolsComponent,
    CreateUserRequestComponent,
    DiagnosisCodeLookupComponent,
    MedicalCodeLookupComponent,
    ModifyUserRequestComponent,
    SearchUserRequestComponent,
    PrivacyRestrictionsComponent,
    AddStationComponent,
    HelpComponent,
    HomeComponent,
    LoginComponent,
    ClaimLookUpComponent,
    AwaitingProcessingComponent,
    InProcessClaimsComponent,
    AgedClaimsComponent,
    RerouteComponent,
    DisapproveComponent,
    ProcessAndPrintComponent,
    PrintComponent,
    ClaimLookUpComponent,
    MenuComponent,
    FooterComponent,
    AssignComponent,
    CardComponent,
    NavButtonComponent,
    TableComponent,
    PaginationComponent,
    NumPerPageComponent,
    NumResultsComponent,
    PagetestComponent,
    Pagetest1Component,
    AdditionalComponent,
    DiagnosisComponent,
    LineComponent,
    ReroutingHistoryComponent,
    RejectionHistoryComponent,
    ErrorPageComponent,
    ClaimDetailComponent,
    ReconcileComponent,
    ManualReconcilationComponent,
    RejectClaimComponent,
    ClaimsHomePageComponent,
    ModalComponent,
    ReportsComponent,
    OutOfSystemPaymentComponent,
    PaymentErrorsComponent,
    UnmatchedPaymentsComponent,
    StationMaintenanceEditComponent,
    StationMaintenanceAddZipCodeComponent,
    StationMaintenanceAddContactInfoComponent,
    SearchStationComponent,
    AddStationReroute,
    OhiInfoComponent,
    ViewStationComponent,
    ViewVisnComponent,
    ViewTypeComponent,
    SpinnerComponent,
    FppsLoginComponent,
    FormTestComponent,
    ClaimsCompletedComponent,
    WarningModalComponent,
    ModalTestComponent,
    EditZipCodeComponent,
    EditContactInfoComponent
  ],
  imports: [
    BrowserModule,
    FormsModule,
    HttpModule,
    AppRoutingModule,
    RouterModule,
    ReactiveFormsModule
  ],
  providers: [
    SharedDataService,
    AwaitingClaimsService,
    AgedClaimsService,
    ClaimLookUpComponentService,
    ProcessAndPrintService,
    PrintService,
    AuthenticationService,
    InProcessClaimsService,
    RestService,
    DisapproveService,
    RejectClaimsService,
    TableService,
    OkDisapprovalService,
    ScriptService,
    ReconcileService,
    AddStationService,
    EditStationService,
    RerouteService,
    ClaimDetailService,
    WindowRefService,
    StationMaintenanceAddZipCodeService,
    StationMaintenanceAddContactInfoService,
    ViewStationService,
    ViewVisnComponent,
    TypeService
  ],
  bootstrap: [AppComponent]
})
export class AppModule {}
