import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { PagetestComponent } from './test/pagetest/pagetest.component';
import { Pagetest1Component } from './test/pagetest1/pagetest1.component';
import { FppsLoginComponent } from './test/fpps-login/fpps-login.component';
import { FormTestComponent } from './test/form-test/form-test.component';
import { ModalTestComponent } from './test/modal-test/modal-test.component';

import {
  AgedClaimsComponent,
  AwaitingProcessingComponent,
  ClaimLookUpComponent,
  InProcessClaimsComponent,
  ClaimDetailComponent,
  UnmatchedPaymentsComponent,
  PaymentErrorsComponent,
  OutOfSystemPaymentComponent,
  DisapproveComponent,
  RejectClaimComponent
} from './claims/index'; // Claims Imports
import { ClaimsHomePageComponent } from './claims/claims-home-page/claims-home-page.component';
import { HelpComponent } from './help/index'; // Help Imports
import { HomeComponent } from './home/index'; // home Imports
import { LoginComponent, ErrorPageComponent } from './login/index'; // Login Imports
import {
  ReconcileComponent,
  ManualReconcilationComponent
} from './claims/claim-detail/index'; // Reports Imports
import {
  ToolsComponent,
  CreateUserRequestComponent,
  DiagnosisCodeLookupComponent,
  MedicalCodeLookupComponent,
  ModifyUserRequestComponent,
  SearchUserRequestComponent,
  PrivacyRestrictionsComponent,
  AddStationComponent,
  StationMaintenanceEditComponent,
  SearchStationComponent,
  AddStationReroute,
  ViewStationComponent,
  ViewVisnComponent,
  ViewTypeComponent
} from './tools/index';
import { StationMaintenanceAddZipCodeComponent } from './tools/station-maintenance/addZipCode/station-maintenance-add-zip-code.component';
import { StationMaintenanceAddContactInfoComponent } from './tools/station-maintenance/add-contact-info/station-maintenance-add-contact-info.component';
import { ReportsComponent, ClaimsCompletedComponent } from './reports/index';
import {
  CardComponent,
  PrintComponent,
  ProcessAndPrintComponent,
  RerouteComponent
} from './shared/index'; // Shared Import
import { EditZipCodeComponent } from './tools/station-maintenance/edit-zip-code/edit-zip-code.component';
import { EditContactInfoComponent } from './tools/station-maintenance/edit-contact-info/edit-contact-info.component';

const routes: Routes = [
  { path: '', component: LoginComponent, pathMatch: 'full' },
  { path: 'pagetest', component: PagetestComponent },
  { path: 'pagetest1', component: Pagetest1Component },
  { path: 'home', component: HomeComponent },
  { path: 'login', component: LoginComponent },
  { path: 'loginError', component: ErrorPageComponent },
  { path: 'search', component: ClaimLookUpComponent },
  { path: 'tools', component: ToolsComponent },
  { path: 'claimDetail/:id', component: ClaimDetailComponent },
  { path: 'inProcessClaims', component: InProcessClaimsComponent },
  { path: 'awaitingProcessing', component: AwaitingProcessingComponent },
  { path: 'reroute', component: RerouteComponent },
  { path: 'disapprove', component: DisapproveComponent },
  { path: 'agedClaims', component: AgedClaimsComponent },
  { path: 'processAndPrint', component: ProcessAndPrintComponent },
  { path: 'print', component: PrintComponent },
  { path: 'createUserRequest', component: CreateUserRequestComponent },
  { path: 'diagnosisCodeLookUp', component: DiagnosisCodeLookupComponent },
  { path: 'medicalCodeLookUp', component: MedicalCodeLookupComponent },
  { path: 'modifyUserRequest', component: ModifyUserRequestComponent },
  { path: 'searchUserRequest', component: SearchUserRequestComponent },
  { path: 'modifyUserRequest/:id', component: ModifyUserRequestComponent },
  { path: 'privacyRestriction', component: PrivacyRestrictionsComponent },
  { path: 'addStation', component: AddStationComponent },
  { path: 'addstationreroute', component: AddStationReroute },
  { path: 'reconcile', component: ReconcileComponent },
  { path: 'manualReconcilation/:id', component: ManualReconcilationComponent },
  { path: 'outOfSystemPayment', component: OutOfSystemPaymentComponent },
  { path: 'reject', component: RejectClaimComponent },
  { path: 'claimsHomePage', component: ClaimsHomePageComponent },
  { path: 'unmatchedPayments', component: UnmatchedPaymentsComponent },
  { path: 'paymentErrors', component: PaymentErrorsComponent },
  { path: 'stationMaintanceEdit', component: StationMaintenanceEditComponent },
  { path: 'viewStation/:id', component: ViewStationComponent },
  { path: 'visn/:id', component: ViewVisnComponent },
  { path: 'type/:id', component: ViewTypeComponent },
  { path: 'addZipCode', component: StationMaintenanceAddZipCodeComponent },
  {
    path: 'addContactInfo',
    component: StationMaintenanceAddContactInfoComponent
  },
  { path: 'searchStation', component: SearchStationComponent },
  { path: 'fppsLogin', component: FppsLoginComponent },
  { path: 'formtest', component: FormTestComponent },
  { path: 'claimsCompleted', component: ClaimsCompletedComponent },
  { path: 'modaltest', component: ModalTestComponent },
  { path: 'editZipCode', component: EditZipCodeComponent },
  { path: 'editContactInfo', component: EditContactInfoComponent }
];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule]
})
export class AppRoutingModule {}
