const express = require("express");
const path = require("path");
const http = require("http");
const bodyParser = require("body-parser");
const app = express();
// Added to read the endPointURI from the properties file
const dotenv = require('dotenv').config();

app.use(bodyParser.json());
app.use(
  bodyParser.urlencoded({
    extended: false
  })
);
app.use(express.static(path.join(__dirname, "./dist")));
app.use(function (req, res, next) {
  res.header("Access-Control-Allow-Origin", "*");
  res.header(
    "Access-Control-Allow-Headers",
    "Origin, X-Requested-With, Content-Type, Accept"
  );
  next();
});

const claimsToDispprove = require("./fpps-app-server/server/routes/disapproveClaim/claims");
const disapprove = require("./fpps-app-server/server/routes/disapproveClaim/disapprove");
const reports = require("./fpps-app-server/server/routes/reports/index");
const rejectClaims = require("./fpps-app-server/server/routes/rejectClaims/reject-claims");
const okDisapproval = require("./fpps-app-server/server/routes/rejectClaims/okDisapproval");
const reverseDisapproval = require("./fpps-app-server/server/routes/rejectClaims/reverseDisapproval");
const reconciliation = require('./fpps-app-server/server/routes/reconciliation/reconciliation');
const editStation = require('./fpps-app-server/server/routes/tools/stationMaintenance/editStation');

const login = require("./fpps-app-server/server/routes/login/login");
const tools = require('./fpps-app-server/server/routes/tools/tools');
const claims = require('./fpps-app-server/server/routes/claims/claims');

app.use("/login", login);
app.use('/tools', tools);
app.use('/claims', claims);

app.use('/reconciliation', reconciliation);
app.use("/reports", reports);
app.use("/claimsToDispprove", claimsToDispprove);
app.use("/disapprove", disapprove);
app.use("/rejectClaims", rejectClaims);
app.use("/okDisapproval", okDisapproval);
app.use("/reverseDisapproval", reverseDisapproval);

app.use("/editStation", editStation);


const port = process.env.PORT || "3000";
app.set("port", port);
const server = http.createServer(app);

app.get("*", (req, res) => {
  res.sendFile(path.join(__dirname, "./dist/index.html"));
});

server.listen(port, () => console.log(`API running on localhost:${port} - Using endpoint ` + process.env.END_POINT_BASE_URI));
