const express = require("express");
const router = express.Router();
var PropertiesReader = require("properties-reader");
var properties = PropertiesReader("./fpps-app-server/server/routes/properties");
const bodyParser = require("body-parser");
const rest = require("../../../rest/rest");

router.use(bodyParser.json());
router.use(bodyParser.urlencoded({
	extended: false
}));

router.get("/roles", (req, res) => {
	rest.getResource(
		process.env.END_POINT_BASE_URI + process.env.USER_REQUEST_FORM,
		req.body.body
	).then(data => {
		res.status(200).json(data);
	});
});
router.post("/", (req, res) => {
	rest.postResource(
		process.env.END_POINT_BASE_URI + process.env.USER_REQUEST,
		req.body.body
	).then(data => {
		res.status(200).json(data);
	});
});

router.put("/", (req, res) => {
	rest.putResource(
		process.env.END_POINT_BASE_URI + process.env.USER_REQUEST,
		req.body.body
	).then(data => {
		res.status(200).json(data);
	});
});

router.get("/:id", (req, res) => {
	rest.getResource(
		process.env.END_POINT_BASE_URI + process.env.USER_REQUEST_FORM + req.params.id,
		req.body.body
	).then(data => {
		res.status(200).json(data);
	});
});

router.post("/search", (req, res) => {
	rest.postResource(
		process.env.END_POINT_BASE_URI + process.env.USER_SEARCH,
		req.body.body
	).then(data => {
		res.status(200).json(data);
	});
});

module.exports = router;
