const express = require('express');
const router = express.Router();

const userRequest = require('./userRequest/userRequest');
const diagnosisCodes = require('./diagnosisCodeLookup');
const medicalCodes = require('./medicalCodeLookup');
const addStation = require('./stationMaintenance/addStation');
const searchStation = require('./stationMaintenance/searchStation');
const viewStation = require('./stationMaintenance/viewStation');
const addZipCode = require('./stationMaintenance/addZipCode');
const addContactInfo = require('./stationMaintenance/addContactInfo');
const viewVisn = require('./stationMaintenance/viewVisn');
const viewType = require('./stationMaintenance/viewType');

router.use('/userRequest', userRequest);
router.use('/diagnosisCodes', diagnosisCodes);
router.use('/medicalCodes', medicalCodes);
router.use('/addStation', addStation);
router.use('/searchStation', searchStation);
router.use('/viewStation', viewStation);
router.use('/addZipCode', addZipCode);
router.use('/addContactInfo', addContactInfo);
router.use('/type', viewType);
router.use('/visn', viewVisn);

module.exports = router;
