const express = require("express");
const router = express.Router();
var PropertiesReader = require("properties-reader");
var properties = PropertiesReader("./fpps-app-server/server/routes/properties");
const bodyParser = require("body-parser");
const rest = require("../../../rest/rest");

router.use(bodyParser.json());
router.use(bodyParser.urlencoded({
  extended: false
}));

router.get(`/:id`, (req, res) => {
  rest.getResource(process.env.END_POINT_BASE_URI + process.env.GET_STATION_INFO + req.params.id).then(data => {
    res.status(200).json(data);
  })
});

router.get(`/:stationName`, (req, res) => {
  rest.getResource(process.env.END_POINT_BASE_URI + "/fpps/api/v1/VaFacility/getStationInfo/" + req.params.stationName).then(data => {
    res.status(200).json(data);
  })
});

module.exports = router;
