const express = require('express');
const router = express.Router();
var PropertiesReader = require('properties-reader');
const bodyParser = require('body-parser');
const rest = require('../../../rest/rest');

const baseUrl = process.env.END_POINT_BASE_URI + '/fpps/api/v1/';

router.use(bodyParser.json());

router.put('/updateStation', (req, res) => {
  rest
    .putResource(`${baseUrl}VaFacility/station`, req.body)
    .then(data => {
      res.status(200).json(data);
    })
    .catch(error => console.log('/updateStation error ', error));
});

router.get('/visns', (req, res) => {
  rest
    .getResource(`${baseUrl}VaFacility/station/visn`)
    .then(data => {
      res.status(200).json(data);
    })
    .catch(error => console.log('/visns error ', error));
});

router.get('/types', (req, res) => {
  rest
    .getResource(`${baseUrl}VaFacility/station/type`)
    .then(data => {
      res.status(200).json(data);
    })
    .catch(error => console.log('/visns error ', error));
});

router.get('/getStationInfo/:station', (req, res) => {
  const station = req.params.station;
  rest
    .getResource(`${baseUrl}VaFacility/stations/${station}`)
    .then(data => {
      res.status(200).json(data);
    })
    .catch(error => console.log('getStationInfo node', error));
});

router.delete('/deleteStation/:station', (req, res) => {
  const stationName = req.params.station;
  rest
    .deleteResource(`${baseUrl}VaFacility/station/${stationName}`)
    .then(data => {
      res.status(200).json(data);
    })
    .catch(error => console.log('getStationInfo node', error));
});

module.exports = router;
