const express = require("express");
const router = express.Router();
var PropertiesReader = require("properties-reader");
var properties = PropertiesReader("./fpps-app-server/server/routes/properties");
const bodyParser = require("body-parser");
const rest = require("../../../rest/rest");

router.use(bodyParser.json());
router.use(bodyParser.urlencoded({
	extended: false
}));

router.get(`/zipCodeCheck/:zipCode`, (req, res) => {
	const id = req.params.zipCode;
	// console.log('Zip Code Check URL = ' + process.env.END_POINT_BASE_URI + process.env.CHECK_ZIP_CODE_EXISTS + id);
	// console.log('   END_POINT_BASE_URI = ' + END_POINT_BASE_URI);
	// console.log('   CHECK_ZIP_CODE_EXISTS');
	rest.getResource(process.env.END_POINT_BASE_URI + process.env.CHECK_ZIP_CODE_EXISTS + id).then(data => {
		res.status(200).json(data);
	})
});

router.post("/zipCodeSave", (req, res) => {
	rest.postResource(
		process.env.END_POINT_BASE_URI + process.env.VA_FACILITY_ZIPCODE,
		req.body
	).then(data => {
		res.status(200).json(data);
	});
});

module.exports = router;
