const express = require("express");
const router = express.Router();
const rest = require("../../rest/rest");

router.get("/groupCodes", (req, res) => {
	rest.getResource(
		process.env.END_POINT_BASE_URI + process.env.ADJUSTMENT_GROUPS, req.body.body
	).then(data => {
		res.status(200).json(data);
	});
});

router.get("/CARCs/:groupCode", (req, res) => {
	rest.getResource(
		process.env.END_POINT_BASE_URI + process.env.ADJUSTMENT_REASONS + req.params.groupCode, req.body.body
	).then(data => {
		res.status(200).json(data);
	});
});

router.get("/RARCs/:CARC", (req, res) => {
	rest.getResource(
		process.env.END_POINT_BASE_URI + process.env.REMITTANCE_REMARKS + req.params.CARC, req.body.body
	).then(data => {
		res.status(200).json(data);
	});
});

router.post("/", (req, res) => {
	rest.postResource(
		process.env.END_POINT_BASE_URI + process.env.MANUAL_RECONCILIATION, req.body.body
	).then(data => {
		res.status(200).json(data);
	});
});

module.exports = router;
