const express = require("express");
const router = express.Router();
var PropertiesReader = require("properties-reader");
const bodyParser = require("body-parser");
const rest = require("../../rest/rest");

const baseUrl = process.env.END_POINT_BASE_URI + "/fpps/api/v1/";

router.use(bodyParser.json());

// gets groups to pre-populate edit claim payment information select input
router.get("/groups", (req, res) => {
	rest
		.getResource(`${baseUrl}adjustments/groups`)
		.then(data => {
			// console.log('node groups response ', data);
			res.status(200).json(data);
		})
		.catch(error => console.log("catching error groups - ", error));
});

router.get("/reasons", (req, res) => {
	rest
		.getResource(`${baseUrl}adjustments/reasons`)
		.then(data => {
			// console.log('node groups response ', data);
			res.status(200).json(data);
		})
		.catch(error => console.log("catching error groups - ", error));
});

router.get(`/:claimId`, (req, res) => {
	const id = req.params.claimId;
	console.log("node claimid ", id);
	rest
		.getResource(`${baseUrl}reconciliation/unmatchedClaim/${id}`)
		.then(data => {
			res.status(200).json(data);
		});
});

router.post("/", (req, res) => {
	const body = req.body;
	// console.log('body on node', body)
	rest
		.postResource(`${baseUrl}reconciliation/unmatchedClaim/claimPayments`, body)
		.then(data => {
			// console.log(body)
			// console.log(data)
			res.status(200).json(data);
		})
		.catch(error => console.log("catching error - ", error));
});

router.post("/editPaymentInformation", (req, res) => {
	const body = req.body;
	// console.log('body on editpaymentinfo node', body)
	rest
		.postResource(
		`${baseUrl}reconciliation/unmatchedClaim/editpaymentInformation`,
		body
		)
		.then(data => {
			res.status(200).json(data);
		})
		.catch(error => console.log("catching error - ", error));
});
// editPaymentInformation
// get paymentlines
router.get("/editPaymentInformation/:feeClaimPaymentLineId", (req, res) => {
	const id = req.params.feeClaimPaymentLineId;
	rest
		.getResource(
		`${baseUrl}reconciliation/unmatchedClaim/editpaymentInformation/${id}`
		)
		.then(data => {
			res.status(200).json(data);
		})
		.catch(error => console.log("editPaymentInformation catch error ", error));
});

router.get("/paymentLines/:claimId", (req, res) => {
	const id = req.params.claimId;
	// console.log('const id ', id)
	rest
		.getResource(`${baseUrl}reconciliation/unmatchedClaim/paymentLines/${id}`)
		.then(response => {
			// console.log('node success response ', response);
			// console.log('node resp ', response);
			res.status(200).json(response);
		})
		.catch(error => console.log("catching error - ", error));
});

// get lineItems
router.get("/lineItems/:claimId", (req, res) => {
	const id = req.params.claimId;
	rest
		.getResource(`${baseUrl}claim/lineItems/${id}`)
		.then(response => {
			// console.log('node success response ', response);
			// console.log('node resp lineItems ', response);
			res.status(200).json(response);
		})
		.catch(error => console.log("catching error - ", error));
});

// gets reasons to pre-populate edit claim payment information select input

module.exports = router;
