package com.example.tests;

import java.util.regex.Pattern;
import java.util.concurrent.TimeUnit;
import org.junit.*;
import static org.junit.Assert.*;
import static org.hamcrest.CoreMatchers.*;
import org.openqa.selenium.*;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.support.ui.Select;

public class Tools {
  private WebDriver driver;
  private String baseUrl;
  private boolean acceptNextAlert = true;
  private StringBuffer verificationErrors = new StringBuffer();

  @Before
  public void setUp() throws Exception {
    driver = new FirefoxDriver();
    baseUrl = "http://localhost:4200/";
    driver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);
  }

  @Test
  public void testTools() throws Exception {
    driver.findElement(By.xpath("(//button[@onclick='menuDropdown(this.id)'])[3]")).click();
    driver.findElement(By.cssSelector("li > a")).click();
    for (int second = 0;; second++) {
    	if (second >= 60) fail("timeout");
    	try { if (isElementPresent(By.cssSelector("h2"))) break; } catch (Exception e) {}
    	Thread.sleep(1000);
    }

    assertEquals("Create User Request", driver.findElement(By.cssSelector("h2")).getText());
    driver.findElement(By.xpath("(//button[@onclick='menuDropdown(this.id)'])[3]")).click();
    driver.findElement(By.xpath("(//a[contains(text(),'Modify User Request')])[2]")).click();
    for (int second = 0;; second++) {
    	if (second >= 60) fail("timeout");
    	try { if (isElementPresent(By.cssSelector("h1"))) break; } catch (Exception e) {}
    	Thread.sleep(1000);
    }

    assertEquals("Modify User Request", driver.findElement(By.cssSelector("h1")).getText());
    driver.findElement(By.xpath("(//button[@onclick='menuDropdown(this.id)'])[3]")).click();
    driver.findElement(By.xpath("(//a[contains(text(),'Privacy Restrictions')])[2]")).click();
    for (int second = 0;; second++) {
    	if (second >= 60) fail("timeout");
    	try { if (isElementPresent(By.cssSelector("h1"))) break; } catch (Exception e) {}
    	Thread.sleep(1000);
    }

    assertEquals("Privacy Restrictions", driver.findElement(By.cssSelector("h1")).getText());
    driver.findElement(By.xpath("(//button[@onclick='menuDropdown(this.id)'])[3]")).click();
    driver.findElement(By.xpath("(//a[contains(text(),'Add Station')])[2]")).click();
    for (int second = 0;; second++) {
    	if (second >= 60) fail("timeout");
    	try { if (isElementPresent(By.cssSelector("h1"))) break; } catch (Exception e) {}
    	Thread.sleep(1000);
    }

    assertEquals("Station Maintenance", driver.findElement(By.cssSelector("h1")).getText());
    driver.findElement(By.xpath("(//button[@onclick='menuDropdown(this.id)'])[3]")).click();
    driver.findElement(By.linkText("Search/Modify")).click();
    assertEquals("Station Maintenance", driver.findElement(By.cssSelector("h1")).getText());
    driver.findElement(By.xpath("(//button[@onclick='menuDropdown(this.id)'])[3]")).click();
    driver.findElement(By.xpath("(//a[contains(text(),'Diagnosis Code Lookup')])[2]")).click();
    assertEquals("Diagnosis Code Lookup", driver.findElement(By.cssSelector("h1")).getText());
    driver.findElement(By.xpath("(//button[@onclick='menuDropdown(this.id)'])[3]")).click();
    driver.findElement(By.xpath("(//a[contains(text(),'Medical Code Lookup')])[2]")).click();
    assertEquals("Medical Code Lookup", driver.findElement(By.cssSelector("h1")).getText());
    driver.findElement(By.xpath("(//button[@onclick='menuDropdown(this.id)'])[3]")).click();
  }

  @After
  public void tearDown() throws Exception {
    driver.quit();
    String verificationErrorString = verificationErrors.toString();
    if (!"".equals(verificationErrorString)) {
      fail(verificationErrorString);
    }
  }

  private boolean isElementPresent(By by) {
    try {
      driver.findElement(by);
      return true;
    } catch (NoSuchElementException e) {
      return false;
    }
  }

  private boolean isAlertPresent() {
    try {
      driver.switchTo().alert();
      return true;
    } catch (NoAlertPresentException e) {
      return false;
    }
  }

  private String closeAlertAndGetItsText() {
    try {
      Alert alert = driver.switchTo().alert();
      String alertText = alert.getText();
      if (acceptNextAlert) {
        alert.accept();
      } else {
        alert.dismiss();
      }
      return alertText;
    } finally {
      acceptNextAlert = true;
    }
  }
}
