package testing;

import java.io.File;
import java.util.concurrent.TimeUnit;
import static org.junit.Assert.*;
import org.openqa.selenium.*;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;


public class Tools {
  private WebDriver driver;
  private String baseUrl;
  private boolean acceptNextAlert = true;
  private StringBuffer verificationErrors = new StringBuffer();
  
  public static void main(String args[]) {
	  JUnitCore junit = new JUnitCore();
	  junit.addListener(new TextListener(System.out));
	  Result result = junit.run(Tools.class); // Replace "SampleTest" with the name of your class
	  if (result.getFailureCount() > 0) {
	    System.out.println("Test failed.");
	    System.exit(1);
	  } else {
	    System.out.println("Test finished successfully.");
	    System.exit(0);
	  }
	}

  @Before
  public void setUp() throws Exception {
	System.out.println("Tools: Begin setUp()");  
	
	File file=new File("drivers/IEDriverServer.exe");
	System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
    driver = new InternetExplorerDriver();
    baseUrl = "http://localhost:4200/";
    driver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);
    
    System.out.println("Tools: End setUp()");  
  }

  @Test
  public void testTools() throws Exception {
	System.out.println("Tools: Begin testTools()");  
	  
	driver.get(baseUrl+"tools");
    driver.findElement(By.id("(//button[@onclick='menuDropdown(this.id)'])[3]")).click();
    driver.findElement(By.cssSelector("li > a")).click();
    for (int second = 0;; second++) {
    	if (second >= 60) fail("timeout");
    	try { if (isElementPresent(By.cssSelector("h2"))) break; } catch (Exception e) {}
    	Thread.sleep(1000);
    }

    assertEquals("Create User Request", driver.findElement(By.cssSelector("h2")).getText());
    driver.findElement(By.id("create")).click();
    driver.findElement(By.id("create")).click();
    for (int second = 0;; second++) {
    	if (second >= 60) fail("timeout");
    	try { if (isElementPresent(By.cssSelector("h1"))) break; } catch (Exception e) {}
    	Thread.sleep(1000);
    }
    
    assertEquals("Modify User Request", driver.findElement(By.cssSelector("h1")).getText());
    driver.findElement(By.id("modify")).click();
    driver.findElement(By.id("modify")).click();
    for (int second = 0;; second++) {
    	if (second >= 60) fail("timeout");
    	try { if (isElementPresent(By.cssSelector("h1"))) break; } catch (Exception e) {}
    	Thread.sleep(1000);
    }
    
    assertEquals("Privacy Restrictions", driver.findElement(By.cssSelector("h1")).getText());
    driver.findElement(By.id("privacy")).click();
    driver.findElement(By.id("privacy")).click();
    for (int second = 0;; second++) {
    	if (second >= 60) fail("timeout");
    	try { if (isElementPresent(By.cssSelector("h1"))) break; } catch (Exception e) {}
    	Thread.sleep(1000);
    }

    assertEquals("Station Maintenance", driver.findElement(By.cssSelector("h1")).getText());
    driver.findElement(By.id("(//button[@onclick='menuDropdown(this.id)'])[3]")).click();
    driver.findElement(By.linkText("Search/Modify")).click();
    assertEquals("Station Maintenance", driver.findElement(By.cssSelector("h1")).getText());
    driver.findElement(By.id("(//button[@onclick='menuDropdown(this.id)'])[3]")).click();
    driver.findElement(By.id("(//a[contains(text(),'Diagnosis Code Lookup')])[2]")).click();
    assertEquals("Diagnosis Code Lookup", driver.findElement(By.cssSelector("h1")).getText());
    driver.findElement(By.id("(//button[@onclick='menuDropdown(this.id)'])[3]")).click();
    driver.findElement(By.id("(//a[contains(text(),'Medical Code Lookup')])[2]")).click();
    assertEquals("Medical Code Lookup", driver.findElement(By.cssSelector("h1")).getText());
    driver.findElement(By.id("(//button[@onclick='menuDropdown(this.id)'])[3]")).click();
    
    System.out.println("Tools: End testTools()"); 
  }

  @After
  public void tearDown() throws Exception {
	System.out.println("Tools: Begin tearDown()");  
	 
    driver.quit();
    String verificationErrorString = verificationErrors.toString();
    if (!"".equals(verificationErrorString)) {
      fail(verificationErrorString);
    }
    
    System.out.println("Tools: End tearDown()");
  }

  private boolean isElementPresent(By by) {
    try {
      driver.findElement(by);
      return true;
    } catch (NoSuchElementException e) {
      return false;
    }
  }

  private boolean isAlertPresent() {
    try {
      driver.switchTo().alert();
      return true;
    } catch (NoAlertPresentException e) {
      return false;
    }
  }

  private String closeAlertAndGetItsText() {
    try {
      Alert alert = driver.switchTo().alert();
      String alertText = alert.getText();
      if (acceptNextAlert) {
        alert.accept();
      } else {
        alert.dismiss();
      }
      return alertText;
    } finally {
      acceptNextAlert = true;
    }
  }
}
