package testing;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.io.File;
import java.util.concurrent.TimeUnit;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.support.ui.Select;

public class TestTest {
  private WebDriver driver;
  private String baseUrl;
  private boolean acceptNextAlert = true;
  private StringBuffer verificationErrors = new StringBuffer();
  
  public static void main(String args[]) {
		JUnitCore junit = new JUnitCore();
		junit.addListener(new TextListener(System.out));
		Result result = junit.run(TestTest.class); // Replace "SampleTest" with the name of your class
		if (result.getFailureCount() > 0) {
		    System.out.println("Test failed.\n" + result);
		    System.exit(1);
		} else {
		    System.out.println("Test finished successfully.");
		    System.exit(0);
		}
  }

  @Before
  public void setUp() throws Exception {
	System.out.println("TestTest: Begin setUp()");
	  
	File file=new File("drivers/IEDriverServer.exe");
	System.setProperty("webdriver.ie.driver",file.getAbsolutePath());
	  
    driver = new InternetExplorerDriver();
    baseUrl = "http://localhost:4200/";
    driver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);
    
    System.out.println("TestTest: End setUp()");
  }

  @Test
  public void testAgedClaims() throws Exception {
	System.out.println("TestTest: Begin testAgedClaims()");
	
    driver.get(baseUrl + "/agedClaims");
    for (int second = 0;; second++) {
      if (second >= 60)
        fail("timeout");
      try {
        if (isElementPresent(By.xpath("(//select[@name='example_length'])[2]")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }
    
    System.out.println("TestTest: End testAgedClaims()");
  }

  @After
  public void tearDown() throws Exception {
	System.out.println("TestTest: Begin tearDown()");
	
    driver.quit();
    String verificationErrorString = verificationErrors.toString();
    if (!"".equals(verificationErrorString)) {
      System.out.println(verificationErrorString);
      fail(verificationErrorString);
    }
    
    System.out.println("TestTest: End tearDown()");
  }

  private boolean isElementPresent(By by) {
    try {
      driver.findElement(by);
      return true;
    } catch (NoSuchElementException e) {
      return false;
    }
  }

  private boolean isAlertPresent() {
    try {
      driver.switchTo().alert();
      return true;
    } catch (NoAlertPresentException e) {
      return false;
    }
  }

  private String closeAlertAndGetItsText() {
    try {
      Alert alert = driver.switchTo().alert();
      String alertText = alert.getText();
      if (acceptNextAlert) {
        alert.accept();
      } else {
        alert.dismiss();
      }
      return alertText;
    } finally {
      acceptNextAlert = true;
    }
  }
}
