package testing;

import static org.junit.Assert.*;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.support.ui.Select;

/**
 * @author DNS   PEREZF
 *
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class StationMaintenanceAddZipCodeTest_SaveCancelButtons {

	private WebDriver driver;
	private String baseUrl;
	private String searchStationPageUrl;
	
	public static void main(String args[]) {
		JUnitCore junit = new JUnitCore();
		junit.addListener(new TextListener(System.out));
		Result result = junit.run(StationMaintenanceAddZipCodeTest_SaveCancelButtons.class); // Replace "SampleTest" with the name of your class
		if (result.getFailureCount() > 0) {
		    System.out.println("Test failed.\n" + result);
		    System.exit(1);
		} else {
		    System.out.println("Test finished successfully.");
		    System.exit(0);
		}
	}

	/**
	 * @throws java.lang.Exception
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: Begin setUpBeforeClass()");
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: End setUpBeforeClass()");
	}

	/**
	 * @throws java.lang.Exception
	 */
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: Begin tearDownAfterClass()");
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: End tearDownAfterClass()");
	}

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: Begin setUp()");
		
		File file = new File("drivers/IEDriverServer.exe");
		System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
		driver = new InternetExplorerDriver();
		
		// baseUrl = "http://SERVER:PORT/";
		baseUrl = "http://localhost:PORT/";
		driver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);

		goToLoginPageAndClickLoginButton();
		Thread.sleep(5000);
		clickSetActiveButton();
		
		// Go to the Search Station Page.
		searchStationPageUrl = baseUrl + "searchStation";
		driver.get(searchStationPageUrl);
		Thread.sleep(5000);
		
		// Verify that it is the Search Station Page.
		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		assertEquals("Incorrect Page Title for Search Station Page!", 
				"Station Maintenance  |  Search Stations", pageTitleElement.getText());
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: Verified we are in the Search Station Page!");
		
		// Get access to the Modify button of interest...
		WebElement dataTableElement = driver.findElement(By.id("datatable"));
		assertNotNull(dataTableElement);
		WebElement modifyTdElement = dataTableElement.findElement(By.id("edit2"));
		assertNotNull(modifyTdElement);
		WebElement modifyButtonElement = modifyTdElement.findElement(By.tagName("button"));
		assertNotNull(modifyButtonElement);
		
		// Click on the Modify Button
		modifyButtonElement.click();
		// modifyButtonElement.sendKeys(Keys.ENTER);
		Thread.sleep(5000);
		
		// Verify that we are now in the "Station Maintenance | Edit" Page.
		pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		assertEquals("Incorrect Page Title for Station Maintenance Edit Page!", 
				"Station Maintenance  |  Edit", pageTitleElement.getText());
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: Verified we are in the Station Maintenance Edit Page!");
		
		// Click on the ZIP Codes Tab Element
		WebElement zipCodeTabElement = driver.findElement(By.id("tab2"));
		zipCodeTabElement.click();
		Thread.sleep(2000);
		WebElement addZipCodeElement = driver.findElement(By.id("addZipCode"));
		addZipCodeElement.click();
		Thread.sleep(5000);
		
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: End setUp()");
	}
	
	private void clickSetActiveButton() throws Exception {
		WebElement setActiveButton = driver.findElement(By.id("setActive"));
		assertNotNull(setActiveButton);
		setActiveButton.click();
		// setActiveButton.submit(); // Not inside of a "form" element.
		setActiveButton.sendKeys(Keys.ENTER);
		Thread.sleep(3000);
	}

	private void goToLoginPageAndClickLoginButton() throws Exception {
		driver.get(baseUrl);
		WebElement loginButton = driver.findElement(By.id("loginAdminBtn"));
		assertNotNull(loginButton);
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: Login Button exists!");
		
		// Select the ADMIN Role.
		Select roleSelectBox = new Select(driver.findElement(By.id("selectRole2")));
		assertNotNull(roleSelectBox);
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: Role Select Box exists!");
		roleSelectBox.selectByVisibleText("ADMIN");
		Thread.sleep(2000);
		
		// Click the Login Button. Had to do this as advised by Joshua Lone
		// to get this to work to forward to next page.
		loginButton.click();
		loginButton.submit();
		loginButton.sendKeys(Keys.ENTER);
	}	
	
	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: Begin tearDown()");
		
		Thread.sleep(5000);
		driver.close();
		driver.quit();
		Thread.sleep(5000);
		System.out.println("End Executing 'tearDown' method");
		
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: End tearDown()");
	}
	
	@Test
	public void test_1_Verify_StationMaintenanceAddZipCodePage_Appears() throws Exception {
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: Begin test_1_Verify_StationMaintenanceAddZipCodePage_Appears()");

		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		
		assertEquals("Incorrect Page Title for Station Maintenance Add ZIP Code Page!", 
				"Station Maintenance  |  Add ZIP Code", pageTitleElement.getText());
		
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: End test_1_Verify_StationMaintenanceAddZipCodePage_Appears()");
	}	
	
	@Test
	public void test_2_Verify_StationMaintenanceCancelButtonExists() throws Exception {
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: Begin test_2_Verify_StationMaintenanceCancelButtonExists()");

		WebElement cancelButtonElement = driver.findElement(By.id("cancel"));
		assertNotNull(cancelButtonElement);
		
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: End test_2_Verify_StationMaintenanceCancelButtonExists()");
	}	
	
	@Test
	public void test_3_Verify_CancelButtonClick_ForwardsBackTo_StationMaintenanceEditPage() throws Exception {
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: Begin test_3_Verify_CancelButtonClick_ForwardsBackTo_StationMaintenanceEditPage()");

		WebElement cancelButtonElement = driver.findElement(By.id("cancel"));
		assertNotNull(cancelButtonElement);
		
		cancelButtonElement.click();
		Thread.sleep(3000);
		
		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		assertEquals("Incorrect Page Title for Station Maintenance Edit Page!", 
				"Station Maintenance  |  Edit", pageTitleElement.getText());
		
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: End test_3_Verify_CancelButtonClick_ForwardsBackTo_StationMaintenanceEditPage()");
	}	
	
	@Test
	public void test_4_Verify_StationMaintenanceSaveButtonExists_AndIsDisabledInitially() throws Exception {
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: Begin test_4_Verify_StationMaintenanceSaveButtonExists_AndIsDisabledInitially()");

		WebElement saveButtonElement = driver.findElement(By.id("save"));
		assertNotNull(saveButtonElement);
		
		String disabledAttributeStr = saveButtonElement.getAttribute("disabled");
		assertNotNull(disabledAttributeStr);
		System.out.println("   disabledAttributeStr = " + disabledAttributeStr);
		assertEquals("The disabled attribute value on the Save button should be an empty string", "true", disabledAttributeStr);
		
		String classAttributeStr = saveButtonElement.getAttribute("class");
		assertNotNull(classAttributeStr);
		System.out.println("   classAttributeStr = " + classAttributeStr);
		assertTrue("The class attribute value on the Save button should contain the disabled string", classAttributeStr.contains(" disabled"));
		
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: End test_4_Verify_StationMaintenanceSaveButtonExists_AndIsDisabledInitially()");
	}	
	
	@Test
	public void test_5_Verify_StationMaintenanceSaveButtonBecomesEnabledWhenNonExistentZipCodeTextValueEntered() throws Exception {
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: Begin test_5_Verify_StationMaintenanceSaveButtonBecomesEnabledWhenNonExistentZipCodeTextValueEntered()");

		WebElement zipCodeTextElement = driver.findElement(By.id("zipCode"));
		assertNotNull(zipCodeTextElement);
		
		zipCodeTextElement.sendKeys("ABC");
		
		WebElement saveButtonElement = driver.findElement(By.id("save"));
		assertNotNull(saveButtonElement);
		
		String disabledAttributeStr = saveButtonElement.getAttribute("disabled");
		assertNull(disabledAttributeStr);
		System.out.println("   disabledAttributeStr = " + disabledAttributeStr);
		
		String classAttributeStr = saveButtonElement.getAttribute("class");
		assertNotNull(classAttributeStr);
		System.out.println("   classAttributeStr = " + classAttributeStr);
		assertFalse("The class attribute value on the Save button should NOT contain the disabled string", classAttributeStr.contains("disabled"));
		
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: End test_5_Verify_StationMaintenanceSaveButtonBecomesEnabledWhenNonExistentZipCodeTextValueEntered()");
	}
	
	@Test
	public void test_6_Verify_StationMaintenanceSaveButtonBecomesDisabledWhenExistentZipCodeTextValueEntered() throws Exception {
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: Begin test_6_Verify_StationMaintenanceSaveButtonBecomesDisabledWhenExistentZipCodeTextValueEntered()");

		WebElement zipCodeTextElement = driver.findElement(By.id("zipCode"));
		assertNotNull(zipCodeTextElement);
		
		// The below was a ZIP Code that was already added for the Station.
		zipCodeTextElement.sendKeys("12345");
		
		WebElement saveButtonElement = driver.findElement(By.id("save"));
		assertNotNull(saveButtonElement);
		
		Thread.sleep(3000);
		
		String disabledAttributeStr = saveButtonElement.getAttribute("disabled");
		System.out.println("   disabledAttributeStr = " + disabledAttributeStr);
		assertNotNull(disabledAttributeStr);
		assertEquals("The disabled attribute value on the Save button should be an empty string", "true", disabledAttributeStr);
		
		String classAttributeStr = saveButtonElement.getAttribute("class");
		assertNotNull(classAttributeStr);
		System.out.println("   classAttributeStr = " + classAttributeStr);
		assertTrue("The class attribute value on the Save button should contain the disabled string", classAttributeStr.contains(" disabled"));
		
		WebElement zipCodeAlreadyExistsErrorMessageElement = driver.findElement(By.id("zipCodeAlreadyExistsErrorMessage"));
		System.out.println("   zipCodeAlreadyExistsErrorMessageElement = " + zipCodeAlreadyExistsErrorMessageElement);
		System.out.println("   zipCodeAlreadyExistsErrorMessageElement != null: " + zipCodeAlreadyExistsErrorMessageElement != null);
		
		assertNotNull("Should have the ZIP Code Already Exists Text!", zipCodeAlreadyExistsErrorMessageElement);
		
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: End test_6_Verify_StationMaintenanceSaveButtonBecomesDisabledWhenExistentZipCodeTextValueEntered()");
	}		
	
	@Test
	public void test_7_Verify_SuccessfulZipCodeSave() throws Exception {
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: Begin test_7_Verify_SuccessfulZipCodeSave)");
		
		WebElement saveButtonElement = driver.findElement(By.id("save"));
		assertNotNull(saveButtonElement);
		
		WebElement zipCodeTextElement = driver.findElement(By.id("zipCode"));
		assertNotNull(zipCodeTextElement);
		
		// Find a Zip Code Number that is available to be added to the Station.
		long zipCodeNumber = 0L;
		for (zipCodeNumber = 9999999999L; zipCodeNumber > 0; zipCodeNumber--) {
			System.out.println("   zipCodeNumber = " + zipCodeNumber);
			
			zipCodeTextElement.sendKeys(Long.toString(zipCodeNumber));
			Thread.sleep(2000);
			String disabledAttributeStr = saveButtonElement.getAttribute("disabled");
			System.out.println("   disabledAttributeStr = " + disabledAttributeStr);
			
			if (disabledAttributeStr == null) {
				break;
			} else {
				// The only thing that worked was "zipCodeTextElement.sendKeys(Keys.BACK_SPACE)"
				// zipCodeTextElement.sendKeys(Keys.DELETE);
				// zipCodeTextElement.clear();
				for (int i = 0; i < 10; i++) {
					zipCodeTextElement.sendKeys(Keys.BACK_SPACE);
				}
				Thread.sleep(2000);
			}
		}
		
		System.out.println("   zipCodeNumber = " + zipCodeNumber);
		
		WebElement fipsCountyCodeTextElement = driver.findElement(By.id("fipsCountyCode"));
		assertNotNull(fipsCountyCodeTextElement);
		fipsCountyCodeTextElement.sendKeys("SEM");
		Thread.sleep(1000);
		
		WebElement urbanIndicatorTextElement = driver.findElement(By.id("urbanIndicator"));
		assertNotNull(urbanIndicatorTextElement);
		urbanIndicatorTextElement.sendKeys("MIAMI");
		Thread.sleep(1000);
		
		WebElement fipsStateCodeTextElement = driver.findElement(By.id("fipsStateCode"));
		assertNotNull(fipsStateCodeTextElement);
		fipsStateCodeTextElement.sendKeys("FL");
		Thread.sleep(1000);
		
		saveButtonElement.click();
		Thread.sleep(3000);
		
		// Make sure you are back at the "Station Maintenance  |  Edit" Page.
		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		assertEquals("Incorrect Page Title for Station Maintenance Edit Page!", 
				"Station Maintenance  |  Edit", pageTitleElement.getText());
		
		WebElement addZipCodeSuccessMessageElement = driver.findElement(By.id("addZipCodeSuccessMessage"));
		assertNotNull(addZipCodeSuccessMessageElement);
		
		System.out.println("StationMaintenanceAddZipCodeTest_SaveCancelButtons: End test_7_Verify_SuccessfulZipCodeSave()");
	}	
	
	// Franklin Perez (10/24/2017): Do not know how to test for failure of ZIP Code Addition due to not knowing
	//   how to excite system to return back failure of Add ZIP Code.
}
