package testing;

import static org.junit.Assert.*;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.support.ui.Select;

/**
 * @author DNS   PEREZF
 *
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class StationMaintenanceAddZipCodeTest {

	private WebDriver driver;
	private String baseUrl;
	private String stationMaintenanceAddZipCodePageUrl;
	
	public static void main(String args[]) {
		JUnitCore junit = new JUnitCore();
		junit.addListener(new TextListener(System.out));
		Result result = junit.run(StationMaintenanceAddZipCodeTest.class); // Replace "SampleTest" with the name of your class
		if (result.getFailureCount() > 0) {
		    System.out.println("Test failed.\n" + result);
		    System.exit(1);
		} else {
		    System.out.println("Test finished successfully.");
		    System.exit(0);
		}
	}

	/**
	 * @throws java.lang.Exception
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("StationMaintenanceAddZipCodeTest: Begin setUpBeforeClass()");
		System.out.println("StationMaintenanceAddZipCodeTest: End setUpBeforeClass()");
	}

	/**
	 * @throws java.lang.Exception
	 */
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
		System.out.println("StationMaintenanceAddZipCodeTest: Begin tearDownAfterClass()");
		System.out.println("StationMaintenanceAddZipCodeTest: End tearDownAfterClass()");
	}

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
		System.out.println("StationMaintenanceAddZipCodeTest: Begin setUp()");
		
		File file = new File("drivers/IEDriverServer.exe");
		System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
		driver = new InternetExplorerDriver();
		
		// baseUrl = "http://SERVER:PORT/";
		baseUrl = "http://localhost:PORT/";
		driver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);

		goToLoginPageAndClickLoginButton();
		Thread.sleep(5000);
		clickSetActiveButton();

		stationMaintenanceAddZipCodePageUrl = baseUrl + "addZipCode";
		driver.get(stationMaintenanceAddZipCodePageUrl);
		Thread.sleep(3000);
		
		System.out.println("StationMaintenanceAddZipCodeTest: End setUp()");
	}
	
	private void clickSetActiveButton() throws Exception {
		WebElement setActiveButton = driver.findElement(By.id("setActive"));
		assertNotNull(setActiveButton);
		setActiveButton.click();
		// setActiveButton.submit(); // Not inside of a "form" element.
		setActiveButton.sendKeys(Keys.ENTER);
		Thread.sleep(3000);
	}

	private void goToLoginPageAndClickLoginButton() throws Exception {
		driver.get(baseUrl);
		WebElement loginButton = driver.findElement(By.id("loginAdminBtn"));
		assertNotNull(loginButton);
		System.out.println("StationMaintenanceAddZipCodeTest: Login Button exists!");
		
		// Select the ADMIN Role.
		Select roleSelectBox = new Select(driver.findElement(By.id("selectRole2")));
		assertNotNull(roleSelectBox);
		System.out.println("StationMaintenanceAddZipCodeTest: Role Select Box exists!");
		roleSelectBox.selectByVisibleText("ADMIN");
		Thread.sleep(2000);
		
		// Click the Login Button. Had to do this as advised by Joshua Lone
		// to get this to work to forward to next page.
		loginButton.click();
		loginButton.submit();
		loginButton.sendKeys(Keys.ENTER);
	}	
	
	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
		System.out.println("StationMaintenanceAddZipCodeTest: Begin tearDown()");
		
		Thread.sleep(5000);
		driver.close();
		driver.quit();
		Thread.sleep(5000);
		System.out.println("End Executing 'tearDown' method");
		
		System.out.println("StationMaintenanceAddZipCodeTest: End tearDown()");
	}
	
	@Test
	public void test_1_Verify_StationMaintenanceAddZipCodePage_Appears() throws Exception {
		System.out.println("StationMaintenanceAddZipCodeTest: Begin test_1_Verify_StationMaintenanceAddZipCodePage_Appears()");

		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		
		assertEquals("Incorrect Page Title for Station Maintenance Add ZIP Code Page!", 
				"Station Maintenance  |  Add ZIP Code", pageTitleElement.getText());
		
		System.out.println("StationMaintenanceAddZipCodeTest: End test_1_Verify_StationMaintenanceAddZipCodePage_Appears()");
	}	
	
	@Test
	public void test_2_Verify_StationMaintenanceAddZipCodeTestFieldExistsAndIsMandatory() throws Exception {
		System.out.println("StationMaintenanceAddZipCodeTest: Begin test_2_Verify_StationMaintenanceAddZipCodeTestFieldExistsAndIsMandatory()");

		WebElement zipCodeTextElement = driver.findElement(By.id("zipCode"));
		assertNotNull(zipCodeTextElement);
		
		String requiredAttributeStr = zipCodeTextElement.getAttribute("required");
		assertNotNull(requiredAttributeStr);
		
		String zipCodeTextElementTagName = zipCodeTextElement.getTagName();
		assertNotNull(zipCodeTextElementTagName);
		assertEquals("Incorrect Tag Name for the Zip Code Text Element!", 
				"input", zipCodeTextElementTagName);
		
		String zipCodeTextElementTypeAttributeStr = zipCodeTextElement.getAttribute("type");
		assertNotNull(zipCodeTextElementTypeAttributeStr);
		assertEquals("Incorrect Type for the Zip Code Text Element!", 
				"text", zipCodeTextElementTypeAttributeStr);		
		
		System.out.println("StationMaintenanceAddZipCodeTest: End test_2_Verify_StationMaintenanceAddZipCodeTestFieldExistsAndIsMandatory()");
	}
	
	@Test
	public void test_3_Verify_ActiveIndicatorExistsAndIsMandatoryWithInitialYesValue() throws Exception {
		System.out.println("StationMaintenanceAddZipCodeTest: Begin test_3_Verify_ActiveIndicatorExistsAndIsMandatoryWithInitialYesValue()");
		
		WebElement activeOptionsYesRadioButtonElement = driver.findElement(By.id("activeOptionsYes"));
		assertNotNull(activeOptionsYesRadioButtonElement);
		
		String activeOptionsYesButtonElementType = activeOptionsYesRadioButtonElement.getAttribute("type");
		assertNotNull(activeOptionsYesButtonElementType);
		assertEquals("Incorrect Type for Active Options Yes Radio Button!", "radio", activeOptionsYesButtonElementType);
		
		String activeOptionsYesRadioButtonElementValue = activeOptionsYesRadioButtonElement.getAttribute("value");
		assertNotNull(activeOptionsYesRadioButtonElementValue);
		assertEquals("Incorrect Value for Active Options Yes Radio Button!", "Yes", activeOptionsYesRadioButtonElementValue);
		
		WebElement activeOptionsNoRadioButtonElement = driver.findElement(By.id("activeOptionsNo"));
		assertNotNull(activeOptionsNoRadioButtonElement);
		
		String activeOptionsNoButtonElementType = activeOptionsNoRadioButtonElement.getAttribute("type");
		assertNotNull(activeOptionsNoButtonElementType);
		assertEquals("Incorrect Type for Active Options No Radio Button!", "radio", activeOptionsNoButtonElementType);	
		
		String activeOptionsNoRadioButtonElementValue = activeOptionsNoRadioButtonElement.getAttribute("value");
		assertNotNull(activeOptionsNoRadioButtonElementValue);
		assertEquals("Incorrect Value for Active Options No Radio Button!", "No", activeOptionsNoRadioButtonElementValue);
		
		// Verify initial value of Active Indicator is Yes
		String activeOptionsYesButtonElementNgReflectModelValue  = activeOptionsYesRadioButtonElement.getAttribute("ng-reflect-model");
		assertNotNull(activeOptionsYesButtonElementNgReflectModelValue);
		assertEquals("Incorrect ng-reflect-model Value for Active Options Yes Radio Button!", "Yes", activeOptionsYesButtonElementNgReflectModelValue);
		String activeOptionsNoButtonElementNgReflectModelValue  = activeOptionsNoRadioButtonElement.getAttribute("ng-reflect-model");
		assertNotNull(activeOptionsNoButtonElementNgReflectModelValue);
		assertEquals("Incorrect ng-reflect-model Value for Active Options No Radio Button!", "Yes", activeOptionsNoButtonElementNgReflectModelValue);
		
		System.out.println("StationMaintenanceAddZipCodeTest: End test_3_Verify_ActiveIndicatorExistsAndIsMandatoryWithInitialYesValue()");
	}
	
	@Test
	public void test_4_VerifyActiveIndicatorValueChangesToNoWhenNoRadioButtonPressed() throws Exception {
		System.out.println("StationMaintenanceAddZipCodeTest: Begin test_4_VerifyActiveIndicatorValueChangesToNoWhenNoRadioButtonPressed()");
		
		WebElement activeOptionsYesRadioButtonElement = driver.findElement(By.id("activeOptionsYes"));
		assertNotNull(activeOptionsYesRadioButtonElement);
		
		WebElement activeOptionsNoRadioButtonElement = driver.findElement(By.id("activeOptionsNo"));
		assertNotNull(activeOptionsNoRadioButtonElement);
		
		// Click the Active Indicators No Button
		activeOptionsNoRadioButtonElement.click();
		activeOptionsNoRadioButtonElement.sendKeys(Keys.ENTER);
		Thread.sleep(2000);
		
		// Verify initial value of Active Indicator is No
		String activeOptionsYesButtonElementNgReflectModelValue  = activeOptionsYesRadioButtonElement.getAttribute("ng-reflect-model");
		assertNotNull(activeOptionsYesButtonElementNgReflectModelValue);
		assertEquals("Incorrect ng-reflect-model Value for Active Options Yes Radio Button!", "No", activeOptionsYesButtonElementNgReflectModelValue);
		String activeOptionsNoButtonElementNgReflectModelValue  = activeOptionsNoRadioButtonElement.getAttribute("ng-reflect-model");
		assertNotNull(activeOptionsNoButtonElementNgReflectModelValue);
		assertEquals("Incorrect ng-reflect-model Value for Active Options No Radio Button!", "No", activeOptionsNoButtonElementNgReflectModelValue);
		
		System.out.println("StationMaintenanceAddZipCodeTest: End test_4_VerifyActiveIndicatorValueChangesToNoWhenNoRadioButtonPressed()");
	}
	
	@Test
	public void test_5_VerifyFipsCountyCodeTextFieldExists() {
		System.out.println("StationMaintenanceAddZipCodeTest: Begin test_5_VerifyFipsCountyCodeTextFieldExists()");

		WebElement fipsCountyCodeTextElement = driver.findElement(By.id("fipsCountyCode"));
		assertNotNull(fipsCountyCodeTextElement);
		
		String fipsCountyCodeTextElementTagName = fipsCountyCodeTextElement.getTagName();
		assertNotNull(fipsCountyCodeTextElementTagName);
		assertEquals("Incorrect Tag Name for the FIPS County Code Text Element!", 
				"input", fipsCountyCodeTextElementTagName);
		
		String fipsCountyCodeTextElementTypeAttributeStr = fipsCountyCodeTextElement.getAttribute("type");
		assertNotNull(fipsCountyCodeTextElementTypeAttributeStr);
		assertEquals("Incorrect Type for the FIPS County Code Text Element!", 
				"text", fipsCountyCodeTextElementTypeAttributeStr);		
		
		System.out.println("StationMaintenanceAddZipCodeTest: End test_5_VerifyFipsCountyCodeTextFieldExists()");		
	}
	
	@Test
	public void test_6_VerifyFipsStateCodeTextFieldExists() {
		System.out.println("StationMaintenanceAddZipCodeTest: Begin test_6_VerifyFipsStateCodeTextFieldExists()");

		WebElement fipsStateCodeTextElement = driver.findElement(By.id("fipsStateCode"));
		assertNotNull(fipsStateCodeTextElement);
		
		String fipsStateCodeTextElementTagName = fipsStateCodeTextElement.getTagName();
		assertNotNull(fipsStateCodeTextElementTagName);
		assertEquals("Incorrect Tag Name for the FIPS State Code Text Element!", 
				"input", fipsStateCodeTextElementTagName);
		
		String fipsStateCodeTextElementTypeAttributeStr = fipsStateCodeTextElement.getAttribute("type");
		assertNotNull(fipsStateCodeTextElementTypeAttributeStr);
		assertEquals("Incorrect Type for the FIPS State Code Text Element!", 
				"text", fipsStateCodeTextElementTypeAttributeStr);		
		
		System.out.println("StationMaintenanceAddZipCodeTest: End test_6_VerifyFipsStateCodeTextFieldExists()");		
	}
	
	@Test
	public void test_7_VerifyUrbanIndicatorTextFieldExists() {
		System.out.println("StationMaintenanceAddZipCodeTest: Begin test_7_VerifyUrbanIndicatorTextFieldExists()");

		WebElement urbanIndicatorTextElement = driver.findElement(By.id("urbanIndicator"));
		assertNotNull(urbanIndicatorTextElement);
		
		String urbanIndicatorTextElementTagName = urbanIndicatorTextElement.getTagName();
		assertNotNull(urbanIndicatorTextElementTagName);
		assertEquals("Incorrect Tag Name for the Urban Indicator Text Element!", 
				"input", urbanIndicatorTextElementTagName);
		
		String urbanIndicatorTextElementTypeAttributeStr = urbanIndicatorTextElement.getAttribute("type");
		assertNotNull(urbanIndicatorTextElementTypeAttributeStr);
		assertEquals("Incorrect Type for the Urban Indictor Text Element!", 
				"text", urbanIndicatorTextElementTypeAttributeStr);		
		
		System.out.println("StationMaintenanceAddZipCodeTest: End test_7_VerifyUrbanIndicatorTextFieldExists()");		
	}
}
