package testing;

import static org.junit.Assert.*;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.support.ui.Select;

/**
 * @author DNS   PEREZF
 *
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class StationMaintenanceAddContactInfoTest {

	private WebDriver driver;
	private String baseUrl;
	private String searchStationPageUrl;
	
	public static void main(String args[]) {
		JUnitCore junit = new JUnitCore();
		junit.addListener(new TextListener(System.out));
		Result result = junit.run(StationMaintenanceAddContactInfoTest.class); // Replace "SampleTest" with the name of your class
		if (result.getFailureCount() > 0) {
		    System.out.println("Test failed.\n" + result);
		    System.exit(1);
		} else {
		    System.out.println("Test finished successfully.");
		    System.exit(0);
		}
	}

	/**
	 * @throws java.lang.Exception
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin setUpBeforeClass()");
		System.out.println("StationMaintenanceAddContactInfoTest: End setUpBeforeClass()");
	}

	/**
	 * @throws java.lang.Exception
	 */
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin tearDownAfterClass()");
		System.out.println("StationMaintenanceAddContactInfoTest: End tearDownAfterClass()");
	}

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin setUp()");
		
		File file = new File("drivers/IEDriverServer.exe");
		System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
		driver = new InternetExplorerDriver();
		
		// baseUrl = "http://SERVER:PORT/";
		baseUrl = "http://localhost:3000/";
		driver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);

		goToLoginPageAndClickLoginButton();
		Thread.sleep(5000);
		clickSetActiveButton();
		
		// Go to the Search Station Page.
		searchStationPageUrl = baseUrl + "searchStation";
		driver.get(searchStationPageUrl);
		Thread.sleep(5000);
		
		// Verify that it is the Search Station Page.
		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		assertEquals("Incorrect Page Title for Search Station Page!", 
				"Station Maintenance  |  Search Stations", pageTitleElement.getText());
		System.out.println("StationMaintenanceAddContactInfoTest: Verified we are in the Search Station Page!");
		
		// Get access to the Modify button of interest...
		WebElement dataTableElement = driver.findElement(By.id("datatable"));
		assertNotNull(dataTableElement);
		WebElement modifyTdElement = dataTableElement.findElement(By.id("edit2"));
		assertNotNull(modifyTdElement);
		WebElement modifyButtonElement = modifyTdElement.findElement(By.tagName("button"));
		assertNotNull(modifyButtonElement);
		
		// Click on the Modify Button
		modifyButtonElement.click();
		// modifyButtonElement.sendKeys(Keys.ENTER);
		Thread.sleep(5000);
		
		// Verify that we are now in the "Station Maintenance | Edit" Page.
		pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		assertEquals("Incorrect Page Title for Station Maintenance Edit Page!", 
				"Station Maintenance  |  Edit", pageTitleElement.getText());
		System.out.println("StationMaintenanceAddContactInfoTest: Verified we are in the Station Maintenance Edit Page!");
		
		// Click on the Contact Info Tab Element
		WebElement contactInfoTabElement = driver.findElement(By.id("tab1"));
		contactInfoTabElement.click();
		Thread.sleep(2000);
		WebElement addContactInfoElement = driver.findElement(By.id("addContactInfo"));
		addContactInfoElement.click();
		Thread.sleep(5000);
		
		System.out.println("StationMaintenanceAddContactInfoTest: End setUp()");
	}
	
	private void clickSetActiveButton() throws Exception {
		WebElement setActiveButton = driver.findElement(By.id("setActive"));
		assertNotNull(setActiveButton);
		setActiveButton.click();
		// setActiveButton.submit(); // Not inside of a "form" element.
		setActiveButton.sendKeys(Keys.ENTER);
		Thread.sleep(3000);
	}

	private void goToLoginPageAndClickLoginButton() throws Exception {
		driver.get(baseUrl);
		WebElement loginButton = driver.findElement(By.id("loginAdminBtn"));
		assertNotNull(loginButton);
		System.out.println("StationMaintenanceAddContactInfoTest: Login Button exists!");
		
		// Select the ADMIN Role.
		Select roleSelectBox = new Select(driver.findElement(By.id("selectRole2")));
		assertNotNull(roleSelectBox);
		System.out.println("StationMaintenanceAddContactInfoTest: Role Select Box exists!");
		roleSelectBox.selectByVisibleText("ADMIN");
		Thread.sleep(2000);
		
		// Click the Login Button. Had to do this as advised by Joshua Lone
		// to get this to work to forward to next page.
		loginButton.click();
		loginButton.submit();
		loginButton.sendKeys(Keys.ENTER);
	}	
	
	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin tearDown()");
		
		Thread.sleep(5000);
		driver.close();
		driver.quit();
		Thread.sleep(5000);
		System.out.println("End Executing 'tearDown' method");
		
		System.out.println("StationMaintenanceAddContactInfoTest: End tearDown()");
	}
	
	@Test
	public void test_1_Verify_StationMaintenanceAddContactInfoPage_Appears() throws Exception {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin test_1_Verify_StationMaintenanceAddContactInfoPage_Appears()");

		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		
		assertEquals("Incorrect Page Title for Station Maintenance Add Contact Info Page!", 
				"Station Maintenance  |  Add Contact Info", pageTitleElement.getText());
		
		System.out.println("StationMaintenanceAddContactInfoTest: End test_1_Verify_StationMaintenanceAddContactInfoPage_Appears()");
	}	
	
	@Test
	public void test_2_VerifyContactNameTextFieldExists() {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin test_2_VerifyContactNameTextFieldExists()");

		WebElement contactNameTextElement = driver.findElement(By.id("contactName"));
		assertNotNull(contactNameTextElement);
		
		String contactNameTextElementTagName = contactNameTextElement.getTagName();
		assertNotNull(contactNameTextElementTagName);
		assertEquals("Incorrect Tag Name for the Contact Name Text Element!", 
				"input", contactNameTextElementTagName);
		
		String contactNameTextElementTypeAttributeStr = contactNameTextElement.getAttribute("type");
		assertNotNull(contactNameTextElementTypeAttributeStr);
		assertEquals("Incorrect Type for the Contact Name Text Element!", 
				"text", contactNameTextElementTypeAttributeStr);		
		
		System.out.println("StationMaintenanceAddContactInfoTest: End test_2_VerifyContactNameTextFieldExists()");		
	}
	
	@Test
	public void test_3_VerifyAddressLineOneTextFieldExists() {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin test_3_VerifyAddressLineOneTextFieldExists()");

		WebElement addressLineOneTextElement = driver.findElement(By.id("addressLineOne"));
		assertNotNull(addressLineOneTextElement);
		
		String addressLineOneTextElementTagName = addressLineOneTextElement.getTagName();
		assertNotNull(addressLineOneTextElementTagName);
		assertEquals("Incorrect Tag Name for the Address Line 1 Text Element!", 
				"input", addressLineOneTextElementTagName);
		
		String addressLineOneTextElementTypeAttributeStr = addressLineOneTextElement.getAttribute("type");
		assertNotNull(addressLineOneTextElementTypeAttributeStr);
		assertEquals("Incorrect Type for the Address Line 1 Text Element!", 
				"text", addressLineOneTextElementTypeAttributeStr);		
		
		System.out.println("StationMaintenanceAddContactInfoTest: End test_3_VerifyAddressLineOneTextFieldExists()");		
	}
	
	@Test
	public void test_4_VerifyAddressLineTwoTextFieldExists() {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin test_4_VerifyAddressLineTwoTextFieldExists()");

		WebElement addressLineTwoTextElement = driver.findElement(By.id("addressLineTwo"));
		assertNotNull(addressLineTwoTextElement);
		
		String addressLineTwoTextElementTagName = addressLineTwoTextElement.getTagName();
		assertNotNull(addressLineTwoTextElementTagName);
		assertEquals("Incorrect Tag Name for the Address Line 2 Text Element!", 
				"input", addressLineTwoTextElementTagName);
		
		String addressLineTwoTextElementTypeAttributeStr = addressLineTwoTextElement.getAttribute("type");
		assertNotNull(addressLineTwoTextElementTypeAttributeStr);
		assertEquals("Incorrect Type for the Address Line 2 Text Element!", 
				"text", addressLineTwoTextElementTypeAttributeStr);		
		
		System.out.println("StationMaintenanceAddContactInfoTest: End test_4_VerifyAddressLineTwoTextFieldExists()");		
	}
	
	@Test
	public void test_5_VerifyCityTextFieldExists() {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin test_5_VerifyCityTextFieldExists()");

		WebElement cityTextElement = driver.findElement(By.id("city"));
		assertNotNull(cityTextElement);
		
		String cityTextElementTagName = cityTextElement.getTagName();
		assertNotNull(cityTextElementTagName);
		assertEquals("Incorrect Tag Name for the City Text Element!", 
				"input", cityTextElementTagName);
		
		String cityTextElementTypeAttributeStr = cityTextElement.getAttribute("type");
		assertNotNull(cityTextElementTypeAttributeStr);
		assertEquals("Incorrect Type for the City Text Element!", 
				"text", cityTextElementTypeAttributeStr);		
		
		System.out.println("StationMaintenanceAddContactInfoTest: End test_5_VerifyCityTextFieldExists()");		
	}
	
	@Test
	public void test_6_VerifyZipTextFieldExists() {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin test_6_VerifyZipTextFieldExists()");

		WebElement zipCodeTextElement = driver.findElement(By.id("zipCode"));
		assertNotNull(zipCodeTextElement);
		
		String zipCodeTextElementTagName = zipCodeTextElement.getTagName();
		assertNotNull(zipCodeTextElementTagName);
		assertEquals("Incorrect Tag Name for the Zip Text Element!", 
				"input", zipCodeTextElementTagName);
		
		String zipCodeTextElementTypeAttributeStr = zipCodeTextElement.getAttribute("type");
		assertNotNull(zipCodeTextElementTypeAttributeStr);
		assertEquals("Incorrect Type for the Zip Text Element!", 
				"text", zipCodeTextElementTypeAttributeStr);		
		
		System.out.println("StationMaintenanceAddContactInfoTest: End test_6_VerifyZipTextFieldExists()");		
	}
	
	@Test
	public void test_7_VerifyEmailTextFieldExists() {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin test_7_VerifyEmailTextFieldExists()");

		WebElement emailTextElement = driver.findElement(By.id("email"));
		assertNotNull(emailTextElement);
		
		String emailTextElementTagName = emailTextElement.getTagName();
		assertNotNull(emailTextElementTagName);
		assertEquals("Incorrect Tag Name for the Email Text Element!", 
				"input", emailTextElementTagName);
		
		String emailTextElementTypeAttributeStr = emailTextElement.getAttribute("type");
		assertNotNull(emailTextElementTypeAttributeStr);
		assertEquals("Incorrect Type for the Zip Text Element!", 
				"text", emailTextElementTypeAttributeStr);		
		
		System.out.println("StationMaintenanceAddContactInfoTest: End test_7_VerifyEmailTextFieldExists()");		
	}
	
	@Test
	public void test_8_VerifyFaxTextFieldExists() {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin test_8_VerifyFaxTextFieldExists()");

		WebElement faxTextElement = driver.findElement(By.id("fax"));
		assertNotNull(faxTextElement);
		
		String faxTextElementTagName = faxTextElement.getTagName();
		assertNotNull(faxTextElementTagName);
		assertEquals("Incorrect Tag Name for the Fax Text Element!", 
				"input", faxTextElementTagName);
		
		String faxTextElementTypeAttributeStr = faxTextElement.getAttribute("type");
		assertNotNull(faxTextElementTypeAttributeStr);
		assertEquals("Incorrect Type for the Fax Text Element!", 
				"text", faxTextElementTypeAttributeStr);		
		
		System.out.println("StationMaintenanceAddContactInfoTest: End test_8_VerifyFaxTextFieldExists()");		
	}
	
	@Test
	public void test_9_VerifyPhoneTextFieldExists() {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin test_9_VerifyPhoneTextFieldExists()");

		WebElement phoneTextElement = driver.findElement(By.id("phone"));
		assertNotNull(phoneTextElement);
		
		String phoneTextElementTagName = phoneTextElement.getTagName();
		assertNotNull(phoneTextElementTagName);
		assertEquals("Incorrect Tag Name for the Phone Text Element!", 
				"input", phoneTextElementTagName);
		
		String phoneTextElementTypeAttributeStr = phoneTextElement.getAttribute("type");
		assertNotNull(phoneTextElementTypeAttributeStr);
		assertEquals("Incorrect Type for the Phone Text Element!", 
				"text", phoneTextElementTypeAttributeStr);		
		
		System.out.println("StationMaintenanceAddContactInfoTest: End test_9_VerifyPhoneTextFieldExists()");		
	}
	
	@Test
	public void test_10_VerifyContactTypeTextFieldExists_And_IsMandatory() throws Exception {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin test_10_VerifyContactTypeTextFieldExists_And_IsMandatory()");

		WebElement contactTypeTextFieldElement = driver.findElement(By.id("contactType"));
		assertNotNull(contactTypeTextFieldElement);
		
		String requiredAttributeStr = contactTypeTextFieldElement.getAttribute("required");
		assertNotNull(requiredAttributeStr);
		
		String contactTypeElementTagName = contactTypeTextFieldElement.getTagName();
		assertNotNull(contactTypeElementTagName);
		assertEquals("Incorrect Tag Name for the Contact Type Text Field Element!", 
				"input", contactTypeElementTagName);
		
		String contactTypeTextElementTypeAttributeStr = contactTypeTextFieldElement.getAttribute("type");
		assertNotNull(contactTypeTextElementTypeAttributeStr);
		assertEquals("Incorrect Type for the Contact Type Text Field Element!", 
				"text", contactTypeTextElementTypeAttributeStr);	
		
		System.out.println("StationMaintenanceAddContactInfoTest: End test_10_VerifyContactTypeTextFieldExists_And_IsMandatory()");
	}
	
	// Franklin Perez (11/6/2017): Contact Type no longer a Select Box.
	/*
	@Test
	public void test_11_VerifyContactTypeSelectField_CanChangeValues() throws Exception {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin test_11_VerifyContactTypeSelectField_CanChangeValues()");
		
		Select contactTypeSelectBox = new Select(driver.findElement(By.id("contactType")));
		assertNotNull(contactTypeSelectBox);
		
		List<WebElement> contactTypeSelectedOptionElements = contactTypeSelectBox.getAllSelectedOptions();
		assertEquals("Contact Type Select Box should have only one selected value!", 1, contactTypeSelectedOptionElements.size());
		assertEquals("Contact Type Inital Value is incorrect!", "OMNH - OUTPATIENT CLINIC/NURSING HOME", contactTypeSelectedOptionElements.get(0).getText());
		
		contactTypeSelectBox.selectByValue("CEM");
		Thread.sleep(1000);
		
		contactTypeSelectedOptionElements = contactTypeSelectBox.getAllSelectedOptions();
		assertEquals("Contact Type Select Box should have only one selected value!", 1, contactTypeSelectedOptionElements.size());
		assertEquals("Contact Type Set Value is incorrect!", "CEM - CEMETERY", contactTypeSelectedOptionElements.get(0).getText());
		
		System.out.println("StationMaintenanceAddContactInfoTest: End test_11_VerifyContactTypeSelectField_CanChangeValues()");
	}
	*/
	
	@Test
	public void test_12_Verify_CancelButtonExists() throws Exception {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin test_12_Verify_CancelButtonExists()");

		WebElement cancelButtonElement = driver.findElement(By.id("cancel"));
		assertNotNull(cancelButtonElement);
		
		System.out.println("StationMaintenanceAddContactInfoTest: End test_12_Verify_CancelButtonExists()");
	}	
	
	@Test
	public void test_13_Verify_CancelButtonClick_ForwardsBackTo_StationMaintenanceEditPage() throws Exception {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin test_3_Verify_CancelButtonClick_ForwardsBackTo_StationMaintenanceEditPage()");

		WebElement cancelButtonElement = driver.findElement(By.id("cancel"));
		assertNotNull(cancelButtonElement);
		
		cancelButtonElement.click();
		Thread.sleep(3000);
		
		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		assertEquals("Incorrect Page Title for Station Maintenance Edit Page!", 
				"Station Maintenance  |  Edit", pageTitleElement.getText());
		
		System.out.println("StationMaintenanceAddContactInfoTest: End test_3_Verify_CancelButtonClick_ForwardsBackTo_StationMaintenanceEditPage()");
	}
	
	@Test
	public void test_13a_Verify_SaveButtonExists_AndIsInitiallyDisabled() throws Exception {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin test_13a_Verify_SaveButtonExists_AndIsInitiallyDisabled()");

		WebElement saveButtonElement = driver.findElement(By.id("save"));
		assertNotNull(saveButtonElement);
		
		String disabledAttributeStr = saveButtonElement.getAttribute("disabled");
		assertNotNull(disabledAttributeStr);
		System.out.println("   disabledAttributeStr = " + disabledAttributeStr);
		
		String classAttributeStr = saveButtonElement.getAttribute("class");
		assertNotNull(classAttributeStr);
		System.out.println("   classAttributeStr = " + classAttributeStr);
		assertTrue("The class attribute value on the Save button should contain the disabled string", classAttributeStr.contains("disabled"));
		
		System.out.println("StationMaintenanceAddContactInfoTest: End test_13a_Verify_SaveButtonExists_AndIsInitiallyDisabled()");
	}	
	
	@Test
	public void test_13b_Verify_SaveButtonBecomesEnabledWhenContactTypeTextFieldValueIsEntered() throws Exception {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin test_13b_Verify_SaveButtonBecomesEnabledWhenContactTypeTextFieldValueIsEntered()");

		WebElement contactTypeTextElement = driver.findElement(By.id("contactType"));
		assertNotNull(contactTypeTextElement);
		
		contactTypeTextElement.sendKeys("A");
		
		WebElement saveButtonElement = driver.findElement(By.id("save"));
		assertNotNull(saveButtonElement);
		
		String disabledAttributeStr = saveButtonElement.getAttribute("disabled");
		assertNull(disabledAttributeStr);
		System.out.println("   disabledAttributeStr = " + disabledAttributeStr);
		
		String classAttributeStr = saveButtonElement.getAttribute("class");
		assertNotNull(classAttributeStr);
		System.out.println("   classAttributeStr = " + classAttributeStr);
		assertFalse("The class attribute value on the Save button should NOT contain the disabled string", classAttributeStr.contains("disabled"));
		
		System.out.println("StationMaintenanceAddContactInfoTest: End test_13b_Verify_SaveButtonBecomesEnabledWhenContactTypeTextFieldValueIsEntered()");
	}
	
	@Test
	public void test_14_Verify_SuccessfulContactInfoSave_WithOnlyMinimalRequiredSettings() throws Exception {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin test_14_Verify_SuccessfulContactInfoSave_WithOnlyMinimalRequiredSettings()");
		
		WebElement contactTypeTextElement = driver.findElement(By.id("contactType"));
		assertNotNull(contactTypeTextElement);
		contactTypeTextElement.sendKeys("ABCD");

		WebElement saveButtonElement = driver.findElement(By.id("save"));
		assertNotNull(saveButtonElement);
		Thread.sleep(1000);
		
		saveButtonElement.click();
		Thread.sleep(3000);
		
		// Make sure you are back at the "Station Maintenance  |  Edit" Page.
		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		assertEquals("Incorrect Page Title for Station Maintenance Edit Page!", 
				"Station Maintenance  |  Edit", pageTitleElement.getText());
		
		WebElement addContactInfoSuccessMessageElement = driver.findElement(By.id("addContactInfoSuccessMessage"));
		assertNotNull(addContactInfoSuccessMessageElement);
		
		System.out.println("StationMaintenanceAddContactInfoTest: End test_14_Verify_SuccessfulContactInfoSave_WithOnlyMinimalRequiredSettings()");		
	}
	
	@Test
	public void test_15_Verify_SuccessfulContactInfoSave_WithDataInAllFields() throws Exception {
		System.out.println("StationMaintenanceAddContactInfoTest: Begin test_15_Verify_SuccessfulContactInfoSave_WithDataInAllFields()");

		WebElement contactNameTextElement = driver.findElement(By.id("contactName"));
		assertNotNull(contactNameTextElement);
		contactNameTextElement.sendKeys("Joey Thai");
		
		WebElement contactTypeTextElement = driver.findElement(By.id("contactType"));
		assertNotNull(contactTypeTextElement);
		contactTypeTextElement.sendKeys("CEM");
		
		WebElement addressLineOneTextElement = driver.findElement(By.id("addressLineOne"));
		assertNotNull(addressLineOneTextElement);
		addressLineOneTextElement.sendKeys("123 Elm Street");
		
		WebElement addressLineTwoTextElement = driver.findElement(By.id("addressLineTwo"));
		assertNotNull(addressLineTwoTextElement);
		addressLineTwoTextElement.sendKeys("Apartment 890");
		
		WebElement cityTextElement = driver.findElement(By.id("city"));
		assertNotNull(cityTextElement);
		cityTextElement.sendKeys("Melbourne");
		
		WebElement zipCodeTextElement = driver.findElement(By.id("zipCode"));
		assertNotNull(zipCodeTextElement);
		zipCodeTextElement.sendKeys("90210");
		
		WebElement emailTextElement = driver.findElement(By.id("email"));
		assertNotNull(emailTextElement);
		emailTextElement.sendKeys("larrysummers@ftc-llc.com");
		
		WebElement faxTextElement = driver.findElement(By.id("fax"));
		assertNotNull(faxTextElement);
		faxTextElement.sendKeys("321-678-5621");
		
		WebElement phoneTextElement = driver.findElement(By.id("phone"));
		assertNotNull(phoneTextElement);
		phoneTextElement.sendKeys("321-999-9999");
		
		WebElement saveButtonElement = driver.findElement(By.id("save"));
		assertNotNull(saveButtonElement);
		
		Thread.sleep(1000);
		saveButtonElement.click();
		Thread.sleep(3000);
		
		// Make sure you are back at the "Station Maintenance  |  Edit" Page.
		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		assertEquals("Incorrect Page Title for Station Maintenance Edit Page!", 
				"Station Maintenance  |  Edit", pageTitleElement.getText());
		
		WebElement addContactInfoSuccessMessageElement = driver.findElement(By.id("addContactInfoSuccessMessage"));
		assertNotNull(addContactInfoSuccessMessageElement);
		
		System.out.println("StationMaintenanceAddContactInfoTest: End test_15_Verify_SuccessfulContactInfoSave_WithDataInAllFields()");		
	}
	
	// Franklin Perez (11/1/2017): Do not know how to test for failure of Contact Info Addition due to not knowing
	//   how to excite system to return back failure of Add Contact Info.
}
