package testing;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.io.File;
import java.util.concurrent.TimeUnit;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;

public class SearchClaimsTest {
  private WebDriver driver;
  private String baseUrl;
  private boolean acceptNextAlert = true;
  private StringBuffer verificationErrors = new StringBuffer();
  
  public static void main(String args[]) {
		JUnitCore junit = new JUnitCore();
		junit.addListener(new TextListener(System.out));
		Result result = junit.run(SearchClaimsTest.class); // Replace "SampleTest" with the name of your class
		if (result.getFailureCount() > 0) {
		    System.out.println("Test failed.\n" + result);
		    System.exit(1);
		} else {
		    System.out.println("Test finished successfully.");
		    System.exit(0);
		}
  }

  @Before
  public void setUp() throws Exception {
	System.out.println("SearchClaimsTest: Begin setUp()");  
	
    // driver = new FirefoxDriver();
	
	File file = new File("drivers/IEDriverServer.exe");
	System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
    driver = new InternetExplorerDriver();
    
    baseUrl = "http://localhost:4200/";
    driver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);
    
    System.out.println("SearchClaimsTest: End setUp()");
  }

  @Test
  public void testSearchClaims() throws Exception {
	System.out.println("SearchClaimsTest: Begin testSearchClaims()");
	  
    driver.get(baseUrl + "/search");
    for (int second = 0;; second++) {
      if (second >= 5)
        fail("timeout");
      try {
        if (isElementPresent(By.xpath("(//button[@id=''])[6]")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }
    assertEquals("Last Name", driver.findElement(By.xpath("//div[@id='search']/form/div/div[2]/label")).getText());
    assertEquals("Provider Name", driver.findElement(By.xpath("//div[@id='search']/form/div/div[3]/label")).getText());
    assertEquals("Check / EFT / TRN", driver.findElement(By.xpath("//div[@id='search']/form/div/div[4]/label")).getText());
    assertEquals("Claim Status", driver.findElement(By.xpath("//div[@id='search']/form/div/div[5]/label")).getText());
    assertEquals("SSN", driver.findElement(By.xpath("//div[@id='search']/form/div/div[6]/label")).getText());
    assertEquals("Provider TIN", driver.findElement(By.xpath("//div[@id='search']/form/div/div[7]/label")).getText());
    assertEquals("Begin Service Date (mm/dd/yyyy)", driver.findElement(By.xpath("//div[@id='search']/form/div/div[8]/label")).getText());
    assertEquals("Claim ID", driver.findElement(By.xpath("//div[@id='search']/form/div/div[9]/label")).getText());
    assertEquals("Patient Control Number", driver.findElement(By.xpath("//div[@id='search']/form/div/div[10]/label")).getText());
    assertEquals("Provider NPL", driver.findElement(By.xpath("//div[@id='search']/form/div/div[11]/label")).getText());
    assertEquals("End Service Date (mm/dd/yyyy)", driver.findElement(By.xpath("//div[@id='search']/form/div/div[12]/label")).getText());
    assertEquals("HERO Claims Only", driver.findElement(By.cssSelector("label.form-check-label")).getText());
    assertEquals("Include VISN-only Claims", driver.findElement(By.cssSelector("div.col-9 > div.form-check > label.form-check-label")).getText());
    try {
      assertEquals("off", driver.findElement(By.name("hero")).getAttribute("value"));
    } catch (Error e) {
      verificationErrors.append(e.toString());
    }
    try {
      assertEquals("off", driver.findElement(By.name("visn")).getAttribute("value"));
    } catch (Error e) {
      verificationErrors.append(e.toString());
    }
    for (int second = 0;; second++) {
      if (second >= 5)
        fail("timeout");
      try {
        if (isElementPresent(By.xpath("//button[@type='submit']")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }

    assertEquals("Search", driver.findElement(By.xpath("//button[@type='submit']")).getText());
    for (int second = 0;; second++) {
      if (second >= 5)
        fail("timeout");
      try {
        if (isElementPresent(By.xpath("//button[@type='reset']")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }

    assertEquals("Clear Form", driver.findElement(By.xpath("//button[@type='reset']")).getText());
    assertEquals("Results", driver.findElement(By.id("resultsText")).getText());
    assertEquals("Number of Results:0", driver.findElement(By.cssSelector("p")).getText());
    assertEquals("Print", driver.findElement(By.xpath("//button[@id='']")).getText());
    assertEquals("Reroute", driver.findElement(By.xpath("(//button[@id=''])[2]")).getText());
    assertEquals("Disapprove", driver.findElement(By.xpath("(//button[@id=''])[3]")).getText());
    assertEquals("Print", driver.findElement(By.xpath("(//button[@id=''])[4]")).getText());
    assertEquals("Reroute", driver.findElement(By.xpath("(//button[@id=''])[5]")).getText());
    assertEquals("Disapprove", driver.findElement(By.xpath("(//button[@id=''])[6]")).getText());
    for (int second = 0;; second++) {
      if (second >= 5)
        fail("timeout");
      try {
        if (isElementPresent(By.cssSelector("span.text-muted.pull-right")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }

    driver.findElement(By.xpath("//button[@type='submit']")).click();
    for (int second = 0;; second++) {
      if (second >= 5)
        fail("timeout");
      try {
        if (isElementPresent(By.xpath("(//button[@type='button'])[11]")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }

    for (int second = 0;; second++) {
      if (second >= 5)
        fail("timeout");
      try {
        if (isElementPresent(By.xpath("//table[@id='example']/tbody/tr[10]/td[8]")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }

    assertEquals("Claims Type", driver.findElement(By.xpath("//table[@id='example']/thead/tr/th[3]")).getText());
    assertEquals("Claims Status", driver.findElement(By.xpath("//table[@id='example']/thead/tr/th[4]")).getText());
    assertEquals("HERO", driver.findElement(By.xpath("//table[@id='example']/thead/tr/th[5]")).getText());
    assertEquals("Veteran Name", driver.findElement(By.xpath("//table[@id='example']/thead/tr/th[6]")).getText());
    assertEquals("SSN", driver.findElement(By.xpath("//table[@id='example']/thead/tr/th[7]")).getText());
    assertEquals("Patient Control #", driver.findElement(By.xpath("//table[@id='example']/thead/tr/th[8]")).getText());
    assertEquals("Service Date", driver.findElement(By.xpath("//table[@id='example']/thead/tr/th[9]")).getText());
    assertEquals("Provider", driver.findElement(By.xpath("//table[@id='example']/thead/tr/th[10]")).getText());
    assertEquals("PrTIN", driver.findElement(By.xpath("//table[@id='example']/thead/tr/th[11]")).getText());
    assertEquals("PrNPI", driver.findElement(By.xpath("//table[@id='example']/thead/tr/th[12]")).getText());
    assertEquals("Facility", driver.findElement(By.xpath("//table[@id='example']/thead/tr/th[13]")).getText());
    assertEquals("Assigned To", driver.findElement(By.xpath("//table[@id='example']/thead/tr/th[14]")).getText());
    
    System.out.println("SearchClaimsTest: End testSearchClaims()");
  }

  @After
  public void tearDown() throws Exception {
	System.out.println("SearchClaimsTest: Begin testSearchClaims()");  
	
    driver.quit();
    String verificationErrorString = verificationErrors.toString();
    if (!"".equals(verificationErrorString)) {
      System.out.println(verificationErrorString);
      fail(verificationErrorString);
    }
    System.out.println("DONE");
    
    System.out.println("SearchClaimsTest: End testSearchClaims()");
  }

  private boolean isElementPresent(By by) {
    try {
      driver.findElement(by);
      return true;
    } catch (NoSuchElementException e) {
      return false;
    }
  }

  private boolean isAlertPresent() {
    try {
      driver.switchTo().alert();
      return true;
    } catch (NoAlertPresentException e) {
      return false;
    }
  }

  private String closeAlertAndGetItsText() {
    try {
      Alert alert = driver.switchTo().alert();
      String alertText = alert.getText();
      if (acceptNextAlert) {
        alert.accept();
      } else {
        alert.dismiss();
      }
      return alertText;
    } finally {
      acceptNextAlert = true;
    }
  }
}
