/**
 * 
 */
package testing;

import static org.junit.Assert.*;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.support.ui.Select;

/**
 * @author DNS   PEREZF
 *
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class RerouteClaimsPageTest {
	private WebDriver driver;
	private String baseUrl;
	private String searchClaimsPageUrl;
	
	public static void main(String args[]) {
		JUnitCore junit = new JUnitCore();
		junit.addListener(new TextListener(System.out));
		Result result = junit.run(RerouteClaimsPageTest.class); // Replace "SampleTest" with the name of your class
		if (result.getFailureCount() > 0) {
		    System.out.println("Test failed.\n" + result);
		    System.exit(1);
		} else {
		    System.out.println("Test finished successfully.");
		    System.exit(0);
		}
	}

	/**
	 * @throws java.lang.Exception
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("RerouteClaimsPageTest: Begin setUpBeforeClass()");
		System.out.println("RerouteClaimsPageTest: End setUpBeforeClass()");
	}

	/**
	 * @throws java.lang.Exception
	 */
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
		System.out.println("RerouteClaimsPageTest: Begin tearDownAfterClass()");
		System.out.println("RerouteClaimsPageTest: End tearDownAfterClass()");
	}

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
		System.out.println("RerouteClaimsPageTest: Begin setUp()");
		
		File file = new File("drivers/IEDriverServer.exe");
		System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
		driver = new InternetExplorerDriver();
		
		// baseUrl = "http://SERVER:PORT/";
		baseUrl = "http://localhost:4200/";
		driver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);

		goToLoginPageAndClickLoginButton();
		Thread.sleep(5000);
		clickSetActiveButton();

		searchClaimsPageUrl = baseUrl + "search";
		Thread.sleep(3000);
		
		goToSearchClaimsPage();
		
		System.out.println("RerouteClaimsPageTest: End setUp()");
	}
	
	private void clickSetActiveButton() throws Exception {
		WebElement setActiveButton = driver.findElement(By.id("setActive"));
		assertNotNull(setActiveButton);
		setActiveButton.click();
		// setActiveButton.submit(); // Not inside of a "form" element.
		setActiveButton.sendKeys(Keys.ENTER);
	}

	private void goToLoginPageAndClickLoginButton() throws Exception {
		driver.get(baseUrl);
		WebElement loginButton = driver.findElement(By.id("loginAdminBtn"));
		assertNotNull(loginButton);
		
		// Click the Login Button. Had to do this as advised by Joshua Lone
		// to get this to work to forward to next page.
		loginButton.click();
		loginButton.submit();
		loginButton.sendKeys(Keys.ENTER);
	}
	
	// Below did not work when using the "http://SERVER:PORT/" URL.
	private void goToSearchClaimsPage() throws Exception {
		
		driver.get(searchClaimsPageUrl);
		Thread.sleep(3000);
		
		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		
		assertEquals("Incorrect Page Title for Claims Search Page!", 
				"Claims Search", pageTitleElement.getText());
	}
	
	// Below does not seem to work at all now. Do not know why!
	private void goToSearchClaimsPageViaDropDownMenuOptions() throws Exception {
		List<WebElement> dropDownParentElementsList = driver.findElements(By.className("dropdown-parent"));
		assertNotNull(dropDownParentElementsList);
		assertTrue("Failed to find any elements with class equal to 'dropdown-parent'", dropDownParentElementsList.size() > 0);
		
		boolean claimsDropDownParentElementFound = false;
		for (int i = 0; i < dropDownParentElementsList.size(); i++) {
			
			WebElement dropDownParentElement = dropDownParentElementsList.get(i);
			assertNotNull(dropDownParentElement);
			
			WebElement aElement = dropDownParentElement.findElement(By.tagName("a"));
			assertNotNull("No 'a' element was found under a Drop Down Parent Element!", aElement);
			
			if ( "Claims".equals(aElement.getText()) ) {
				claimsDropDownParentElementFound = true;
				
				System.out.println("   Claims a element = " + aElement);
				
				// Click on the Claims Parent Drop Down Parent Element
				aElement.click();
				Thread.sleep(2000);
				
				// WebElement claimsDropDownShowElement = dropDownParentElement.findElement(By.id("claims"));
				// WebElement claimsDropDownShowElement = dropDownParentElement.findElement(By.className("dropdown"));
				WebElement claimsDropDownShowElement = dropDownParentElement.findElement(By.id("claims"));
				System.out.println("   claimsDropDownShowElement = " + claimsDropDownShowElement);
				assertNotNull("No 'Claims' Drop Down Show Element found under the 'Claims' Drop Down Parent Element!", claimsDropDownShowElement);
				
				System.out.println("   claimsDropDownShowElement = " + claimsDropDownShowElement);
				
				WebElement searchClaims_aElement = claimsDropDownShowElement.findElement(By.linkText("Search Claims"));
				assertNotNull("No 'Search Claims' A Tag Element Found!", searchClaims_aElement);
				
				// Click on the "Search Claims" Option to bring up the "Search Claims" page.
				searchClaims_aElement.click();
				Thread.sleep(3000);
				
				WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
				assertNotNull(pageTitleElement);
				
				assertEquals("Incorrect Page Title for Search Claims Page!", 
						"Claims Search", pageTitleElement.getText());
				
				break;
			}
		}
		
		if (!claimsDropDownParentElementFound) {
			fail("No 'Claims Drop Down Parent Menu Found!'");
		}		
	}
	
	private void rerouteClaimsPageAppearsGoingThroughSearchClaimsPage() throws Exception {
		// Should be in Search Claims Page by now.
		
		WebElement claimIdInputTextElement = driver.findElement(By.id("claimId"));
		claimIdInputTextElement.sendKeys("1009");
		Thread.sleep(3000);
		
		WebElement searchButtonElement = driver.findElement(By.id("search"));
		searchButtonElement.click();
		Thread.sleep(5000);
		
		WebElement rowCheckBoxElement = driver.findElement(By.id("checkBox0"));
		rowCheckBoxElement.click();
		Thread.sleep(3000);
		
		WebElement rerouteButtonElement = driver.findElement(By.id("lowerReroute"));
		rerouteButtonElement.click();
		Thread.sleep(3000);		
		
		// Should be at Reroute Page by now...

		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		
		assertEquals("Incorrect Page Title for Reroute Page!", 
				"Reroute", pageTitleElement.getText());
	}
	
	private void rerouteClaimsPageAppearsGoingThroughSearchClaimsPage_nonRouted() throws Exception {
		// Should be in Search Claims Page by now.
		
		Select claimTypeSelectDropdownElemnent = new Select(driver.findElement(By.name("claimType")));
		assertNotNull(claimTypeSelectDropdownElemnent);
		claimTypeSelectDropdownElemnent.selectByValue("");
		
		Select claimStatusSelectDropdownElemnent = new Select(driver.findElement(By.name("claimStatus")));
		assertNotNull(claimStatusSelectDropdownElemnent);
		claimStatusSelectDropdownElemnent.selectByValue("");
		
		WebElement claimIdInputTextElement = driver.findElement(By.id("claimId"));
		claimIdInputTextElement.sendKeys("100");
		Thread.sleep(3000);
		
		WebElement searchButtonElement = driver.findElement(By.id("search"));
		searchButtonElement.click();
		Thread.sleep(5000);
		
		WebElement rowCheckBoxElement = driver.findElement(By.id("checkBox0"));
		rowCheckBoxElement.click();
		Thread.sleep(3000);
		
		WebElement rerouteButtonElement = driver.findElement(By.id("lowerReroute"));
		rerouteButtonElement.click();
		Thread.sleep(3000);		
		
		// Should be at Reroute Page by now...

		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		
		assertEquals("Incorrect Page Title for Reroute Page!", 
				"Reroute", pageTitleElement.getText());
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
		System.out.println("RerouteClaimsPageTest: Begin tearDown()");
		
		Thread.sleep(5000);
		driver.close();
		driver.quit();
		Thread.sleep(5000);
		System.out.println("End Executing 'tearDown' method");
		
		System.out.println("RerouteClaimsPageTest: End tearDown()");
	}
	
	@Test
	public void test_1_RerouteClaimsPageAppearsGoingThroughSearchClaimsPage() throws Exception {
		System.out.println("RerouteClaimsPageTest: Begin test_1_RerouteClaimsPageAppearsGoingThroughSearchClaimsPage()");
		rerouteClaimsPageAppearsGoingThroughSearchClaimsPage();
		System.out.println("RerouteClaimsPageTest: End test_1_RerouteClaimsPageAppearsGoingThroughSearchClaimsPage()");
	}
	
	@Test
	public void test_2_VerifyNewVisnCanBeSelectedFromRerouteClaimPage() throws Exception {
		System.out.println("RerouteClaimsPageTest: Begin test_2_VerifyNewVisnCanBeSelectedFromRerouteClaimPage()");
		
		rerouteClaimsPageAppearsGoingThroughSearchClaimsPage();
		
		Select visnSelectDropdownElemnent = new Select(driver.findElement(By.name("visnSelect")));
		assertNotNull(visnSelectDropdownElemnent);
		visnSelectDropdownElemnent.selectByValue("16");
		Thread.sleep(3000);
		
		WebElement selectedOption = visnSelectDropdownElemnent.getFirstSelectedOption();
		assertEquals("VISN Selected Value waa not Set properly!", "VISN - 16", selectedOption.getText());
		
		System.out.println("RerouteClaimsPageTest: End test_2_VerifyNewVisnCanBeSelectedFromRerouteClaimPage()");
	}
	
	
	@Test
	public void test_3_claimsSummaryTableFunctionality() throws Exception {
		System.out.println("RerouteClaimsPageTest: Begin test_3_claimsSummaryTableFunctionality()");
		
//		driver.get(searchClaimsPageUrl);
//		Thread.sleep(3000);
//		
//		WebElement claimId = driver.findElement(By.id("claimId"));
//		claimId.sendKeys("1009");
//		driver.findElement(By.id("search")).click();
//		Thread.sleep(1000);
//
//		WebElement checkbox = driver.findElement(By.id("checkBox0"));
//		checkbox.click();
//		Thread.sleep(1000);
//
//		WebElement reroute = driver.findElement(By.id("lowerReroute"));
//		reroute.click();
		rerouteClaimsPageAppearsGoingThroughSearchClaimsPage();
		
		WebElement claimsSummaryTable = driver.findElement(By.id("claimsSummaryTable"));
		assertNotNull(claimsSummaryTable);
		
		WebElement claimId = claimsSummaryTable.findElement(By.id("claimId"));
		WebElement veteranName = claimsSummaryTable.findElement(By.id("veteranName"));
		WebElement providerName = claimsSummaryTable.findElement(By.id("providerName"));
		assertTrue(claimId != null);
		assertTrue(veteranName !=null);
		assertTrue(providerName != null);		
		
		System.out.println("RerouteClaimsPageTest: End test_3_claimsSummaryTableFunctionality()");
	}
	
	@Test
	public void test_4_selectFacility() throws Exception {
		System.out.println("RerouteClaimsPageTest: Begin test_4_selectFacility()");
		
		rerouteClaimsPageAppearsGoingThroughSearchClaimsPage();

		Select dropdown = new Select(driver.findElement(By.id("visnSelect")));
		assertNotNull(dropdown);
		dropdown.selectByValue("16");
		Select facilityDropdown = new Select(driver.findElement(By.id("facilitySelect")));
		assertNotNull(facilityDropdown);
		facilityDropdown.selectByVisibleText("21");
		
		System.out.println("RerouteClaimsPageTest: End test_4_selectFacility()");
	}

	// 587648
	@Test
	public void test_5_selectReasonName() throws Exception {
		System.out.println("RerouteClaimsPageTest: Begin test_6_selectReasonName()");
		
		rerouteClaimsPageAppearsGoingThroughSearchClaimsPage();
		Thread.sleep(1000);
		
		Select reasonDropdown = new Select(driver.findElement(By.id("reason")));
		assertNotNull(reasonDropdown);
		reasonDropdown.selectByVisibleText("1 - Services were authorized by another VA facility");
		
		System.out.println("RerouteClaimsPageTest: End test_6_selectReasonName()");
	}
	
	// Task: 595645  --- User Story: 542902
	@Test
	public void test_6_verifyCommentTextFieldExists() throws Exception {
		System.out.println("RerouteClaimsPageTest: Begin test_6_verifyCommentTextFieldExists()");
		
		rerouteClaimsPageAppearsGoingThroughSearchClaimsPage();
		Thread.sleep(1000);
		
		WebElement comments = driver.findElement(By.id("comments"));
		assertNotNull(comments);
		
		String tagName = comments.getTagName();
		assertEquals("Incorrect tag name for the 'comments' element!", 
				"textarea", tagName);
		
		System.out.println("RerouteClaimsPageTest: End test_6_verifyCommentTextFieldExists()");		
	}
	
	// Task: 595645  --- User Story: 542902
	@Test
	public void test_7_verifyTextCanBeEnteredInCommentTextField() throws Exception {
		System.out.println("RerouteClaimsPageTest: Begin test_7_verifyTextCanBeEnteredInCommentTextField()");
		
		rerouteClaimsPageAppearsGoingThroughSearchClaimsPage();
		Thread.sleep(1000);
		
		WebElement comments = driver.findElement(By.id("comments"));
		assertNotNull(comments);
		
		String textEntered = "The cat is in the hat!";
		comments.sendKeys(textEntered);
		Thread.sleep(1000);
		
		assertEquals("Text entered in Comments Text Field must equal the Text Value!", textEntered, comments.getText());
		
		System.out.println("RerouteClaimsPageTest: End test_7_verifyTextCanBeEnteredInCommentTextField()");		
	}
	
	// Task: 595724  ---- User Story: 542906
	@Test
	public void test_8_verifyRerouteClaimHistoryLabelExists() throws Exception {
		System.out.println("RerouteClaimsPageTest: Begin test_8_verifyRerouteClaimHistoryLabelExists()");
		
		rerouteClaimsPageAppearsGoingThroughSearchClaimsPage();
		Thread.sleep(1000);
		
		WebElement rerouteHistoryLabel = driver.findElement(By.id("rerouteHistoryLabel"));
		assertNotNull(rerouteHistoryLabel);
		
		System.out.println("RerouteClaimsPageTest: End test_8_verifyRerouteClaimHistoryLabelExists()");		
	}
	
	// Task: 595724  ---- User Story: 542906
	@Test
	public void test_9_verifyRerouteHistorySectionExists() throws Exception {
		System.out.println("RerouteClaimsPageTest: Begin test_9_verifyRerouteHistorySectionExists()");
		
		rerouteClaimsPageAppearsGoingThroughSearchClaimsPage();
		Thread.sleep(1000);
		
		WebElement rerouteHistorySection = driver.findElement(By.id("rerouteHistorySection"));
		assertNotNull(rerouteHistorySection);
		
		System.out.println("RerouteClaimsPageTest: End test_9_verifyRerouteHistorySectionExists()");		
	}
	
	// Task: 595724  ---- User Story: 542906
	@Test
	public void test_10_verifyCorrectRerouteHistoryTitleExists() throws Exception {
		System.out.println("RerouteClaimsPageTest: Begin test_10_verifyCorrectRerouteHistoryTitleExists()");
		
		rerouteClaimsPageAppearsGoingThroughSearchClaimsPage();
		Thread.sleep(1000);
		
		WebElement rerouteHistoryTitle = driver.findElement(By.id("claimRerouteHistoryTitle1009"));
		assertNotNull(rerouteHistoryTitle);
		assertEquals("Incorrect Reroute History Title for Claim 1009!", "Claim 1009", rerouteHistoryTitle.getText());
		
		System.out.println("RerouteClaimsPageTest: End test_10_verifyCorrectRerouteHistoryTitleExists()");		
	}
	
	// Task: 595724  ---- User Story: 542906
	@Test
	public void test_11_verifyCorrectRerouteHistoryTableExistsWithCorrectColumnRows() throws Exception {
		System.out.println("RerouteClaimsPageTest: Begin test_11_verifyCorrectRerouteHistoryTableExistsWithCorrectColumnRows()");
		
		rerouteClaimsPageAppearsGoingThroughSearchClaimsPage();
		Thread.sleep(1000);
		
		WebElement rerouteHistoryTable = driver.findElement(By.id("claimRerouteHistoryTable1009"));
		assertNotNull(rerouteHistoryTable);
		
		List<WebElement> rerouteHistoryTableRows = rerouteHistoryTable.findElements(By.id("claimRerouteHistoryTableRowData"));
		assertTrue("Should have 1 or more rows of Claim History Data", rerouteHistoryTableRows.size() > 0);
		
		for ( WebElement rerouteHistoryTableRow:  rerouteHistoryTableRows ) {
			WebElement dateClaimRerouteHistoryTableData = rerouteHistoryTableRow.findElement(By.id("dateClaimRerouteHistoryTableData"));
			assertNotNull(dateClaimRerouteHistoryTableData);
			
			WebElement reasonClaimRerouteHistoryTableData = rerouteHistoryTableRow.findElement(By.id("reasonClaimRerouteHistoryTableData"));
			assertNotNull(reasonClaimRerouteHistoryTableData);
			
			WebElement explanationClaimRerouteHistoryTableData = rerouteHistoryTableRow.findElement(By.id("explanationClaimRerouteHistoryTableData"));
			assertNotNull(explanationClaimRerouteHistoryTableData);
			
			WebElement transferredToClaimRerouteHistoryTableData = rerouteHistoryTableRow.findElement(By.id("transferredToClaimRerouteHistoryTableData"));
			assertNotNull(transferredToClaimRerouteHistoryTableData);
			
			WebElement transferredFromClaimRerouteHistoryTableData = rerouteHistoryTableRow.findElement(By.id("transferredFromClaimRerouteHistoryTableData"));
			assertNotNull(transferredFromClaimRerouteHistoryTableData);
			
			WebElement transferredByClaimRerouteHistoryTableData = rerouteHistoryTableRow.findElement(By.id("transferredByClaimRerouteHistoryTableData"));
			assertNotNull(transferredByClaimRerouteHistoryTableData);
		}
		
		System.out.println("RerouteClaimsPageTest: End test_11_verifyCorrectRerouteHistoryTableExistsWithCorrectColumnRows()");		
	}
	
	// Task: 595724  ---- User Story: 542906
	@Test
	public void test_11_verifyNonRoutedExistsWhenClaimCannotBeRouted() throws Exception {
		System.out.println("RerouteClaimsPageTest: Begin test_11_verifyNonRoutedExistsWhenClaimCannotBeRouted()");
		
		rerouteClaimsPageAppearsGoingThroughSearchClaimsPage_nonRouted();
		Thread.sleep(1000);
		
		WebElement nonRoutedMessage = driver.findElement(By.id("nonRoutedMessage"));
		assertNotNull(nonRoutedMessage);
		assertTrue("Non Routed Message should not be an empty string!", nonRoutedMessage.getText().length() > 0);
		
		System.out.println("RerouteClaimsPageTest: End test_11_verifyNonRoutedExistsWhenClaimCannotBeRouted()");		
	}
	
	// Unable to Test for situation where a Claim has no Claim History, because I do not know which claim
	// has no Claim History.
	
	// Task: 595724  ---- User Story: 542906
	@Test
	public void test_12_verifyRerouteButtonExistsAndIsInitiallyDisabled() throws Exception {
		System.out.println("RerouteClaimsPageTest: Begin test_12_verifyRerouteButtonExistsAndIsInitiallyDisabled()");
		
		rerouteClaimsPageAppearsGoingThroughSearchClaimsPage();
		Thread.sleep(1000);
		
		WebElement rerouteButton = driver.findElement(By.id("submit"));
		assertNotNull(rerouteButton);
		assertEquals("Incorrect Label for Reroute Button!", "Reroute", rerouteButton.getText());
		
		String disabledAttribute = rerouteButton.getAttribute("disabled");
		assertNotNull(disabledAttribute);
		
		System.out.println("RerouteClaimsPageTest: End test_12_verifyRerouteButtonExistsAndIsInitiallyDisabled()");		
	}
	
	// Task: 595724  ---- User Story: 542906
	@Test
	public void test_13_verifyRerouteButtonIsEnabledOnlyWhenVisnFacilityAndReasonValuesAreEntered() throws Exception {
		System.out.println("RerouteClaimsPageTest: Begin test_13_verifyRerouteButtonIsEnabledOnlyWhenVisnFacilityAndReasonValuesAreEntered()");
		
		rerouteClaimsPageAppearsGoingThroughSearchClaimsPage();
		Thread.sleep(1000);
		
		WebElement rerouteButton = driver.findElement(By.id("submit"));
		assertNotNull(rerouteButton);
		assertEquals("Incorrect Label for Reroute Button!", "Reroute", rerouteButton.getText());
		
		String disabledAttribute = rerouteButton.getAttribute("disabled");
		assertNotNull(disabledAttribute);
		
		Select visnSelectDropdownElement = new Select(driver.findElement(By.name("visnSelect")));
		assertNotNull(visnSelectDropdownElement);
		visnSelectDropdownElement.selectByValue("16");
		Thread.sleep(2000);
		
		disabledAttribute = rerouteButton.getAttribute("disabled");
		assertNotNull(disabledAttribute);
		
		Select facilityDropdown = new Select(driver.findElement(By.id("facilitySelect")));
		assertNotNull(facilityDropdown);
		facilityDropdown.selectByVisibleText("21");
		Thread.sleep(2000);
		
		disabledAttribute = rerouteButton.getAttribute("disabled");
		assertNotNull(disabledAttribute);
		
		Select reasonDropdown = new Select(driver.findElement(By.id("reason")));
		assertNotNull(reasonDropdown);
		reasonDropdown.selectByValue("1");	
		Thread.sleep(2000);
		
		// Reroute Button should be enabled by now.
		disabledAttribute = rerouteButton.getAttribute("disabled");
		assertNull(disabledAttribute);		
		
		System.out.println("RerouteClaimsPageTest: End test_13_verifyRerouteButtonIsEnabledOnlyWhenVisnFacilityAndReasonValuesAreEntered()");		
	}
	
	// Task: 595724  ---- User Story: 542906
	@Test
	public void test_14_verifyWhenRerouteButtonIsClickedAndRoutesSuccessfully() throws Exception {
		System.out.println("RerouteClaimsPageTest: Begin test_14_verifyWhenRerouteButtonIsClickedAndRoutesSuccessfully()");
		
		rerouteClaimsPageAppearsGoingThroughSearchClaimsPage();
		Thread.sleep(1000);
		
		WebElement rerouteButton = driver.findElement(By.id("submit"));
		assertNotNull(rerouteButton);
		assertEquals("Incorrect Label for Reroute Button!", "Reroute", rerouteButton.getText());
		
		String disabledAttribute = rerouteButton.getAttribute("disabled");
		assertNotNull(disabledAttribute);
		
		Select visnSelectDropdownElement = new Select(driver.findElement(By.name("visnSelect")));
		assertNotNull(visnSelectDropdownElement);
		visnSelectDropdownElement.selectByValue("16");
		Thread.sleep(2000);
		
		disabledAttribute = rerouteButton.getAttribute("disabled");
		assertNotNull(disabledAttribute);
		
		Select facilityDropdown = new Select(driver.findElement(By.id("facilitySelect")));
		assertNotNull(facilityDropdown);
		facilityDropdown.selectByVisibleText("21");
		Thread.sleep(2000);
		
		disabledAttribute = rerouteButton.getAttribute("disabled");
		assertNotNull(disabledAttribute);
		
		Select reasonDropdown = new Select(driver.findElement(By.id("reason")));
		assertNotNull(reasonDropdown);
		reasonDropdown.selectByValue("1");	
		
		WebElement comments = driver.findElement(By.id("comments"));
		assertNotNull(comments);
		
		String textEntered = "The cat is in the hat!";
		comments.sendKeys(textEntered);		
		
		Thread.sleep(2000);
		
		// Reroute Button should be enabled by now.
		disabledAttribute = rerouteButton.getAttribute("disabled");
		assertNull(disabledAttribute);		
		Thread.sleep(1000);
		
		// Click on the Reroute Button.
		rerouteButton.click();
		// rerouteButton.sendKeys(Keys.ENTER);
		Thread.sleep(3000);
		
		// Verify that a Successful Reroute Message is displayed.
		WebElement successfulRerouteElement = driver.findElement(By.id("successfulRerouteMessage"));
		assertNotNull(successfulRerouteElement);
		
		assertTrue("Length of Successful Route Message must be greater than 0!", successfulRerouteElement.getText().length() > 0 );
		
		System.out.println("RerouteClaimsPageTest: End test_14_verifyWhenRerouteButtonIsClickedAndRoutesSuccessfully()");		
	}
}
