package testing;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.fail;

import java.io.File;
import java.util.concurrent.TimeUnit;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;

public class RerouteButtonTest {
  private static WebDriver driver;
  private static String baseUrl;
  private boolean acceptNextAlert = true;
  private static StringBuffer verificationErrors = new StringBuffer();
  
  public static void main(String args[]) {
		JUnitCore junit = new JUnitCore();
		junit.addListener(new TextListener(System.out));
		Result result = junit.run(RerouteButtonTest.class); // Replace "SampleTest" with the name of your class
		if (result.getFailureCount() > 0) {
		    System.out.println("Test failed.\n" + result);
		    System.exit(1);
		} else {
		    System.out.println("Test finished successfully.");
		    System.exit(0);
		}
  }

  @BeforeClass
  public static void setUp() throws Exception {
	System.out.println("RerouteButtonTest: Begin setUp()");
	
	File file = new File("drivers/IEDriverServer.exe");
	System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
	  
    driver = new InternetExplorerDriver();
    baseUrl = "http://localhost:4200/";
    driver.manage().timeouts().implicitlyWait(5, TimeUnit.SECONDS);
    
    System.out.println("RerouteButtonTest: End setUp()");
  }

  @Test
  public void testReroute() throws Exception {
	System.out.println("RerouteButtonTest: Begin testReroute()");
	  
    driver.get(baseUrl + "/search");
    driver.findElement(By.xpath("//button[@type='submit']")).click();
    for (int second = 0;; second++) {
      if (second >= 5)
        fail("timeout");
      try {
        if (isElementPresent(By.id("checkBox0")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }

    driver.findElement(By.id("checkBox0")).click();
    driver.findElement(By.xpath("(//button[@id=''])[2]")).click();
    assertEquals(driver.findElement(By.cssSelector("h1")).getText(), "Reroute");
    for (int second = 0;; second++) {
      if (second >= 5)
        fail("timeout");
      try {
        if (isElementPresent(By.cssSelector("h6")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }
    System.out.println("Waiting for h6[2]! Shouldn't be present!");
    assertFalse(isElementPresent(By.xpath("//h6[2]")));
    System.out.println("Going back!");
    driver.navigate().back();
    for (int second = 0;; second++) {
      if (second >= 5)
        fail("timeout");
      try {
        if (isElementPresent(By.xpath("//button[@type='submit']")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }
    System.out.println("Clicking Submit button!");
    driver.findElement(By.xpath("//button[@type='submit']")).click();
    for (int second = 0;; second++) {
      if (second >= 5)
        fail("timeout");
      try {
        if (isElementPresent(By.id("checkBox1")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }
    System.out.println("Clicking Checkboxes");
    driver.findElement(By.id("checkBox0")).click();
    driver.findElement(By.id("checkBox1")).click();
    driver.findElement(By.xpath("(//button[@id=''])[2]")).click();
    assertEquals(driver.findElement(By.cssSelector("h1")).getText(), "Reroute");
    for (int second = 0;; second++) {
      if (second >= 5)
        fail("timeout");
      try {
        if (isElementPresent(By.cssSelector("h6")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }

    for (int second = 0;; second++) {
      if (second >= 5)
        fail("timeout");
      try {
        if (isElementPresent(By.xpath("//h6[2]")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }

    assertFalse(isElementPresent(By.xpath("//h6[3]")));
    driver.navigate().back();
    for (int second = 0;; second++) {
      if (second >= 5)
        fail("timeout");
      try {
        if (isElementPresent(By.xpath("//button[@type='submit']")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }

    driver.findElement(By.xpath("//button[@type='submit']")).click();
    for (int second = 0;; second++) {
      if (second >= 5)
        fail("timeout");
      try {
        if (isElementPresent(By.name("colcheckbox")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }

    driver.findElement(By.name("colcheckbox")).click();
    for (int second = 0;; second++) {
      if (second >= 5)
        fail("timeout");
      try {
        if (isElementPresent(By.id("checkBox10")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }

    driver.findElement(By.id("checkBox0")).click();
    driver.findElement(By.id("checkBox10")).click();
    driver.findElement(By.xpath("(//button[@id=''])[5]")).click();
    assertEquals(driver.findElement(By.cssSelector("h1")).getText(), "Reroute");
    for (int second = 0;; second++) {
      if (second >= 5)
        fail("timeout");
      try {
        if (isElementPresent(By.cssSelector("h6")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }

    for (int second = 0;; second++) {
      if (second >= 5)
        fail("timeout");
      try {
        if (isElementPresent(By.xpath("//h6[3]")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }
    
    System.out.println("RerouteButtonTest: End testReroute()");
  }

  @AfterClass
  public static void tearDown() throws Exception {
	System.out.println("RerouteButtonTest: Begin tearDown()");
	  
    driver.quit();
    String verificationErrorString = verificationErrors.toString();
    if (!"".equals(verificationErrorString)) {
      fail(verificationErrorString);
    }
    
    System.out.println("RerouteButtonTest: End tearDown()");
  }

  private boolean isElementPresent(By by) {
    try {
      driver.findElement(by);
      return true;
    } catch (NoSuchElementException e) {
      return false;
    }
  }

  private boolean isAlertPresent() {
    try {
      driver.switchTo().alert();
      return true;
    } catch (NoAlertPresentException e) {
      return false;
    }
  }

  private String closeAlertAndGetItsText() {
    try {
      Alert alert = driver.switchTo().alert();
      String alertText = alert.getText();
      if (acceptNextAlert) {
        alert.accept();
      } else {
        alert.dismiss();
      }
      return alertText;
    } finally {
      acceptNextAlert = true;
    }
  }
}
