/**
 * 
 */
package testing;

import static org.junit.Assert.*;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.support.ui.Select;

/**
 * @author DNS   MADDIV
 *
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class RejectClaimsPagination {
	private WebDriver driver;
	private String baseUrl;
	private String rejectClaimsPageUrl;
	
	public static void main(String args[]) {
		JUnitCore junit = new JUnitCore();
		junit.addListener(new TextListener(System.out));
		Result result = junit.run(RejectClaimsPagination.class); // Replace "SampleTest" with the name of your class
		if (result.getFailureCount() > 0) {
		    System.out.println("Test failed.\n" + result);
		    System.exit(1);
		} else {
		    System.out.println("Test finished successfully.");
		    System.exit(0);
		}
	}

	/**
	 * @throws java.lang.Exception
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("RejectClaimsPageTest: Begin setUpBeforeClass()");
		System.out.println("RejectClaimsPageTest: End setUpBeforeClass()");
	}

	/**
	 * @throws java.lang.Exception
	 */
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
		System.out.println("ARejectClaimsPageTest: Begin tearDownAfterClass()");
		System.out.println("RejectClaimsPageTest: End tearDownAfterClass()");
	}

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
		System.out.println("RejectClaimsPageTest: Begin setUp()");
		
		File file = new File("drivers/IEDriverServer.exe");
		System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
		driver = new InternetExplorerDriver();
		
		baseUrl = "http://localhost:4200/";
		driver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);

		goToLoginPageAndClickLoginButton();
		Thread.sleep(5000);
		clickSetActiveButton();

		rejectClaimsPageUrl = baseUrl + "reject";
		
		Thread.sleep(3000);
		
		System.out.println("RejectClaimsPageTest: End setUp()");
	}
	
	private void clickSetActiveButton() throws Exception {
		WebElement setActiveButton = driver.findElement(By.id("setActive"));
		assertNotNull(setActiveButton);
		setActiveButton.click();
		// setActiveButton.submit(); // Not inside of a "form" element.
		setActiveButton.sendKeys(Keys.ENTER);
	}

	private void goToLoginPageAndClickLoginButton() throws Exception {
		driver.get(baseUrl);
		WebElement loginButton = driver.findElement(By.id("loginBtn"));
		assertNotNull(loginButton);
		
		// Click the Login Button. Had to do this as advised by Joshua Lone
		// to get this to work to forward to next page.
		loginButton.click();
		loginButton.submit();
		loginButton.sendKeys(Keys.ENTER);
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
		System.out.println("RejectClaimsPageTest: Begin tearDown()");
		
		Thread.sleep(5000);
		driver.close();
		driver.quit();
		Thread.sleep(5000);
		System.out.println("End Executing 'tearDown' method");
		
		System.out.println("RejectClaimsPageTest: End tearDown()");
	}

	@Test
	public void test_1_RejectClaimsResultsForPage() throws Exception {
		//541943
		System.out.println("RejectClaimsPageTest: Begin test_1_RejectClaimsResultsForPage()");
		
		driver.get(rejectClaimsPageUrl);
		Thread.sleep(3000);
		Select dropdown = new Select(driver.findElement(By.id("page-size")));
		dropdown.selectByVisibleText("25");

		int rowCount=driver.findElements(By.xpath("//table[@id='datatable']/tbody/tr")).size();
		System.out.println("Row Count "+ rowCount);
		
		assertTrue("Wrong number of claims displayed per page", rowCount == 25);

		System.out.println("RejectClaimsPageTest: End test_1_RejectClaimsResultsForPage()");
	}
	
	
	@Test
	public void test_2_RejectClaimsPagination() throws Exception {
		//541946
		System.out.println("RejectClaimsPageTest: Begin test_2_RejectClaimsPagination()");

		driver.get(rejectClaimsPageUrl);
		Thread.sleep(3000);
		WebElement paginateButton = driver.findElement(By.id("paginateFirst"));
		assertTrue("Pagination controls exist",paginateButton!=null);
		System.out.println("RejectClaimsPageTest: End test_2_RejectClaimsPagination()");
	}
	
	@Test
	public void test_3_RejectClaimsNoResults() throws Exception {
		//541941
		System.out.println("RejectClaimsPageTest: Begin test_3_RejectClaimsNoResults()");

		driver.get(rejectClaimsPageUrl);
		Thread.sleep(3000);
		
		assertTrue("Number of results exist", driver.findElement(By.id("numResultsTop")).getAttribute("innerHTML").contains("Number of Results:"));
		System.out.println("RejectClaimsPageTest: End test_3_RejectClaimsNoResults()");
	}
	
	@Test
	public void test_4_RejectClaimsSelection() throws Exception {
		//541940
		System.out.println("RejectClaimsPageTest: Begin test_4_RejectClaimsSelection()");

		driver.get(rejectClaimsPageUrl);
		Thread.sleep(3000);
		
		assertTrue("Number of results exist", driver.findElement(By.id("numResultsTop")).getAttribute("innerHTML").contains("Number of Results:"));
		System.out.println("RejectClaimsPageTest: End test_4_RejectClaimsSelection()");
		
		WebElement selectAll = driver.findElement(By.name("colcheckbox"));
		selectAll.click();
		
		WebElement checkbox0 = driver.findElement(By.id("checkBox0"));
		checkbox0.click();
		
		WebElement checkbox1 = driver.findElement(By.id("checkBox1"));
		checkbox1.click();
		assertTrue("Select all is enabled", selectAll.isEnabled());
		assertTrue("Checkbox 0 is enabled ", checkbox0.isEnabled());
		assertTrue("Checkbox 0 is enabled ", checkbox1.isEnabled());
			
		
	}
	
	@Test
	public void test_5_RejectClaimsSorting() throws Exception {
		//541938
		System.out.println("RejectClaimsPageTest: Begin test_5_RejectClaimsSorting()");

		driver.get(rejectClaimsPageUrl);
		Thread.sleep(3000);
		WebElement claimId = driver.findElement(By.id("claimId"));
		WebElement claimType = driver.findElement(By.id("claimType"));
		WebElement hero = driver.findElement(By.id("hero"));
		WebElement patientId = driver.findElement(By.id("patientId"));
		WebElement claimDate = driver.findElement(By.id("claimDate"));
		WebElement claimAmount = driver.findElement(By.id("claimAmount"));
		WebElement providerName = driver.findElement(By.id("providerName"));
		WebElement disapprovedBy = driver.findElement(By.id("disapprovedBy"));
		WebElement disapprovedDate = driver.findElement(By.id("disapprovedDate"));
		WebElement reason = driver.findElement(By.id("reason"));
		WebElement explanation = driver.findElement(By.id("explanation"));
		
		assertTrue("Sorting controls on claim ID exist",(claimId.isDisplayed() && claimId.isEnabled()));
		assertTrue("Sorting controls on claimType exist",(claimType.isDisplayed() && claimType.isEnabled()));
		assertTrue("Sorting controls on hero exist",(hero.isDisplayed() && hero.isEnabled()));
		assertTrue("Sorting controls on patientId exist",(patientId.isDisplayed() && patientId.isEnabled()));
		assertTrue("Sorting controls on claimDate exist",(claimDate.isDisplayed() && claimDate.isEnabled()));
		assertTrue("Sorting controls on claimAmount exist",(claimAmount.isDisplayed() && claimAmount.isEnabled()));
		assertTrue("Sorting controls on providerName exist",(providerName.isDisplayed() && providerName.isEnabled()));
		assertTrue("Sorting controls on disapprovedBy exist",(disapprovedBy.isDisplayed() && disapprovedBy.isEnabled()));
		assertTrue("Sorting controls on disapprovedDate exist",(disapprovedDate.isDisplayed() && disapprovedDate.isEnabled()));
		assertTrue("Sorting controls on reason exist",(reason.isDisplayed() && reason.isEnabled()));
		assertTrue("Sorting controls on explanation exist",(explanation.isDisplayed() && explanation.isEnabled()));

		System.out.println("RejectClaimsPageTest: End test_5_RejectClaimsSorting()");
	}
	
}
