/**
 * 
 */
package testing;

import static org.junit.Assert.*;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.ie.InternetExplorerDriver;

/**
 * @author DNS   PEREZF
 *
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class RejectClaimsPageTest {
	private WebDriver driver;
	private String baseUrl;
	private String rejectClaimsPageUrl;
	
	public static void main(String args[]) {
		JUnitCore junit = new JUnitCore();
		junit.addListener(new TextListener(System.out));
		Result result = junit.run(RejectClaimsPageTest.class); // Replace "SampleTest" with the name of your class
		if (result.getFailureCount() > 0) {
		    System.out.println("Test failed.\n" + result);
		    System.exit(1);
		} else {
		    System.out.println("Test finished successfully.");
		    System.exit(0);
		}
	}

	/**
	 * @throws java.lang.Exception
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("RejectClaimsPageTest: Begin setUpBeforeClass()");
		System.out.println("RejectClaimsPageTest: End setUpBeforeClass()");
	}

	/**
	 * @throws java.lang.Exception
	 */
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
		System.out.println("ARejectClaimsPageTest: Begin tearDownAfterClass()");
		System.out.println("RejectClaimsPageTest: End tearDownAfterClass()");
	}

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
		System.out.println("RejectClaimsPageTest: Begin setUp()");
		
		File file = new File("drivers/IEDriverServer.exe");
		System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
		driver = new InternetExplorerDriver();
		
		baseUrl = "http://localhost:4200/";
		driver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);

		goToLoginPageAndClickLoginButton();
		Thread.sleep(5000);
		clickSetActiveButton();

		rejectClaimsPageUrl = baseUrl + "reject";
		
		Thread.sleep(3000);
		
		System.out.println("RejectClaimsPageTest: End setUp()");
	}
	
	private void clickSetActiveButton() throws Exception {
		WebElement setActiveButton = driver.findElement(By.id("setActive"));
		assertNotNull(setActiveButton);
		setActiveButton.click();
		// setActiveButton.submit(); // Not inside of a "form" element.
		setActiveButton.sendKeys(Keys.ENTER);
	}

	private void goToLoginPageAndClickLoginButton() throws Exception {
		driver.get(baseUrl);
		WebElement loginButton = driver.findElement(By.id("loginBtn"));
		assertNotNull(loginButton);
		
		// Click the Login Button. Had to do this as advised by Joshua Lone
		// to get this to work to forward to next page.
		loginButton.click();
		loginButton.submit();
		loginButton.sendKeys(Keys.ENTER);
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
		System.out.println("RejectClaimsPageTest: Begin tearDown()");
		
		Thread.sleep(5000);
		driver.close();
		driver.quit();
		Thread.sleep(5000);
		System.out.println("End Executing 'tearDown' method");
		
		System.out.println("RejectClaimsPageTest: End tearDown()");
	}

	@Test
	public void test_1_RejectClaimsPageAppearsWhenGoingDirectly() throws Exception {
		System.out.println("RejectClaimsPageTest: Begin test_1_RejectClaimsPageAppearsWhenGoingDirectly()");
		
		driver.get(rejectClaimsPageUrl);
		Thread.sleep(3000);
		
		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		
		assertEquals("Incorrect Page Title for Reject Claims Page!", 
				"Reject Claims", pageTitleElement.getText());
		
		WebElement sectionHeaderTitleElement = driver.findElement(By.id("sectionHeaderTitle"));
		assertNotNull(sectionHeaderTitleElement);
		
		assertEquals("Incorrect Section Header Title for Reject Claims Page!", 
				"Disapproved Claims", sectionHeaderTitleElement.getText());
		
		System.out.println("RejectClaimsPageTest: End test_1_RejectClaimsPageAppearsWhenGoingDirectly()");
	}
	
	@Test
	public void test_2_RejectClaimsPageAppearsViaDropDownMenuOptions() throws Exception {
		System.out.println("RejectClaimsPageTest: Begin test_2_RejectClaimsPageAppearsViaDropDownMenuOptions()");
		
		List<WebElement> dropDownParentElementsList = driver.findElements(By.className("dropdown-parent"));
		assertNotNull(dropDownParentElementsList);
		assertTrue("Failed to find any elements with class equal to 'dropdown-parent'", dropDownParentElementsList.size() > 0);
		
		boolean claimsDropDownParentElementFound = false;
		for (int i = 0; i < dropDownParentElementsList.size(); i++) {
			
			WebElement dropDownParentElement = dropDownParentElementsList.get(i);
			assertNotNull(dropDownParentElement);
			
			WebElement aElement = dropDownParentElement.findElement(By.tagName("a"));
			assertNotNull("No 'a' element was found under a Drop Down Parent Element!", aElement);
			
			if ( "Claims".equals(aElement.getText()) ) {
				claimsDropDownParentElementFound = true;
				
				// Click on the Claims Parent Drop Down Parent Element
				aElement.click();
				Thread.sleep(3000);
				
				WebElement claimsDropDownShowElement = dropDownParentElement.findElement(By.id("claims"));
				assertNotNull("No 'Claims' Drop Down Show Element found under the 'Claims' Drop Down Parent Element!", claimsDropDownShowElement);
				
				WebElement rejectClaims_aElement = claimsDropDownShowElement.findElement(By.linkText("Reject Claims"));
				assertNotNull("No 'Reject Claims' A Tag Element Found!", rejectClaims_aElement);
				
				// Click on the "Reject Claims" Option to bring up the "Reject Claims" page.
				rejectClaims_aElement.click();
				Thread.sleep(3000);
				
				WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
				assertNotNull(pageTitleElement);
				
				assertEquals("Incorrect Page Title for Reject Claims Page!", 
						"Reject Claims", pageTitleElement.getText());
				
				WebElement sectionHeaderTitleElement = driver.findElement(By.id("sectionHeaderTitle"));
				assertNotNull(sectionHeaderTitleElement);
				
				assertEquals("Incorrect Section Header Title for Reject Claims Page!", 
						"Disapproved Claims", sectionHeaderTitleElement.getText());
				
				break;
			}
		}
		
		if (!claimsDropDownParentElementFound) {
			fail("No 'Claims Drop Down Parent Menu Found!'");
		}
		
		System.out.println("RejectClaimsPageTest: End test_2_RejectClaimsPageAppearsViaDropDownMenuOptions()");
	}
	
	@Test
	public void test_3_IfRejectedClaimsTableExists_VerifyColumnsExistAndNamesAreCorrect() throws Exception {
		System.out.println("RejectClaimsPageTest: Begin test_3_IfRejectedClaimsTableExists_VerifyColumnsExistAndNamesAreCorrect()");
		
		driver.get(rejectClaimsPageUrl);
		Thread.sleep(4000);
		
		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		
		assertEquals("Incorrect Page Title for Reject Claims Page!", 
				"Reject Claims", pageTitleElement.getText());
		
		WebElement sectionHeaderTitleElement = driver.findElement(By.id("sectionHeaderTitle"));
		assertNotNull(sectionHeaderTitleElement);
		
		assertEquals("Incorrect Section Header Title for Reject Claims Page!", 
				"Disapproved Claims", sectionHeaderTitleElement.getText());	
		
		WebElement tableComponentElement = null;
		try {
			tableComponentElement = driver.findElement(By.id("table"));
		} catch (NoSuchElementException ex) { }
		if (tableComponentElement == null) {
			return;
		}
		
		WebElement dataTableElement = tableComponentElement.findElement(By.id("datatable"));
		assertNotNull("The 'datatable' element inside of the 'table' element does not exist!", dataTableElement);
		
		WebElement selectedColumnElement = dataTableElement.findElement(By.id("selected"));
		assertNotNull("The 'selected' Column Header does not exist!", selectedColumnElement);
		
		WebElement inputColumnElement = selectedColumnElement.findElement(By.name("colcheckbox"));
		assertNotNull("The 'selected' Column Header does not have a checkbox!", inputColumnElement);
		
		WebElement claimIdColumnElement = dataTableElement.findElement(By.id("claimId"));
		assertNotNull("The 'claimId' Column Header does not exist!", claimIdColumnElement);
		
		WebElement divColumnElement = claimIdColumnElement.findElement(By.tagName("div"));
		assertNotNull("The 'claimId' Column Header does not have a 'div' element!", divColumnElement);
		assertEquals("Claim ID", divColumnElement.getText());
		
		WebElement claimTypeColumnElement = dataTableElement.findElement(By.id("claimType"));
		assertNotNull("The 'claimType' Column Header does not exist!", claimTypeColumnElement);
		
		divColumnElement = claimTypeColumnElement.findElement(By.tagName("div"));
		assertNotNull("The 'claimType' Column Header does not have a 'div' element!", divColumnElement);
		assertEquals("Claim Type", divColumnElement.getText());
		
		WebElement heroColumnElement = dataTableElement.findElement(By.id("hero"));
		assertNotNull("The 'hero' Column Header does not exist!", heroColumnElement);
		
		divColumnElement = heroColumnElement.findElement(By.tagName("div"));
		assertNotNull("The 'hero' Column Header does not have a 'div' element!", divColumnElement);
		assertEquals("HERO", divColumnElement.getText());
		
		WebElement patientIdColumnElement = dataTableElement.findElement(By.id("patientId"));
		assertNotNull("The 'patientId' Column Header does not exist!", patientIdColumnElement);
		
		divColumnElement = patientIdColumnElement.findElement(By.tagName("div"));
		assertNotNull("The 'patientId' Column Header does not have a 'div' element!", divColumnElement);
		assertEquals("Patient ID", divColumnElement.getText());
		
		WebElement claimDateColumnElement = dataTableElement.findElement(By.id("claimDate"));
		assertNotNull("The 'claimDate' Column Header does not exist!", claimDateColumnElement);
		
		divColumnElement = claimDateColumnElement.findElement(By.tagName("div"));
		assertNotNull("The 'claimDate' Column Header does not have a 'div' element!", divColumnElement);
		assertEquals("Claim Date", divColumnElement.getText());
		
		WebElement claimAmountColumnElement = dataTableElement.findElement(By.id("claimAmount"));
		assertNotNull("The 'claimAmount' Column Header does not exist!", claimAmountColumnElement);
		
		divColumnElement = claimAmountColumnElement.findElement(By.tagName("div"));
		assertNotNull("The 'claimAmount' Column Header does not have a 'div' element!", divColumnElement);
		assertEquals("Claim Amount", divColumnElement.getText());
		
		WebElement providerNameColumnElement = dataTableElement.findElement(By.id("providerName"));
		assertNotNull("The 'providerName' Column Header does not exist!", providerNameColumnElement);
		
		divColumnElement = providerNameColumnElement.findElement(By.tagName("div"));
		assertNotNull("The 'providerName' Column Header does not have a 'div' element!", divColumnElement);
		assertEquals("Provider", divColumnElement.getText());
		
		WebElement disapprovedByColumnElement = dataTableElement.findElement(By.id("disapprovedBy"));
		assertNotNull("The 'disapprovedBy' Column Header does not exist!", disapprovedByColumnElement);
		
		divColumnElement = disapprovedByColumnElement.findElement(By.tagName("div"));
		assertNotNull("The 'disapprovedBy' Column Header does not have a 'div' element!", divColumnElement);
		assertEquals("Disapproved By", divColumnElement.getText());
		
		WebElement disapprovedDateColumnElement = dataTableElement.findElement(By.id("disapprovedDate"));
		assertNotNull("The 'disapprovedDate' Column Header does not exist!", disapprovedDateColumnElement);
		
		divColumnElement = disapprovedDateColumnElement.findElement(By.tagName("div"));
		assertNotNull("The 'disapprovedDate' Column Header does not have a 'div' element!", divColumnElement);
		assertEquals("Disapproval Date", divColumnElement.getText());
		
		WebElement reasonColumnElement = dataTableElement.findElement(By.id("reason"));
		assertNotNull("The 'reason' Column Header does not exist!", reasonColumnElement);
		
		divColumnElement = reasonColumnElement.findElement(By.tagName("div"));
		assertNotNull("The 'reason' Column Header does not have a 'div' element!", divColumnElement);
		assertEquals("Reason", divColumnElement.getText());
		
		WebElement explanationColumnElement = dataTableElement.findElement(By.id("explanation"));
		assertNotNull("The 'explanation' Column Header does not exist!", explanationColumnElement);
		
		divColumnElement = explanationColumnElement.findElement(By.tagName("div"));
		assertNotNull("The 'explanation' Column Header does not have a 'div' element!", divColumnElement);
		assertEquals("Explanation", divColumnElement.getText());
		
		WebElement commentsColumnElement = dataTableElement.findElement(By.id("comments"));
		assertNotNull("The 'comments' Column Header does not exist!", commentsColumnElement);
		
		divColumnElement = commentsColumnElement.findElement(By.tagName("div"));
		assertNotNull("The 'comments' Column Header does not have a 'div' element!", divColumnElement);
		assertEquals("Comments", divColumnElement.getText());
		
		WebElement historyColumnElement = dataTableElement.findElement(By.id("history"));
		assertNotNull("The 'history' Column Header does not exist!", commentsColumnElement);
		
		divColumnElement = historyColumnElement.findElement(By.tagName("div"));
		assertNotNull("The 'history' Column Header does not have a 'div' element!", divColumnElement);
		assertEquals("History", divColumnElement.getText());
		
		System.out.println("RejectClaimsPageTest: End test_3_IfRejectedClaimsTableExists_VerifyColumnsExistAndNamesAreCorrect()");
	}
	
	@Test
	public void test_4_IfRejectedClaimsTableExists_VerifyCorrectPageSizeInitialValueAndLabelString() throws Exception {
		System.out.println("RejectClaimsPageTest: Begin test_4_IfRejectedClaimsTableExists_VerifyCorrectPageSizeInitialValueAndLabelString()");
		
		driver.get(rejectClaimsPageUrl);
		Thread.sleep(4000);
		
		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		
		assertEquals("Incorrect Page Title for Reject Claims Page!", 
				"Reject Claims", pageTitleElement.getText());
		
		WebElement sectionHeaderTitleElement = driver.findElement(By.id("sectionHeaderTitle"));
		assertNotNull(sectionHeaderTitleElement);
		
		assertEquals("Incorrect Section Header Title for Reject Claims Page!", 
				"Disapproved Claims", sectionHeaderTitleElement.getText());	
		
		WebElement tableComponentElement = null;
		try {
			tableComponentElement = driver.findElement(By.id("table"));
		} catch (NoSuchElementException ex) { }
		if (tableComponentElement == null) {
			return;
		}
		
		// Make sure there are two "Page Size" labels...
		int numberOfPageSizeLabels = 0;
		List<WebElement> labelElementsList = tableComponentElement.findElements(By.tagName("label"));
		assertNotNull("No 'label' elements found!", labelElementsList);
		for (int i = 0; i < labelElementsList.size(); i++) {
			WebElement labelElement = labelElementsList.get(i);
			if ("Page Size".equals(labelElement.getText())) {
				numberOfPageSizeLabels++;
			}
		}
		assertEquals("Incorrect number of 'Page Size' labels!", 2, numberOfPageSizeLabels);
		
		// Make sure there are two "Page Size" Select elements with their proper initial value...
		List<WebElement> pageSizeSelectElementsList = tableComponentElement.findElements(By.tagName("select"));
		assertNotNull("No 'select' elements found!", pageSizeSelectElementsList);
		assertEquals("Incorrect number of 'select' elements!", 2, pageSizeSelectElementsList.size());
		for (int i = 0; i < pageSizeSelectElementsList.size(); i++) {
			WebElement pageSizeSelectElement = pageSizeSelectElementsList.get(i);
			assertEquals("Incorrect Initial Page Size Value!", "10", pageSizeSelectElement.getAttribute("ng-reflect-model"));
		}
		
		System.out.println("RejectClaimsPageTest: End test_4_IfRejectedClaimsTableExists_VerifyCorrectPageSizeInitialValueAndLabelString()");
	}
	
	@Test
	public void test_5_IfRejectedClaimsTableExists_VerifyCorrectNumberOfResultsAndTableRows() throws Exception {
		System.out.println("RejectClaimsPageTest: Begin test_5_IfRejectedClaimsTableExists_VerifyCorrectNumberOfResultsAndTableRows()");
		
		driver.get(rejectClaimsPageUrl);
		Thread.sleep(4000);
		
		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		
		assertEquals("Incorrect Page Title for Reject Claims Page!", 
				"Reject Claims", pageTitleElement.getText());
		
		WebElement sectionHeaderTitleElement = driver.findElement(By.id("sectionHeaderTitle"));
		assertNotNull(sectionHeaderTitleElement);
		
		assertEquals("Incorrect Section Header Title for Reject Claims Page!", 
				"Disapproved Claims", sectionHeaderTitleElement.getText());	
		
		WebElement tableComponentElement = null;
		try {
			tableComponentElement = driver.findElement(By.id("table"));
		} catch (NoSuchElementException ex) { }
		if (tableComponentElement == null) {
			return;
		}
		
		// Note: Initial Page Size of Table will be equal to "10".
		int initialPageSizeOfTable = 10;
		
		WebElement numberOfResultsTopElement = tableComponentElement.findElement(By.id("numResultsTop"));
		assertNotNull("No 'numResultsTop' element present!", numberOfResultsTopElement);
		String numberOfResultsTopElementText = numberOfResultsTopElement.getText();
		assertEquals("Incorrect text string value for 'numResultsTop' element!", "Number of Results: ", numberOfResultsTopElementText.substring(0, "Number of results: ".length()));
		
		String numberOfResultsTopInteger = numberOfResultsTopElementText.substring(numberOfResultsTopElementText.substring(0, "Number of results: ".length()).length());
		int numberOfResultsTopInt = Integer.parseInt(numberOfResultsTopInteger);
		
		WebElement numberOfResultsBottomElement = tableComponentElement.findElement(By.id("numResultsBottom"));
		assertNotNull("No 'numResultsBottom' element present!", numberOfResultsBottomElement);
		String numberOfResultsBottomElementText = numberOfResultsBottomElement.getText();
		assertEquals("Incorrect text string value for 'numResultsBottom' element!", "Number of Results: ", numberOfResultsBottomElementText.substring(0, "Number of results: ".length()));	
		
		String numberOfResultsBottomInteger = numberOfResultsBottomElementText.substring(numberOfResultsBottomElementText.substring(0, "Number of results: ".length()).length());
		int numberOfResultsBottomInt = Integer.parseInt(numberOfResultsBottomInteger);
		
		assertEquals("'Number of Results' text should be the sameo for both the top and bottom 'Number of Results'!", numberOfResultsTopElementText, numberOfResultsBottomElementText);
		assertEquals("'Number of Results' integer value should be the same for both the top and bottom 'Number of Results'!", numberOfResultsTopInt, numberOfResultsBottomInt);
		
		WebElement dataTableElement = tableComponentElement.findElement(By.id("datatable"));
		assertNotNull("The 'datatable' element inside of the 'table' element does not exist!", dataTableElement);
		
		WebElement dataTableBodyElement = dataTableElement.findElement(By.tagName("tbody"));
		assertNotNull("The 'body' element inside of the 'datatable' element does not exist!", dataTableBodyElement);
		
		List<WebElement> tableRowElementsList = dataTableBodyElement.findElements(By.tagName("tr"));
		assertNotNull("No 'tr' element inside of the 'body' element of the 'table' element!", tableRowElementsList);
		
		int numberOfRowsInRejectClaimsTable = tableRowElementsList.size();
		assertTrue("Must have one or more rows in the Reject Claims Table!", numberOfRowsInRejectClaimsTable > 0);
		
		if (numberOfResultsTopInt < initialPageSizeOfTable) {
			assertEquals("The Number of Rows in the table should equal the 'Number of Results' value!'", numberOfResultsTopInt, numberOfRowsInRejectClaimsTable);
		} else {
			assertEquals("The Number of Rows in the table should equal the 'Page Size' value!", initialPageSizeOfTable, numberOfRowsInRejectClaimsTable);
		}
		
		System.out.println("RejectClaimsPageTest: End test_5_IfRejectedClaimsTableExists_VerifyCorrectNumberOfResultsAndTableRows()");
	}
	
	@Test
	public void test_6_IfRejectedClaimsTableExists_VerifyButtonsExistAndAreIntiallyDisabled() throws Exception { 
		System.out.println("RejectClaimsPageTest: Begin test_6_IfRejectedClaimsTableExists_VerifyButtonsExistAndAreIntiallyDisabled()");
		
		driver.get(rejectClaimsPageUrl);
		Thread.sleep(4000);
		
		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		
		assertEquals("Incorrect Page Title for Reject Claims Page!", 
				"Reject Claims", pageTitleElement.getText());
		
		WebElement sectionHeaderTitleElement = driver.findElement(By.id("sectionHeaderTitle"));
		assertNotNull(sectionHeaderTitleElement);
		
		assertEquals("Incorrect Section Header Title for Reject Claims Page!", 
				"Disapproved Claims", sectionHeaderTitleElement.getText());		
		
		WebElement tableComponentElement = null;
		try {
			tableComponentElement = driver.findElement(By.id("table"));
		} catch (NoSuchElementException ex) { }
		if (tableComponentElement == null) {
			return;
		}
		
		WebElement buttonElement = driver.findElement(By.id("upperOkDisapprovalButton"));
		String disabledAttribute = buttonElement.getAttribute("disabled");
		assertNotNull("Upper OK Disapproval Button should be disabled! No 'disabled' attribute present!", disabledAttribute);
		String classAttribute = buttonElement.getAttribute("class");
		assertNotNull("Upper OK Disapproval Button has no 'class' attribute!", classAttribute);
		assertTrue("Upper OK Disapproval Button does not contain 'disabled' string!", classAttribute.contains("disabled"));
		
		buttonElement = driver.findElement(By.id("upperReverseDisapprovalButton"));
		disabledAttribute = buttonElement.getAttribute("disabled");
		assertNotNull("Upper Reverse Disapproval Button should be disabled! No 'disabled' attribute present!", disabledAttribute);
		classAttribute = buttonElement.getAttribute("class");
		assertNotNull("Upper Reverse Disapproval Button has no 'class' attribute!", classAttribute);
		assertTrue("Upper Reverse Disapproval Button does not contain 'disabled' string!", classAttribute.contains("disabled"));
		
		buttonElement = driver.findElement(By.id("lowerOkDisapprovalButton"));
		disabledAttribute = buttonElement.getAttribute("disabled");
		assertNotNull("Lower OK Disapproval Button should be disabled! No 'disabled' attribute present!", disabledAttribute);
		classAttribute = buttonElement.getAttribute("class");
		assertNotNull("Lower OK Disapproval Button has no 'class' attribute!", classAttribute);
		assertTrue("Lower OK Disapproval Button does not contain 'disabled' string!", classAttribute.contains("disabled"));
		
		buttonElement = driver.findElement(By.id("lowerReverseDisapprovalButton"));
		disabledAttribute = buttonElement.getAttribute("disabled");
		assertNotNull("Lower Reverse Disapproval Button should be disabled! No 'disabled' attribute present!", disabledAttribute);
		classAttribute = buttonElement.getAttribute("class");
		assertNotNull("Lower Reverse Disapproval Button has no 'class' attribute!", classAttribute);
		assertTrue("Lower Reverse Disapproval Button does not contain 'disabled' string!", classAttribute.contains("disabled"));
		
		System.out.println("RejectClaimsPageTest: End test_6_IfRejectedClaimsTableExists_VerifyButtonsExistAndAreIntiallyDisabled()");
	}
	
	@Test
	public void test_7_IfRejectedClaimsTableExists_ClickOnSelectCheckBoxColumnAndVerifyButtonsExistAndAreEnabled() throws Exception { 
		System.out.println("RejectClaimsPageTest: Begin test_7_IfRejectedClaimsTableExists_ClickOnSelectCheckBoxColumnAndVerifyButtonsExistAndAreEnabled()");
		
		driver.get(rejectClaimsPageUrl);
		Thread.sleep(4000);
		
		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		
		assertEquals("Incorrect Page Title for Reject Claims Page!", 
				"Reject Claims", pageTitleElement.getText());
		
		WebElement sectionHeaderTitleElement = driver.findElement(By.id("sectionHeaderTitle"));
		assertNotNull(sectionHeaderTitleElement);
		
		assertEquals("Incorrect Section Header Title for Reject Claims Page!", 
				"Disapproved Claims", sectionHeaderTitleElement.getText());		
		
		WebElement tableComponentElement = null;
		try {
			tableComponentElement = driver.findElement(By.id("table"));
		} catch (NoSuchElementException ex) { }
		if (tableComponentElement == null) {
			return;
		}
		
		WebElement dataTableElement = tableComponentElement.findElement(By.id("datatable"));
		assertNotNull("The 'datatable' element inside of the 'table' element does not exist!", dataTableElement);
		
		WebElement selectedColumnElement = dataTableElement.findElement(By.id("selected"));
		assertNotNull("The 'selected' Column Header does not exist!", selectedColumnElement);
		
		WebElement columnCheckBoxElement = dataTableElement.findElement(By.name("colcheckbox"));
		columnCheckBoxElement.click();
		Thread.sleep(2000);

		WebElement buttonElement = driver.findElement(By.id("upperOkDisapprovalButton"));
		String disabledAttribute = buttonElement.getAttribute("disabled");
		assertNull("Upper OK Disapproval Button should be enabled! The 'disabled' attribute is present!", disabledAttribute);
		String classAttribute = buttonElement.getAttribute("class");
		assertNotNull("Upper OK Disapproval Button has no 'class' attribute!", classAttribute);
		assertFalse("Upper OK Disapproval Button contains 'disabled' string!", classAttribute.contains("disabled"));
		
		buttonElement = driver.findElement(By.id("upperReverseDisapprovalButton"));
		disabledAttribute = buttonElement.getAttribute("disabled");
		assertNull("Upper Reverse Disapproval Button should be enabled! The 'disabled' attribute is present!", disabledAttribute);
		classAttribute = buttonElement.getAttribute("class");
		assertNotNull("Upper Reverse Disapproval Button has no 'class' attribute!", classAttribute);
		assertFalse("Upper Reverse Disapproval Button contains 'disabled' string!", classAttribute.contains("disabled"));
		
		buttonElement = driver.findElement(By.id("lowerOkDisapprovalButton"));
		disabledAttribute = buttonElement.getAttribute("disabled");
		assertNull("Lower OK Disapproval Button should be enabled! The 'disabled' attribute is present!", disabledAttribute);
		classAttribute = buttonElement.getAttribute("class");
		assertNotNull("Lower OK Disapproval Button has no 'class' attribute!", classAttribute);
		assertFalse("Lower OK Disapproval Button contains 'disabled' string!", classAttribute.contains("disabled"));
		
		buttonElement = driver.findElement(By.id("lowerReverseDisapprovalButton"));
		disabledAttribute = buttonElement.getAttribute("disabled");
		assertNull("Lower Reverse Disapproval Button should be enabled! The 'disabled' attribute is present!", disabledAttribute);
		classAttribute = buttonElement.getAttribute("class");
		assertNotNull("Lower Reverse Disapproval Button has no 'class' attribute!", classAttribute);
		assertFalse("Lower Reverse Disapproval Button contains 'disabled' string!", classAttribute.contains("disabled"));
		
		System.out.println("RejectClaimsPageTest: End test_7_IfRejectedClaimsTableExists_ClickOnSelectCheckBoxColumnAndVerifyButtonsExistAndAreEnabled()");
	}
	
	@Test
	public void test_8_IfRejectedClaimsTableExists_ClickOnSelectCheckBoxColumnAndVerifyRowSelectionBoxesAreSelected() throws Exception { 
		System.out.println("RejectClaimsPageTest: Begin test_8_IfRejectedClaimsTableExists_ClickOnSelectCheckBoxColumnAndVerifyRowSelectionBoxesAreSelected()");
		
		driver.get(rejectClaimsPageUrl);
		Thread.sleep(4000);
		
		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		
		assertEquals("Incorrect Page Title for Reject Claims Page!", 
				"Reject Claims", pageTitleElement.getText());
		
		WebElement sectionHeaderTitleElement = driver.findElement(By.id("sectionHeaderTitle"));
		assertNotNull(sectionHeaderTitleElement);
		
		assertEquals("Incorrect Section Header Title for Reject Claims Page!", 
				"Disapproved Claims", sectionHeaderTitleElement.getText());		
		
		WebElement tableComponentElement = null;
		try {
			tableComponentElement = driver.findElement(By.id("table"));
		} catch (NoSuchElementException ex) { }
		if (tableComponentElement == null) {
			return;
		}
		
		WebElement dataTableElement = tableComponentElement.findElement(By.id("datatable"));
		assertNotNull("The 'datatable' element inside of the 'table' element does not exist!", dataTableElement);
		
		WebElement selectedColumnElement = dataTableElement.findElement(By.id("selected"));
		assertNotNull("The 'selected' Column Header does not exist!", selectedColumnElement);
		
		WebElement columnCheckBoxElement = selectedColumnElement.findElement(By.name("colcheckbox"));
		columnCheckBoxElement.click();
		Thread.sleep(2000);	
		
		WebElement dataTableBodyElement = dataTableElement.findElement(By.tagName("tbody"));
		assertNotNull("The 'body' element inside of the 'datatable' element does not exist!", dataTableBodyElement);
		
		List<WebElement> tableRowElementsList = dataTableBodyElement.findElements(By.tagName("tr"));
		assertNotNull("No 'tr' element inside of the 'body' element of the 'table' element!", tableRowElementsList);
		
		int numberOfRowsInRejectClaimsTable = tableRowElementsList.size();
		assertTrue("Must have one or more rows in the Reject Claims Table!", numberOfRowsInRejectClaimsTable > 0);
		
		for (int i = 0; i < numberOfRowsInRejectClaimsTable; i++) {
			WebElement tableRowElement = tableRowElementsList.get(i);
			WebElement selectedTdElement = tableRowElement.findElement(By.id("selected" + i));
			WebElement rowCheckBoxElement = selectedTdElement.findElement(By.name("rowcheckbox"));
			
			String ngReflectModel = rowCheckBoxElement.getAttribute("ng-reflect-model");
			assertEquals("Select Check Box in row #" + i + " should be in selected/checked state!", "true", ngReflectModel);
		}
		
		System.out.println("RejectClaimsPageTest: End test_8_IfRejectedClaimsTableExists_ClickOnSelectCheckBoxColumnAndVerifyRowSelectionBoxesAreSelected()");
	}
	
	@Test
	public void test_9_IfRejectedClaimsTableExists_ClickOnSelectCheckBoxInOneOfTheRowsAndVerifyButtonsExistAndAreEnabled() throws Exception { 
		System.out.println("RejectClaimsPageTest: Begin test_9_IfRejectedClaimsTableExists_ClickOnSelectCheckBoxInOneOfTheRowsAndVerifyButtonsExistAndAreEnabled()");
		
		driver.get(rejectClaimsPageUrl);
		Thread.sleep(4000);
		
		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		
		assertEquals("Incorrect Page Title for Reject Claims Page!", 
				"Reject Claims", pageTitleElement.getText());
		
		WebElement sectionHeaderTitleElement = driver.findElement(By.id("sectionHeaderTitle"));
		assertNotNull(sectionHeaderTitleElement);
		
		assertEquals("Incorrect Section Header Title for Reject Claims Page!", 
				"Disapproved Claims", sectionHeaderTitleElement.getText());		
		
		WebElement tableComponentElement = null;
		try {
			tableComponentElement = driver.findElement(By.id("table"));
		} catch (NoSuchElementException ex) { }
		if (tableComponentElement == null) {
			return;
		}
		
		WebElement dataTableElement = tableComponentElement.findElement(By.id("datatable"));
		assertNotNull("The 'datatable' element inside of the 'table' element does not exist!", dataTableElement);
		
		WebElement dataTableBodyElement = dataTableElement.findElement(By.tagName("tbody"));
		assertNotNull("The 'body' element inside of the 'datatable' element does not exist!", dataTableBodyElement);
		
		List<WebElement> tableRowElementsList = dataTableBodyElement.findElements(By.tagName("tr"));
		assertNotNull("No 'tr' element inside of the 'body' element of the 'table' element!", tableRowElementsList);
		
		int numberOfRowsInRejectClaimsTable = tableRowElementsList.size();
		assertTrue("Must have one or more rows in the Reject Claims Table!", numberOfRowsInRejectClaimsTable > 0);
		
		WebElement tableRowElement = tableRowElementsList.get(0);
		WebElement selectedTdElement = tableRowElement.findElement(By.id("selected0"));
		WebElement rowCheckBoxElement = selectedTdElement.findElement(By.name("rowcheckbox"));
				
		rowCheckBoxElement.click();
		Thread.sleep(2000);	
		
		WebElement buttonElement = driver.findElement(By.id("upperOkDisapprovalButton"));
		String disabledAttribute = buttonElement.getAttribute("disabled");
		assertNull("Upper OK Disapproval Button should be enabled! The 'disabled' attribute is present!", disabledAttribute);
		String classAttribute = buttonElement.getAttribute("class");
		assertNotNull("Upper OK Disapproval Button has no 'class' attribute!", classAttribute);
		assertFalse("Upper OK Disapproval Button contains 'disabled' string!", classAttribute.contains("disabled"));
		
		buttonElement = driver.findElement(By.id("upperReverseDisapprovalButton"));
		disabledAttribute = buttonElement.getAttribute("disabled");
		assertNull("Upper Reverse Disapproval Button should be enabled! The 'disabled' attribute is present!", disabledAttribute);
		classAttribute = buttonElement.getAttribute("class");
		assertNotNull("Upper Reverse Disapproval Button has no 'class' attribute!", classAttribute);
		assertFalse("Upper Reverse Disapproval Button contains 'disabled' string!", classAttribute.contains("disabled"));
		
		buttonElement = driver.findElement(By.id("lowerOkDisapprovalButton"));
		disabledAttribute = buttonElement.getAttribute("disabled");
		assertNull("Lower OK Disapproval Button should be enabled! The 'disabled' attribute is present!", disabledAttribute);
		classAttribute = buttonElement.getAttribute("class");
		assertNotNull("Lower OK Disapproval Button has no 'class' attribute!", classAttribute);
		assertFalse("Lower OK Disapproval Button contains 'disabled' string!", classAttribute.contains("disabled"));
		
		buttonElement = driver.findElement(By.id("lowerReverseDisapprovalButton"));
		disabledAttribute = buttonElement.getAttribute("disabled");
		assertNull("Lower Reverse Disapproval Button should be enabled! The 'disabled' attribute is present!", disabledAttribute);
		classAttribute = buttonElement.getAttribute("class");
		assertNotNull("Lower Reverse Disapproval Button has no 'class' attribute!", classAttribute);
		assertFalse("Lower Reverse Disapproval Button contains 'disabled' string!", classAttribute.contains("disabled"));
		
		System.out.println("RejectClaimsPageTest: End test_9_IfRejectedClaimsTableExists_ClickOnSelectCheckBoxInOneOfTheRowsAndVerifyButtonsExistAndAreEnabled()");
	}
}
