package testing;

import java.io.File;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.support.ui.Select;

import Pages.Acceptance;
import Pages.HeaderMenu;
import Pages.ModifyUserRequestPage;

public class OutOfSystemPaymentsTest {

  public static void main(String args[]) {
    JUnitCore junit = new JUnitCore();
    junit.addListener(new TextListener(System.out));
    Result result = junit.run(OutOfSystemPaymentsTest.class); // Replace "SampleTest" with the name of your class
    if (result.getFailureCount() > 0) {
      System.out.println("Test failed.\n" + result);
      System.exit(1);
    } else {
      System.out.println("Test finished successfully.");
      System.exit(0);
    }
  }

  static InternetExplorerDriver driver;
  static String baseURL;
  static Acceptance acceptance;
  static HeaderMenu headerMenu;
  static ModifyUserRequestPage page;

  @BeforeClass
  public static void setUpBeforeClass() throws Exception {
    System.out.println("ModifyUserRequestTest: Begin setUpBeforeClass()");

    File file = new File("drivers/IEDriverServer.exe");

    System.setProperty("webdriver.ie.driver", file.getAbsolutePath());

    driver = new InternetExplorerDriver();
    acceptance = new Acceptance(driver);
    headerMenu = new HeaderMenu(driver);
    page = new ModifyUserRequestPage(driver);
    baseURL = "http://localhost:4200/";
    driver.get(baseURL);
    Thread.sleep(5000);
    acceptance.ButtonAcceptClick();
    driver.get(baseURL + "manualReconcilation/104");
    Thread.sleep(5000);
    driver.findElements(By.xpath("//button[@class=\"button inline\"]")).get(0).click();
    Thread.sleep(5000);
    System.out.println("ModifyUserRequestTest: End setUpBeforeClass()");
  }

  @AfterClass
  public static void tearDownAfterClass() throws Exception {
    System.out.println("ModifyUserRequestTest: Begin tearDownAfterClass()");

    Thread.sleep(1000);
    driver.quit();

    System.out.println("ModifyUserRequestTest: End tearDownAfterClass()");
  }

  @Test
  /** Test Case #2 Verify that user can fill out the out of system payment page ****/
  public void testForm() throws Exception {
    System.out.println("ModifyUserRequestTest: Begin testForm()");
    Assert.assertTrue(driver.findElement(By.cssSelector("[for='paymentType']")).getAttribute("innerHTML").contains("Required"));
    Assert.assertTrue(driver.findElement(By.cssSelector("[for='checkNumber']")).getAttribute("innerHTML").contains("Required"));
    Assert.assertTrue(driver.findElement(By.cssSelector("[for='paymentDate']")).getAttribute("innerHTML").contains("Required"));
    Assert.assertTrue(driver.findElement(By.cssSelector("[for='paymentAmount']")).getAttribute("innerHTML").contains("Required"));
    Assert.assertTrue(driver.findElements(By.xpath("//label[@for=\"paymentAmount\"]/span[@class=\"info\"]")).size() > 0);

    (new Select(driver.findElement(By.id("paymentType")))).selectByIndex(2);
    Assert.assertTrue(!driver.findElement(By.cssSelector("[for='paymentType']")).getAttribute("innerHTML").contains("Required"));
    driver.findElement(By.id("checkNumber")).sendKeys("1234");
    Assert.assertTrue(!driver.findElement(By.cssSelector("[for='checkNumber']")).getAttribute("innerHTML").contains("Required"));
    driver.findElement(By.id("paymentDate")).sendKeys("1234");
    Assert.assertTrue(!driver.findElement(By.cssSelector("[for='paymentDate']")).getAttribute("innerHTML").contains("Required"));

    driver.findElement(By.id("paymentAmount")).sendKeys("1234");
    Assert.assertTrue(!driver.findElement(By.cssSelector("[for='paymentAmount']")).getAttribute("innerHTML").contains("Required"));
    Assert.assertTrue(driver.findElements(By.xpath("//label[@for=\"paymentAmount\"]/span[@class=\"error\"]")).size() > 0);

    driver.findElement(By.id("adjustmentAmount")).sendKeys("12.34");

  }

  // clear() sets value to null, which is allowable. Must set the value to an empty string by backspacing
  public void softClear(WebElement e) {
    e.clear();
    e.sendKeys("a\b");
  }
}
