/**
 * 
 */
package testing;

import static org.junit.Assert.*;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.ie.InternetExplorerDriver;

/**
 * @author DNS   PEREZF
 *
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class OkDisapprovalTest {
	private WebDriver driver;
	private String baseUrl;
	private String rejectClaimsPageUrl;
	
	public static void main(String args[]) {
		JUnitCore junit = new JUnitCore();
		junit.addListener(new TextListener(System.out));
		Result result = junit.run(OkDisapprovalTest.class); // Replace "SampleTest" with the name of your class
		if (result.getFailureCount() > 0) {
		    System.out.println("Test failed.\n" + result);
		    System.exit(1);
		} else {
		    System.out.println("Test finished successfully.");
		    System.exit(0);
		}
	}

	/**
	 * @throws java.lang.Exception
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("RejectClaimsPageTest: Begin setUpBeforeClass()");
		System.out.println("RejectClaimsPageTest: End setUpBeforeClass()");
	}

	/**
	 * @throws java.lang.Exception
	 */
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
		System.out.println("ARejectClaimsPageTest: Begin tearDownAfterClass()");
		System.out.println("RejectClaimsPageTest: End tearDownAfterClass()");
	}

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
		System.out.println("RejectClaimsPageTest: Begin setUp()");
		
		File file = new File("drivers/IEDriverServer.exe");
		System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
		driver = new InternetExplorerDriver();
		
		baseUrl = "http://localhost:4200";
		driver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);

		goToLoginPageAndClickLoginButton();
		Thread.sleep(5000);
		clickSetActiveButton();

		rejectClaimsPageUrl = baseUrl + "/reject";
		
		Thread.sleep(3000);
		
		System.out.println("RejectClaimsPageTest: End setUp()");
	}
	
	private void clickSetActiveButton() throws Exception {
		WebElement setActiveButton = driver.findElement(By.id("setActive"));
		assertNotNull(setActiveButton);
		setActiveButton.click();
		// setActiveButton.submit(); // Not inside of a "form" element.
		setActiveButton.sendKeys(Keys.ENTER);
	}

	private void goToLoginPageAndClickLoginButton() throws Exception {
		driver.get(baseUrl);
		WebElement loginButton = driver.findElement(By.id("loginBtn"));
		assertNotNull(loginButton);
		
		// Click the Login Button. Had to do this as advised by Joshua Lone
		// to get this to work to forward to next page.
		loginButton.click();
		loginButton.submit();
		loginButton.sendKeys(Keys.ENTER);
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
		System.out.println("RejectClaimsPageTest: Begin tearDown()");
		
		Thread.sleep(5000);
		driver.close();
		driver.quit();
		Thread.sleep(5000);
		System.out.println("End Executing 'tearDown' method");
		
		System.out.println("RejectClaimsPageTest: End tearDown()");
	}

	@Test
	public void test_1_okDisapprovalFunctionality() throws Exception {
		System.out.println("RejectClaimsPageTest: Begin test_1_RejectClaimsPageAppearsWhenGoingDirectly()");
		
		driver.get(rejectClaimsPageUrl);
		Thread.sleep(3000);
		
		WebElement checkbox = driver.findElement(By.id("checkBox0"));
		checkbox.click();
		driver.findElement(By.id("lowerOkDisapprovalButton")).click();
		WebElement successMsg = driver.findElement(By.id("successfulClaimsDisapprovalMessage"));
		
		assertTrue(successMsg.getText().contains("Accepted disapproval of Claim(s):"));
		
	}
	
}
