package testing;

import java.io.File;
import java.util.Random;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.ie.InternetExplorerDriver;

import Pages.Acceptance;
import Pages.HeaderMenu;
import Pages.ModifyUserRequestPage;

public class ModifyUserRequestTest {

  public static void main(String args[]) {
    JUnitCore junit = new JUnitCore();
    junit.addListener(new TextListener(System.out));
    Result result = junit.run(ModifyUserRequestTest.class); // Replace "SampleTest" with the name of your class
    if (result.getFailureCount() > 0) {
      System.out.println("Test failed.\n" + result);
      System.exit(1);
    } else {
      System.out.println("Test finished successfully.");
      System.exit(0);
    }
  }

  static InternetExplorerDriver driver;
  static String baseURL;
  static Acceptance acceptance;
  static HeaderMenu headerMenu;
  static ModifyUserRequestPage page;

  @BeforeClass
  public static void setUpBeforeClass() throws Exception {
    System.out.println("ModifyUserRequestTest: Begin setUpBeforeClass()");

    File file = new File("drivers/IEDriverServer.exe");

    System.setProperty("webdriver.ie.driver", file.getAbsolutePath());

    driver = new InternetExplorerDriver();
    acceptance = new Acceptance(driver);
    headerMenu = new HeaderMenu(driver);
    page = new ModifyUserRequestPage(driver);
    baseURL = "http://localhost:4200/";
    driver.get(baseURL);
    Thread.sleep(1000);
    acceptance.ButtonAcceptClick();
    driver.get(baseURL + "modifyUserRequest");
    Thread.sleep(3000);
    System.out.println("ModifyUserRequestTest: End setUpBeforeClass()");
  }

  @AfterClass
  public static void tearDownAfterClass() throws Exception {
    System.out.println("ModifyUserRequestTest: Begin tearDownAfterClass()");

    Thread.sleep(1000);
    driver.quit();

    System.out.println("ModifyUserRequestTest: End tearDownAfterClass()");
  }

  @Test
  /** Test Case #2 Verify that user is able to create a new user request ****/
  public void testForm() throws Exception {
    System.out.println("ModifyUserRequestTest: Begin testForm()");

    Random rand = new Random();
    String n = String.valueOf(rand.nextInt(Integer.MAX_VALUE));

    // wait for prepopulated data to come in - should fill every field except for disable comments
    Thread.sleep(3000);

    Assert.assertTrue(page.buttonSubmit.getAttribute("disabled") == null);
    Assert.assertTrue(!page.labelWinNT.getAttribute("innerText").contains("Required"));
    softClear(page.inputWinNTName);
    Assert.assertTrue(page.labelWinNT.getAttribute("innerText").contains("Required"));
    page.inputWinNTName.sendKeys(";");
    Assert.assertTrue(page.labelWinNT.getAttribute("innerText").contains("Alphanumeric Only"));

    Assert.assertTrue(!page.labelFirstName.getAttribute("innerText").contains("Required"));
    softClear(page.inputFirstName);
    Assert.assertTrue(page.labelFirstName.getAttribute("innerText").contains("Required"));
    page.inputFirstName.sendKeys(";");
    Assert.assertTrue(page.labelFirstName.getAttribute("innerText").contains("Alphanumeric Only"));

    Assert.assertTrue(!page.labelMiddleName.getAttribute("innerText").contains("Required"));
    softClear(page.inputMiddleName);
    Assert.assertTrue(!page.labelMiddleName.getAttribute("innerText").contains("Required"));
    page.inputMiddleName.sendKeys(";");
    Assert.assertTrue(page.labelMiddleName.getAttribute("innerText").contains("Alphanumeric Only"));

    Assert.assertTrue(!page.labelLastName.getAttribute("innerText").contains("Required"));
    softClear(page.inputLastName);
    Assert.assertTrue(page.labelLastName.getAttribute("innerText").contains("Required"));
    page.inputLastName.sendKeys(";");
    Assert.assertTrue(page.labelLastName.getAttribute("innerText").contains("Alphanumeric Only"));

    Assert.assertTrue(!page.labelPhone.getAttribute("innerText").contains("Required"));
    Assert.assertTrue(!page.labelPhone.getAttribute("innerText").contains("Numbers Only"));
    softClear(page.inputPhone);
    Assert.assertTrue(!page.labelPhone.getAttribute("innerText").contains("Required"));
    page.inputPhone.sendKeys("TestUser" + n);
    Assert.assertTrue(page.labelPhone.getAttribute("innerText").contains("Incorrect characters"));

    Assert.assertTrue(!page.labelEmail.getAttribute("innerText").contains("Required"));
    Assert.assertTrue(!page.labelEmail.getAttribute("innerText").contains("Please enter valid email"));
    softClear(page.inputEmail);
    page.inputEmail.sendKeys("asdf");
    Assert.assertTrue(page.labelEmail.getAttribute("innerText").contains("Please enter valid email"));

    Assert.assertTrue(!page.labelComment.getAttribute("innerText").contains("Required when changing user from Enabled to Disabled"));
    page.inputEnabled.click();
    Assert.assertTrue(page.labelComment.getAttribute("innerText").contains("Required when changing user from Enabled to Disabled"));
    page.inputComment.sendKeys("This user was a very b@d guy.");
    Assert.assertTrue(!page.labelComment.getAttribute("innerText").contains("Required when changing user from Enabled to Disabled"));

    Assert.assertTrue(page.buttonSubmit.getAttribute("disabled") != null);

    Assert.assertTrue(page.assignedRoles.getAttribute("innerHTML").contains("FEE_VISN_PGM_MANAGER"));
    Assert.assertTrue(!page.assignedRoles.getAttribute("innerHTML").contains("FEE SUPERVISOR"));
    Assert.assertTrue(!page.availableRoles.getAttribute("innerHTML").contains("FEE_VISN_PGM_MANAGER"));
    Assert.assertTrue(page.availableRoles.getAttribute("innerHTML").contains("FEE SUPERVISOR"));
    driver.findElement(By.id("assignAllRoles")).click();
    Assert.assertTrue(page.assignedRoles.getAttribute("innerHTML").contains("FEE CLERK"));
    Assert.assertTrue(!page.availableRoles.getAttribute("innerHTML").contains("FEE CLERK"));
    driver.findElement(By.id("removeAllRoles")).click();
    Assert.assertTrue(!page.assignedRoles.getAttribute("innerHTML").contains("FEE CLERK"));
    Assert.assertTrue(page.availableRoles.getAttribute("innerHTML").contains("FEE CLERK"));

    Assert.assertTrue(!page.assignedFacilities.getAttribute("innerHTML").contains("580"));
    Assert.assertTrue(page.availableFacilities.getAttribute("innerHTML").contains("580"));
    Assert.assertTrue(page.availableFacilities.getAttribute("innerHTML").contains("580"));
    Assert.assertTrue(!page.assignedFacilities.getAttribute("innerHTML").contains("580"));
    driver.findElement(By.id("assignAllFacilities")).click();
    Assert.assertTrue(page.assignedFacilities.getAttribute("innerHTML").contains("580"));
    Assert.assertTrue(!page.availableFacilities.getAttribute("innerHTML").contains("580"));
    driver.findElement(By.id("removeAllFacilities")).click();
    Assert.assertTrue(!page.assignedFacilities.getAttribute("innerHTML").contains("580"));
    Assert.assertTrue(page.availableFacilities.getAttribute("innerHTML").contains("580"));

    page.inputWinNTName.clear();
    page.inputWinNTName.sendKeys("TestUser1" + n);
    page.inputFirstName.clear();
    page.inputFirstName.sendKeys("TestFirst");
    page.inputMiddleName.clear();
    page.inputMiddleName.sendKeys("TestMiddle");
    page.inputLastName.clear();
    page.inputLastName.sendKeys("TestLast");
    page.inputPhone.clear();
    page.inputPhone.sendKeys("(123)-123-1234+123");
    page.inputEmail.clear();
    page.inputEmail.sendKeys("dre@dhawk.com");
    Assert.assertTrue(page.buttonSubmit.getAttribute("disabled") == null);

    page.buttonSubmit.click();

    // Test submission and successful response message
    Thread.sleep(3000);
    Assert.assertTrue(driver.findElement(By.id("successMessage")).isDisplayed());

    // submit same info, check for (lack of) duplicate error
    page.buttonSubmit.click();
    Thread.sleep(2000);
    Assert.assertTrue(driver.findElement(By.id("successMessage")).isDisplayed());

    System.out.println("ModifyUserRequestTest: End testForm()");
  }

  // clear() sets value to null, which is allowable. Must set the value to an empty string by backspacing
  public void softClear(WebElement e) {
    e.clear();
    e.sendKeys("a\b");
  }
}
