package testing;

import java.io.File;
import java.util.concurrent.TimeUnit;
import static org.junit.Assert.*;
import org.openqa.selenium.*;
import org.openqa.selenium.ie.InternetExplorerDriver;

import Pages.Acceptance;
import Pages.CreateUserRequestPage;
import Pages.HeaderMenu;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;


public class MedicalCodeLookUp {
	static InternetExplorerDriver driver;
	  static String baseURL;
	  static Acceptance acceptance;
	  static HeaderMenu headerMenu;
	  static CreateUserRequestPage page;
	  
  public static void main(String args[]) {
	    JUnitCore junit = new JUnitCore();
	    junit.addListener(new TextListener(System.out));
	    Result result = junit.run(MedicalCodeLookUp.class); // Replace "SampleTest" with the name of your class
	    if (result.getFailureCount() > 0) {
	      System.out.println("Test failed.\n" + result);
	      System.exit(1);
	    } else {
	      System.out.println("Test finished successfully.");
	      System.exit(0);
	    }
	  }

  @Before
  public void setUp() throws Exception {
	  System.out.println("MedicalCodeLookUp: Begin setUp()");
	  
	  File file = new File("drivers/IEDriverServer.exe");
	  System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
	  
	  driver = new InternetExplorerDriver();
	  acceptance = new Acceptance(driver);
	  headerMenu = new HeaderMenu(driver);
	  page = new CreateUserRequestPage(driver);
	  baseURL = "http://localhost:4200/";
	  driver.get(baseURL);
	  driver.manage().window().maximize();
	  Thread.sleep(1000);
	  acceptance.ButtonAcceptClick();
	  
	  System.out.println("MedicalCodeLookUp: End setUp()");
  }

  @Test
  public void testClientDetails() throws Exception {
	  System.out.println("MedicalCodeLookUp: Begin testClientDetails()");
	  
	  Thread.sleep(1000);
	  driver.get(baseURL+"awaitingProcessing");
	  Thread.sleep(1000);
//	  driver.findElement(By.linkText("118")).sendKeys(Keys.ENTER);
//	  Thread.sleep(5000);
//	  driver.findElement(By.xpath("//*[text()[contains(.,'Establish')]]"))
	  additionalInfo();
	  
	  // Commenting out because the below methods were undefined!
	  /*
	  diagnosisCodes();
	  lineItems();
	  reroutingHistory();
	  rejectionHistory();
	  */
	  
	  System.out.println("MedicalCodeLookUp: End testClientDetails()");
    }

  public void additionalInfo() throws Exception {
	  Thread.sleep(5000);
	  driver.findElement(By.linkText("100")).sendKeys(Keys.ENTER);
	  Thread.sleep(5000);
	  if( driver.findElement(By.id("tab1-content")).getAttribute("innerHTML").contains("medicalCode")){
		  System.out.println("found Additional Info");
		  driver.get(baseURL+"awaitingProcessing");
		  
	  }else{
		  System.out.println(driver.findElement(By.id("tableHeaderClaimStatus")).getAttribute("innerHTML"));
		  System.out.println("Didn't find Additional Info");
		  driver.get(baseURL+"awaitingProcessing");
	  }
  }

  
  @After
  public void tearDown() throws Exception {
    driver.quit();
    Object verificationErrors = null;
	String verificationErrorString = verificationErrors.toString();
    if (!"".equals(verificationErrorString)) {
      fail(verificationErrorString);
    }
  }

  private boolean isElementPresent(By by) {
    try {
      driver.findElement(by);
      return true;
    } catch (NoSuchElementException e) {
      return false;
    }
  }

  private boolean isAlertPresent() {
    try {
      driver.switchTo().alert();
      return true;
    } catch (NoAlertPresentException e) {
      return false;
    }
  }

}
