package testing;

import java.io.File;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.ie.InternetExplorerDriver;

import Pages.Acceptance;
import Pages.CreateUserRequestPage;
import Pages.HeaderMenu;

/**
 * 
 * @author Muneshwar Baiah
 * Manual Reconciliation Page Tests
 *
 */
public class ManualReconciliationTest {
	static InternetExplorerDriver driver;
	  static String baseURL;
	  static Acceptance acceptance;
	  static HeaderMenu headerMenu;
	  static CreateUserRequestPage page;
	  
  public static void main(String args[]) {
	    JUnitCore junit = new JUnitCore();
	    junit.addListener(new TextListener(System.out));
	    Result result = junit.run(ManualReconciliationTest.class); 
	    if (result.getFailureCount() > 0) {
	      System.out.println("Test failed.\n" + result);
	      System.exit(1);
	    } else {
	      System.out.println("Test finished successfully.");
	      System.exit(0);
	    }
	  }

  @Before
  public void setUp() throws Exception {
	  System.out.println("ManualReconciliationTest: Begin setUp()");
	  
	  File file = new File("drivers/IEDriverServer.exe");
	  System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
	  
	  driver = new InternetExplorerDriver();
	  acceptance = new Acceptance(driver);
	  headerMenu = new HeaderMenu(driver);
	  page = new CreateUserRequestPage(driver);
	  baseURL = "http://localhost:4200/";
	  driver.get(baseURL);
	  driver.manage().window().maximize();
	  Thread.sleep(1040);
	  acceptance.ButtonAcceptClick();
	  
	  System.out.println("ManualReconciliationTest: End setUp()");
  }

  @Test
  public void testManualReconciliation() throws Exception {
	  System.out.println("ManualReconciliationTest: Begin ManualReconciliationTest()");
	  
	  // Getting into awaiting claims page
	  Thread.sleep(1040);
	  driver.get(baseURL+"awaitingProcessing");
	  
	  // Choosing the claim with the claim id : 104 and moving the claim details page
	  Thread.sleep(5000);
	  driver.findElement(By.linkText("104")).sendKeys(Keys.ENTER);
	  
	  // Clicking the Manual Reconciliation button
	  Thread.sleep(3000);
	  System.out.println(" Clicking the manual reconciliation button");
	  
	 driver.findElement(By.id("manualReconcile")).click();
	  
	 // driver.get(baseURL+"manualReconcilation");
	  Thread.sleep(5000);
	 
	  System.out.println(" Testing the manual reconciliation page elements");
	  testPageTitle();
	  testClaimData();
	  System.out.println("ManualReconcilation: End testClientDetails()");
    }

  public void testPageTitle() throws Exception {
	  Thread.sleep(5000);
	  if( driver.findElement(By.className("page-title")).getAttribute("innerHTML").contains("Manual Reconciliation")){
		  System.out.println("Page title manual reconciliation found "); 
	  } else {
		  System.out.println("Page title manual reconciliation not found ");   
	  }
  }
  
  public void testClaimData() throws Exception {
	  Thread.sleep(1040);
	 Assert.assertTrue( driver.findElement(By.id("claimData")).getAttribute("innerHTML").contains("Claim ID"));
	 Assert.assertTrue( driver.findElement(By.id("claimData")).getAttribute("innerHTML").contains("Veteran Name"));
	 Assert.assertTrue( driver.findElement(By.id("claimData")).getAttribute("innerHTML").contains("Claim Type"));
	 Assert.assertTrue( driver.findElement(By.id("claimData")).getAttribute("innerHTML").contains("Billing Provider Name"));
	 Assert.assertTrue( driver.findElement(By.id("claimData")).getAttribute("innerHTML").contains("Status"));
	 Assert.assertTrue( driver.findElement(By.id("claimData")).getAttribute("innerHTML").contains("Service Provider Name"));
  }

  public void testLineItemData() throws Exception {
	  Thread.sleep(1040);
	 Assert.assertTrue( driver.findElement(By.id("lineItemsData")).getAttribute("innerHTML").contains("Line Items"));
	 Assert.assertTrue( driver.findElement(By.id("lineItemsData")).getAttribute("innerHTML").contains("Line No."));
	 Assert.assertTrue( driver.findElement(By.id("lineItemsData")).getAttribute("innerHTML").contains("Billed Amount"));
	 Assert.assertTrue( driver.findElement(By.id("lineItemsData")).getAttribute("innerHTML").contains("Billed Unit"));
	 Assert.assertTrue( driver.findElement(By.id("lineItemsData")).getAttribute("innerHTML").contains("Description"));
	 Assert.assertTrue( driver.findElement(By.id("lineItemsData")).getAttribute("innerHTML").contains("Service Date From"));
	 Assert.assertTrue( driver.findElement(By.id("lineItemsData")).getAttribute("innerHTML").contains("Service Date To"));
	 Assert.assertTrue( driver.findElement(By.id("lineItemsData")).getAttribute("innerHTML").contains("Action"));
  }
  
  @After
  public void tearDown() throws Exception {
    driver.quit();
    System.out.println("Exited testing the Manual Reconciliation Page!"); 
  }

}
