package testing;

import static org.junit.Assert.assertTrue;

import java.io.File;

import org.junit.Before;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.By;
import org.openqa.selenium.ie.InternetExplorerDriver;

import Pages.Acceptance;
import Pages.HeaderMenu;

public class DisapproveTest {
	static InternetExplorerDriver driver;
	static String baseURL;
	static Acceptance acceptance;
	static HeaderMenu headerMenu;
	static CreateUserRequestPage page;

	public static void main(String args[]) {
		JUnitCore junit = new JUnitCore();
		junit.addListener(new TextListener(System.out));
		Result result = junit.run(DisapproveTest.class); // Replace
																// "SampleTest"
																// with the name
																// of your class
		if (result.getFailureCount() > 0) {
			System.out.println("Test failed.\n" + result);
			System.exit(1);
		} else {
			System.out.println("Test finished successfully.");
			System.exit(0);
		}
	}

	@Before
	public void setUp() throws Exception {
		System.out.println("DisapproveTest: Begin setUp()");
		
		File file = new File("drivers/IEDriverServer.exe");
		System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
		
		driver = new InternetExplorerDriver();
		acceptance = new Acceptance(driver);
		headerMenu = new HeaderMenu(driver);
		page = new CreateUserRequestPage(driver);
		baseURL = "http://localhost:4200/";
		driver.get(baseURL);
		driver.manage().window().maximize();
		Thread.sleep(1000);
		acceptance.ButtonAcceptClick();
		
		System.out.println("DisapproveTest: End setUp()");
	}

	@Test
	public void testClientDetails() throws Exception {
		System.out.println("DisapproveTest: Begin testClientDetails()");
		
		Thread.sleep(1000);
		driver.get(baseURL + "awaitingProcessing");
		Thread.sleep(1000);
		driver.findElement(By.name("colcheckbox")).click();
		Thread.sleep(3000);
		driver.findElement(By.id("lowerDisapprove")).click();
		// driver.findElement(By.linkText("118")).sendKeys(Keys.ENTER);
		Thread.sleep(5000);
		// driver.findElement(By.xpath("//*[text()[contains(.,'Establish')]]"))

		if (driver.findElement(By.id("header")).getAttribute("innerHTML").contains("Claims to Disapprove")) {
			// driver.get(baseURL+"awaitingProcessing");
			System.out.println("found Header");
			assertTrue(driver.findElements(By.id("reason")).size() > 0);
			driver.findElement(By.id("comments")).sendKeys("test1234");
			assertTrue(driver.findElements(By.id("pageSummary")).size() > 0);
		}
		Thread.sleep(5000);
		
		System.out.println("DisapproveTest: End testClientDetails()");
	}
}
