package testing;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.io.File;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.By;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.support.ui.Select;

import Pages.Acceptance;
import Pages.HeaderMenu;

public class DisapproveExecuteTest {
	static InternetExplorerDriver driver;
	static String baseURL;
	static Acceptance acceptance;
	static HeaderMenu headerMenu;
	static CreateUserRequestPage page;

	public static void main(String args[]) {
		JUnitCore junit = new JUnitCore();
		junit.addListener(new TextListener(System.out));
		Result result = junit.run(DisapproveExecuteTest.class); 
		if (result.getFailureCount() > 0) {
			System.out.println("Test failed.\n" + result);
			System.exit(1);
		} else {
			System.out.println("Test finished successfully.");
			System.exit(0);
		}
	}

	@Before
	public  void setUp() throws Exception {
		System.out.println("DisapproveExecuteTest: Begin setUp()");
		
		File file = new File("drivers/IEDriverServer.exe");
		System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
		
		driver = new InternetExplorerDriver();
		acceptance = new Acceptance(driver);
		headerMenu = new HeaderMenu(driver);
		baseURL = "http://localhost:4200/";
		driver.get(baseURL);
		driver.manage().window().maximize();
		Thread.sleep(2000);
		acceptance.ButtonAcceptClick();
		Thread.sleep(2000);
		driver.get(baseURL + "awaitingProcessing");
		Thread.sleep(2000);
		driver.findElement(By.id("select0")).click();
		Thread.sleep(2000);
		driver.findElement(By.id("lowerDisapprove")).click();
		Thread.sleep(3000);
		
		System.out.println("DisapproveExecuteTest: End setUp()");
	}

	@Test
	public void testDisapprovePage() throws Exception {
		System.out.println("DisapproveExecuteTest: Begin testDisapprovePage()");

		assertTrue(driver.findElement(By.id("header")).getAttribute("innerHTML").contains("Claims to Disapprove"));
		Thread.sleep(2000);
		
		System.out.println("DisapproveExecuteTest: End testDisapprovePage()");
	}
	
	@Test
	public void testButtonDisabled() throws Exception {
		System.out.println("DisapproveExecuteTest: Begin testButtonDisabled()");
		
		assertFalse(driver.findElement(By.id("disapproveButton")).isEnabled());
		
		System.out.println("DisapproveExecuteTest: End testButtonDisabled()");
	}
	
	@Test
	public void testReasonCodesExist() throws Exception {
		System.out.println("DisapproveExecuteTest: Begin testReasonCodesExist()");
		
		assertTrue(driver.findElements(By.id("reason")).size() > 0);
		
		System.out.println("DisapproveExecuteTest: End testReasonCodesExist()");
	}
	
	@Test
	public void testIsDisapproveEnabled() throws Exception {
		System.out.println("DisapproveExecuteTest: Begin testIsDisapproveEnabled()");
		
		enterForm();
		assertTrue(driver.findElement(By.id("disapproveButton")).isEnabled());
		
		System.out.println("DisapproveExecuteTest: End testIsDisapproveEnabled()");
	}
	
	@Test
	public void testPageSummaryExists() throws Exception {
		System.out.println("DisapproveExecuteTest: Begin testPageSummaryExists()");
		
		assertTrue(driver.findElements(By.id("pageSummary")).size() > 0);
		
		System.out.println("DisapproveExecuteTest: End testPageSummaryExists()");
	}
	
	@Test
	public void testConfirmationMessage() throws Exception {
		System.out.println("DisapproveExecuteTest: Begin testConfirmationMessage()");
		
		enterForm();
		driver.findElement(By.id("disapproveButton")).click();
		Thread.sleep(2000);
		assertTrue(driver.findElementById("successfulClaimsDisapprovalMessage").getAttribute("innerHTML").contains("Success: Disapproval Completed"));
		
		System.out.println("DisapproveExecuteTest: End testConfirmationMessage()");
	}
	
	void enterForm(){
		Select dropdown = new Select(driver.findElement(By.id("reason")));
		dropdown.selectByIndex(1);
		try {
			Thread.sleep(2000);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		driver.findElement(By.id("comments")).sendKeys("Test Comment");
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
